/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Tvm;

public final class Processing {
    public static void monitorMessages(int ctxId, String queue, MessageMonitoringParams[] messages) throws EverSdkException {
        EverSdk.asyncVoid(ctxId, "processing.monitor_messages", new ParamsOfMonitorMessages(queue, messages));
    }

    public static CompletableFuture<MonitoringQueueInfo> getMonitorInfo(int ctxId, String queue) throws EverSdkException {
        return EverSdk.async(ctxId, "processing.get_monitor_info", new ParamsOfGetMonitorInfo(queue), MonitoringQueueInfo.class);
    }

    public static CompletableFuture<ResultOfFetchNextMonitorResults> fetchNextMonitorResults(int ctxId, String queue, MonitorFetchWaitMode waitMode) throws EverSdkException {
        return EverSdk.async(ctxId, "processing.fetch_next_monitor_results", new ParamsOfFetchNextMonitorResults(queue, waitMode), ResultOfFetchNextMonitorResults.class);
    }

    public static void cancelMonitor(int ctxId, String queue) throws EverSdkException {
        EverSdk.asyncVoid(ctxId, "processing.cancel_monitor", new ParamsOfCancelMonitor(queue));
    }

    public static CompletableFuture<ResultOfSendMessages> sendMessages(int ctxId, MessageSendingParams[] messages, String monitorQueue) throws EverSdkException {
        return EverSdk.async(ctxId, "processing.send_messages", new ParamsOfSendMessages(messages, monitorQueue), ResultOfSendMessages.class);
    }

    public static CompletableFuture<ResultOfSendMessage> sendMessage(int ctxId, String message, Abi.ABI abi, Boolean sendEvents, Consumer<JsonNode> callback) throws EverSdkException {
        return EverSdk.asyncCallback(ctxId, "processing.send_message", new ParamsOfSendMessage(message, abi, sendEvents), ResultOfSendMessage.class, callback);
    }

    public static CompletableFuture<ResultOfProcessMessage> waitForTransaction(int ctxId, Abi.ABI abi, String message, String shardBlockId, Boolean sendEvents, String[] sendingEndpoints, Consumer<JsonNode> callback) throws EverSdkException {
        return EverSdk.asyncCallback(ctxId, "processing.wait_for_transaction", new ParamsOfWaitForTransaction(abi, message, shardBlockId, sendEvents, sendingEndpoints), ResultOfProcessMessage.class, callback);
    }

    public static CompletableFuture<ResultOfProcessMessage> processMessage(int ctxId, Abi.ABI abi, String address, Abi.DeploySet deploySet, Abi.CallSet callSet, Abi.Signer signer, Integer processingTryIndex, Long signatureId, Boolean sendEvents) throws EverSdkException {
        return EverSdk.async(ctxId, "processing.process_message", new ParamsOfProcessMessage(new Abi.ParamsOfEncodeMessage(abi, address, deploySet, callSet, signer, processingTryIndex, signatureId), sendEvents), ResultOfProcessMessage.class);
    }

    public record ParamsOfMonitorMessages(String queue, MessageMonitoringParams[] messages) {
    }

    public record MessageMonitoringParams(MonitoredMessage message, Long waitUntil, JsonNode userData) {
    }

    public record ParamsOfGetMonitorInfo(String queue) {
    }

    public record MonitoringQueueInfo(Long unresolved, Long resolved) {
    }

    public record ParamsOfFetchNextMonitorResults(String queue, MonitorFetchWaitMode waitMode) {
    }

    public static enum MonitorFetchWaitMode {
        AtLeastOne,
        All,
        NoWait;

    }

    public record ResultOfFetchNextMonitorResults(MessageMonitoringResult[] results) {
    }

    public record ParamsOfCancelMonitor(String queue) {
    }

    public record ParamsOfSendMessages(MessageSendingParams[] messages, String monitorQueue) {
    }

    public record MessageSendingParams(String boc, Long waitUntil, JsonNode userData) {
    }

    public record ResultOfSendMessages(MessageMonitoringParams[] messages) {
    }

    public record ParamsOfSendMessage(String message, Abi.ABI abi, Boolean sendEvents) {
    }

    public record ResultOfSendMessage(String shardBlockId, String[] sendingEndpoints) {
    }

    public record ParamsOfWaitForTransaction(Abi.ABI abi, String message, String shardBlockId, Boolean sendEvents, String[] sendingEndpoints) {
    }

    public record ResultOfProcessMessage(JsonNode transaction, String[] outMessages, DecodedOutput decoded, Tvm.TransactionFees fees) {
    }

    public record ParamsOfProcessMessage(Abi.ParamsOfEncodeMessage messageEncodeParams, Boolean sendEvents) {
    }

    public static enum ProcessingErrorCode {
        MessageAlreadyExpired(501),
        MessageHasNotDestinationAddress(502),
        CanNotBuildMessageCell(503),
        FetchBlockFailed(504),
        SendMessageFailed(505),
        InvalidMessageBoc(506),
        MessageExpired(507),
        TransactionWaitTimeout(508),
        InvalidBlockReceived(509),
        CanNotCheckBlockShard(510),
        BlockNotFound(511),
        InvalidData(512),
        ExternalSignerMustNotBeUsed(513),
        MessageRejected(514),
        InvalidRempStatus(515),
        NextRempStatusTimeout(516);

        private final Integer value;

        private ProcessingErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public record MessageMonitoringResult(String hash, MessageMonitoringStatus status, MessageMonitoringTransaction transaction, String error, JsonNode userData) {
    }

    public static enum MessageMonitoringStatus {
        Finalized,
        Timeout,
        Reserved;

    }

    public record MessageMonitoringTransactionCompute(Long exitCode) {
    }

    public static sealed interface ProcessingEvent {

        public record RempError(String messageId, String messageDst, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempError";
            }
        }

        public record RempOther(String messageId, String messageDst, BigInteger timestamp, JsonNode json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempOther";
            }
        }

        public record RempIncludedIntoAcceptedBlock(String messageId, String messageDst, BigInteger timestamp, JsonNode json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempIncludedIntoAcceptedBlock";
            }
        }

        public record RempIncludedIntoBlock(String messageId, String messageDst, BigInteger timestamp, JsonNode json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempIncludedIntoBlock";
            }
        }

        public record RempSentToValidators(String messageId, String messageDst, BigInteger timestamp, JsonNode json) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "RempSentToValidators";
            }
        }

        public record MessageExpired(String messageId, String messageDst, String message, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "MessageExpired";
            }
        }

        public record FetchNextBlockFailed(String shardBlockId, String messageId, String messageDst, String message, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "FetchNextBlockFailed";
            }
        }

        public record WillFetchNextBlock(String shardBlockId, String messageId, String messageDst, String message) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "WillFetchNextBlock";
            }
        }

        public record SendFailed(String shardBlockId, String messageId, String messageDst, String message, Client.ClientError error) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "SendFailed";
            }
        }

        public record DidSend(String shardBlockId, String messageId, String messageDst, String message) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "DidSend";
            }
        }

        public record WillSend(String shardBlockId, String messageId, String messageDst, String message) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "WillSend";
            }
        }

        public record FetchFirstBlockFailed(Client.ClientError error, String messageId, String messageDst) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "FetchFirstBlockFailed";
            }
        }

        public record WillFetchFirstBlock(String messageId, String messageDst) implements ProcessingEvent
        {
            @JsonProperty(value="type")
            public String type() {
                return "WillFetchFirstBlock";
            }
        }
    }

    public record MessageMonitoringTransaction(String hash, Boolean aborted, MessageMonitoringTransactionCompute compute) {
    }

    public static sealed interface MonitoredMessage {

        public record HashAddress(String hash, String address) implements MonitoredMessage
        {
            @JsonProperty(value="type")
            public String type() {
                return "HashAddress";
            }
        }

        public record Boc(String boc) implements MonitoredMessage
        {
            @JsonProperty(value="type")
            public String type() {
                return "Boc";
            }
        }
    }

    public record DecodedOutput(Abi.DecodedMessageBody[] outMessages, JsonNode output) {
    }
}

