/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.ffi;

import java.lang.foreign.Addressable;
import java.lang.foreign.MemoryAddress;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.ValueLayout;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import tech.deplant.java4ever.binding.ffi.SdkResponseHandler;
import tech.deplant.java4ever.binding.ffi.tc_response_handler_t;
import tech.deplant.java4ever.binding.ffi.tc_string_data_t;
import tech.deplant.java4ever.binding.ffi.ton_client;
import tech.deplant.java4ever.binding.loader.LibraryLoader;

public class SdkBridge {
    public static String tcCreateContext(LibraryLoader loader, String configJson) {
        loader.load();
        try (MemorySession scope = MemorySession.openShared();){
            String string = SdkBridge.toString(ton_client.tc_read_string(SegmentAllocator.newNativeArena((MemorySession)scope), (Addressable)ton_client.tc_create_context(SdkBridge.ofString(configJson, scope))), scope);
            return string;
        }
    }

    public static SdkResponseHandler tcRequest(int contextId, int requestId, String functionName, String params) {
        SdkResponseHandler response = new SdkResponseHandler();
        ton_client.tc_request(contextId, SdkBridge.ofString(functionName, MemorySession.openShared()), SdkBridge.ofString(params, MemorySession.openShared()), requestId, (Addressable)tc_response_handler_t.allocate(response, MemorySession.openShared()));
        return response;
    }

    public static MemorySegment ofString(String text, MemorySession scope) {
        MemorySegment stringData = tc_string_data_t.allocate((SegmentAllocator)scope);
        MemorySegment nativeString = SdkBridge.fromJavaString(SegmentAllocator.newNativeArena((MemorySession)scope), text, StandardCharsets.UTF_8);
        tc_string_data_t.content$set(stringData, 0L, nativeString.address());
        tc_string_data_t.len$set(stringData, 0L, (int)nativeString.byteSize() - 1);
        return stringData;
    }

    public static String toString(MemorySegment seg, MemorySession scope) {
        return SdkBridge.toJavaString(seg, scope);
    }

    private static String toJavaString(MemorySegment segment, int len) {
        byte[] bytes = new byte[len];
        MemorySegment.copy(segment, ValueLayout.JAVA_BYTE, 0L, bytes, 0, len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static String toJavaString(MemorySegment seg, MemorySession scope) {
        if (tc_string_data_t.len$get(seg) > 0) {
            MemoryAddress addr = tc_string_data_t.content$get(seg);
            byte[] str = MemorySegment.ofAddress((MemoryAddress)addr, (long)tc_string_data_t.len$get(seg), (MemorySession)scope).toArray(ValueLayout.JAVA_BYTE);
            return new String(str, StandardCharsets.UTF_8);
        }
        return "";
    }

    private static int strLength(MemorySegment seg) {
        return tc_string_data_t.len$get(seg);
    }

    private static MemorySegment fromJavaString(SegmentAllocator allocator, String s, Charset charset) {
        if (StandardCharsets.UTF_8 == charset) {
            return allocator.allocateUtf8String(s);
        }
        return allocator.allocateArray(ValueLayout.JAVA_BYTE, (s + "\u0000").getBytes(charset));
    }
}

