/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator.jtype;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Map;
import javax.lang.model.element.Modifier;
import tech.deplant.java4ever.binding.generator.ParserEngine;
import tech.deplant.java4ever.binding.generator.javapoet.AnnotationSpec;
import tech.deplant.java4ever.binding.generator.javapoet.ClassName;
import tech.deplant.java4ever.binding.generator.javapoet.MethodSpec;
import tech.deplant.java4ever.binding.generator.javapoet.TypeSpec;
import tech.deplant.java4ever.binding.generator.jtype.JavaDocs;
import tech.deplant.java4ever.binding.generator.jtype.JavaParam;
import tech.deplant.java4ever.binding.generator.jtype.JavaType;
import tech.deplant.java4ever.binding.generator.reference.ApiType;
import tech.deplant.java4ever.binding.generator.reference.StructType;
import tech.deplant.java4ever.utils.Objs;

public record JavaRecord(StructType originalType, String name, ParserEngine.SdkInterfaceParent superInterface, boolean isSimpleWrapper, boolean isParams, boolean isResult, Map<ParserEngine.SdkType, JavaType> typeLibrary) implements JavaType
{
    private static final System.Logger logger = System.getLogger(JavaRecord.class.getName());

    public static JavaRecord ofApiType(StructType struct, Map<ParserEngine.SdkType, JavaType> typeLibrary, ParserEngine.SdkInterfaceParent superInterface) {
        boolean isParams = false;
        boolean isResult = false;
        if (struct.name().length() >= 8) {
            isParams = "ParamsOf".equals(struct.name().substring(0, 8));
            isResult = "ResultOf".equals(struct.name().substring(0, 8));
        }
        boolean isSimpleWrapper = struct.struct_fields().length == 1;
        return new JavaRecord(struct, struct.name(), superInterface, isSimpleWrapper, isParams, isResult, typeLibrary);
    }

    @Override
    public TypeSpec.Builder poeticize() {
        TypeSpec.Builder structBuilder = TypeSpec.recordBuilder(this.originalType.name()).addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        for (ApiType component : this.originalType.struct_fields()) {
            structBuilder.addRecordComponent(JavaParam.ofApiType(component, this.typeLibrary()).poeticize().build());
        }
        structBuilder.addJavadoc(new JavaDocs(this.originalType().summary(), this.originalType().description()).poeticize().build());
        if (Objs.isNotNull((Object)this.superInterface())) {
            structBuilder.addSuperinterface(ClassName.bestGuess(this.superInterface().name()));
            structBuilder.addMethod(this.virtualTypeField(this.superInterface().variantName()).build());
        }
        if ("AbiEvent".equals(this.name())) {
            structBuilder.addAnnotation(AnnotationSpec.builder(JsonIgnoreProperties.class).addMember("value", "$S", "outputs").build());
        }
        return structBuilder;
    }

    @Override
    public ApiType type() {
        return this.originalType();
    }

    @Override
    public boolean isFlatType() {
        return false;
    }

    @Override
    public boolean isStructure() {
        return true;
    }

    private MethodSpec.Builder virtualTypeField(String typeName) {
        return MethodSpec.methodBuilder("type").addModifiers(Modifier.PUBLIC).returns(ClassName.STRING).addStatement("return \"" + typeName + "\"", new Object[0]).addAnnotation(JavaParam.renamedFieldAnnotation("type"));
    }

    public JavaRecord withSuperInterface(ParserEngine.SdkInterfaceParent superInterface) {
        return new JavaRecord(this.originalType(), this.name(), superInterface, this.isSimpleWrapper(), this.isParams(), this.isResult(), this.typeLibrary());
    }
}

