/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator.jtype;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.lang.model.element.Modifier;
import tech.deplant.java4ever.binding.generator.ParserEngine;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.generator.TypeReference;
import tech.deplant.java4ever.binding.generator.javapoet.AnnotationSpec;
import tech.deplant.java4ever.binding.generator.javapoet.ParameterSpec;
import tech.deplant.java4ever.binding.generator.javapoet.TypeName;
import tech.deplant.java4ever.binding.generator.jtype.JavaDocs;
import tech.deplant.java4ever.binding.generator.jtype.JavaDummy;
import tech.deplant.java4ever.binding.generator.jtype.JavaType;
import tech.deplant.java4ever.binding.generator.reference.ApiType;

public record JavaParam(TypeName refClassName, String parameterName, String origParamName, String summary, String description, JavaType libType) {
    public static final Map<String, String> RESERVED_FIELD_NAMES = Map.of("public", "publicKey", "secret", "secretKey", "switch", "switchTo", "abi version", "ABIversion");

    public static JavaParam ofApiType(ApiType paramType, Map<ParserEngine.SdkType, JavaType> typeLibrary) {
        TypeName className;
        TypeReference typeReference = TypeReference.fromApiType(paramType);
        JavaType javaType = typeReference.toTypeDeclaration(typeLibrary);
        if (javaType instanceof JavaDummy) {
            JavaDummy dummy = (JavaDummy)javaType;
            className = TypeReference.fromApiType(dummy.type()).toTypeName();
        } else {
            className = typeReference.toTypeName();
        }
        String camelComponentName = ParserUtils.camelCase(paramType.name());
        String reservedName = RESERVED_FIELD_NAMES.getOrDefault(camelComponentName, camelComponentName);
        camelComponentName = "Context".equals(className.toString()) ? "ctx" : ParserUtils.camelCase(paramType.name());
        return new JavaParam(className, reservedName, camelComponentName, paramType.summary(), paramType.description(), typeReference.toTypeDeclaration(typeLibrary));
    }

    public static AnnotationSpec renamedFieldAnnotation(String originalName) {
        return AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", originalName).build();
    }

    public ParameterSpec.Builder poeticize() {
        ParameterSpec.Builder componentBuilder = ParameterSpec.builder(this.refClassName(), this.parameterName(), new Modifier[0]);
        if (!this.parameterName().equals(this.origParamName())) {
            componentBuilder.addAnnotation(JavaParam.renamedFieldAnnotation(this.origParamName()));
        }
        componentBuilder.addJavadoc(new JavaDocs(this.summary(), this.description()).poeticize().build());
        return componentBuilder;
    }
}

