/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.RecordNamingStrategyPatchModule;
import tech.deplant.java4ever.binding.ffi.SdkBridge;
import tech.deplant.java4ever.binding.loader.LibraryLoader;

public class ContextBuilder {
    public static final ObjectMapper DEFAULT_MAPPER = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new ParameterNamesModule())).addModule((Module)new Jdk8Module())).addModule((Module)new JavaTimeModule())).build()).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).registerModule((Module)new RecordNamingStrategyPatchModule());
    private long timeout = 60000L;
    private String configJson = "{}";
    private ObjectMapper jsonMapper = DEFAULT_MAPPER;

    public ContextBuilder setConfigJson(String configJson) {
        this.configJson = configJson;
        return this;
    }

    public ContextBuilder setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public ContextBuilder setMapper(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        return this;
    }

    public Context buildFromExisting(int existingContextId, int existingContextRequestCount) {
        return new Context(existingContextId, existingContextRequestCount, this.timeout, this.jsonMapper);
    }

    public Context buildNew(LibraryLoader loader) throws JsonProcessingException {
        ResultOfCreateContext createContextResponse = (ResultOfCreateContext)this.jsonMapper.readValue(SdkBridge.tcCreateContext(loader, this.configJson), ResultOfCreateContext.class);
        if (createContextResponse.result() == null || createContextResponse.result() < 1) {
            throw new RuntimeException("sdk.create_context failed!");
        }
        return new Context((int)createContextResponse.result(), 0, this.timeout, this.jsonMapper);
    }

    public record ResultOfCreateContext(Integer result, String error) {
    }
}

