/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;

public class Client {
    public static ResultOfGetApiReference getApiReference(Context ctx) throws EverSdkException {
        return ctx.call("client.get_api_reference", null, ResultOfGetApiReference.class);
    }

    public static ResultOfVersion version(Context ctx) throws EverSdkException {
        return ctx.call("client.version", null, ResultOfVersion.class);
    }

    public static ClientConfig config(Context ctx) throws EverSdkException {
        return ctx.call("client.config", null, ClientConfig.class);
    }

    public static ResultOfBuildInfo buildInfo(Context ctx) throws EverSdkException {
        return ctx.call("client.build_info", null, ResultOfBuildInfo.class);
    }

    public static void resolveAppRequest(Context ctx, Number appRequestId, AppRequestResult result) throws EverSdkException {
        ctx.callVoid("client.resolve_app_request", new ParamsOfResolveAppRequest(appRequestId, result));
    }

    public record ResultOfGetApiReference(Map<String, Object> api) {
    }

    public record ResultOfVersion(String version) {
    }

    public record ClientConfig(NetworkConfig network, CryptoConfig crypto, AbiConfig abi, BocConfig boc, ProofsConfig proofs, String localStoragePath) {
    }

    public record ResultOfBuildInfo(Number buildNumber, BuildInfoDependency[] dependencies) {
    }

    public record ParamsOfResolveAppRequest(Number appRequestId, AppRequestResult result) {
    }

    public static interface AppRequestResult {

        public record Ok(Map<String, Object> result) implements AppRequestResult
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Error(String text) implements AppRequestResult
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public record BuildInfoDependency(String name, String gitCommit) {
    }

    public record ProofsConfig(Boolean cacheInLocalStorage) {
    }

    public record BocConfig(Number cacheMaxSize) {
    }

    public record AbiConfig(Number workchain, Number messageExpirationTimeout, Number messageExpirationTimeoutGrowFactor) {
    }

    public record CryptoConfig(Number mnemonicDictionary, Number mnemonicWordCount, String hdkeyDerivationPath) {
    }

    public static enum NetworkQueriesProtocol {
        HTTP,
        WS;

    }

    public record NetworkConfig(@Deprecated String serverAddress, String[] endpoints, @Deprecated Number networkRetriesCount, Number maxReconnectTimeout, @Deprecated Number reconnectTimeout, Number messageRetriesCount, Number messageProcessingTimeout, Number waitForTimeout, Number outOfSyncThreshold, Number sendingEndpointCount, Number latencyDetectionInterval, Number maxLatency, Number queryTimeout, NetworkQueriesProtocol queriesProtocol, Number firstRempStatusTimeout, Number nextRempStatusTimeout, String accessKey) {
    }
}

