/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.ffi;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.MemorySession;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.deplant.java4ever.binding.ffi.EverSdkBridge;
import tech.deplant.java4ever.binding.ffi.tc_response_handler_t;

public class EverSdkResponse
implements tc_response_handler_t {
    private static final Logger log = LoggerFactory.getLogger(EverSdkResponse.class);
    private CompletableFuture<String> result = new CompletableFuture();

    @Override
    public void apply(int x0, MemorySegment x1, int x2, boolean x3) {
        try (MemorySession scope = MemorySession.openShared();){
            if (x2 == 0) {
                this.result.complete(EverSdkBridge.toString(x1, scope));
                log.trace("REQID:" + x0 + ", RESULT");
            } else if (x2 == 1) {
                this.result.completeExceptionally(new CompletionException(EverSdkBridge.toString(x1, scope), null));
                log.warn("REQID:" + x0 + ", ERROR");
            } else if (x2 == 2) {
                log.trace("REQID:" + x0 + ", NOP");
            } else if (x2 == 3) {
                log.trace("REQID:" + x0 + ", APP_REQUEST");
            } else if (x2 == 4) {
                log.trace("REQID:" + x0 + ", APP_NOTIFY");
            } else if (x2 >= 5 && x2 <= 99) {
                log.trace("REQID:" + x0 + ", RESERVED");
            } else {
                log.trace("REQID:" + x0 + ", CUSTOM");
            }
        }
    }

    public CompletableFuture<String> result() {
        return this.result;
    }
}

