/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import tech.deplant.java4ever.binding.AppEncryptionBox;
import tech.deplant.java4ever.binding.AppSigningBox;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;

public class Crypto {
    public static ResultOfFactorize factorize(Context ctx, String composite) throws EverSdkException {
        return ctx.call("crypto.factorize", new ParamsOfFactorize(composite), ResultOfFactorize.class);
    }

    public static ResultOfModularPower modularPower(Context ctx, String base, String exponent, String modulus) throws EverSdkException {
        return ctx.call("crypto.modular_power", new ParamsOfModularPower(base, exponent, modulus), ResultOfModularPower.class);
    }

    public static ResultOfTonCrc16 tonCrc16(Context ctx, String data) throws EverSdkException {
        return ctx.call("crypto.ton_crc16", new ParamsOfTonCrc16(data), ResultOfTonCrc16.class);
    }

    public static ResultOfGenerateRandomBytes generateRandomBytes(Context ctx, Number length) throws EverSdkException {
        return ctx.call("crypto.generate_random_bytes", new ParamsOfGenerateRandomBytes(length), ResultOfGenerateRandomBytes.class);
    }

    public static ResultOfConvertPublicKeyToTonSafeFormat convertPublicKeyToTonSafeFormat(Context ctx, String publicKey) throws EverSdkException {
        return ctx.call("crypto.convert_public_key_to_ton_safe_format", new ParamsOfConvertPublicKeyToTonSafeFormat(publicKey), ResultOfConvertPublicKeyToTonSafeFormat.class);
    }

    public static KeyPair generateRandomSignKeys(Context ctx) throws EverSdkException {
        return ctx.call("crypto.generate_random_sign_keys", null, KeyPair.class);
    }

    public static ResultOfSign sign(Context ctx, String unsigned, KeyPair keys) throws EverSdkException {
        return ctx.call("crypto.sign", new ParamsOfSign(unsigned, keys), ResultOfSign.class);
    }

    public static ResultOfVerifySignature verifySignature(Context ctx, String signed, String publicKey) throws EverSdkException {
        return ctx.call("crypto.verify_signature", new ParamsOfVerifySignature(signed, publicKey), ResultOfVerifySignature.class);
    }

    public static ResultOfHash sha256(Context ctx, String data) throws EverSdkException {
        return ctx.call("crypto.sha256", new ParamsOfHash(data), ResultOfHash.class);
    }

    public static ResultOfHash sha512(Context ctx, String data) throws EverSdkException {
        return ctx.call("crypto.sha512", new ParamsOfHash(data), ResultOfHash.class);
    }

    public static ResultOfScrypt scrypt(Context ctx, String password, String salt, Number logN, Number r, Number p, Number dkLen) throws EverSdkException {
        return ctx.call("crypto.scrypt", new ParamsOfScrypt(password, salt, logN, r, p, dkLen), ResultOfScrypt.class);
    }

    public static KeyPair naclSignKeypairFromSecretKey(Context ctx, String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign_keypair_from_secret_key", new ParamsOfNaclSignKeyPairFromSecret(secretKey), KeyPair.class);
    }

    public static ResultOfNaclSign naclSign(Context ctx, String unsigned, String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign", new ParamsOfNaclSign(unsigned, secretKey), ResultOfNaclSign.class);
    }

    public static ResultOfNaclSignOpen naclSignOpen(Context ctx, String signed, String publicKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign_open", new ParamsOfNaclSignOpen(signed, publicKey), ResultOfNaclSignOpen.class);
    }

    public static ResultOfNaclSignDetached naclSignDetached(Context ctx, String unsigned, String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign_detached", new ParamsOfNaclSign(unsigned, secretKey), ResultOfNaclSignDetached.class);
    }

    public static ResultOfNaclSignDetachedVerify naclSignDetachedVerify(Context ctx, String unsigned, String signature, String publicKey) throws EverSdkException {
        return ctx.call("crypto.nacl_sign_detached_verify", new ParamsOfNaclSignDetachedVerify(unsigned, signature, publicKey), ResultOfNaclSignDetachedVerify.class);
    }

    public static KeyPair naclBoxKeypair(Context ctx) throws EverSdkException {
        return ctx.call("crypto.nacl_box_keypair", null, KeyPair.class);
    }

    public static KeyPair naclBoxKeypairFromSecretKey(Context ctx, String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_box_keypair_from_secret_key", new ParamsOfNaclBoxKeyPairFromSecret(secretKey), KeyPair.class);
    }

    public static ResultOfNaclBox naclBox(Context ctx, String decrypted, String nonce, String theirPublic, String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_box", new ParamsOfNaclBox(decrypted, nonce, theirPublic, secretKey), ResultOfNaclBox.class);
    }

    public static ResultOfNaclBoxOpen naclBoxOpen(Context ctx, String encrypted, String nonce, String theirPublic, String secretKey) throws EverSdkException {
        return ctx.call("crypto.nacl_box_open", new ParamsOfNaclBoxOpen(encrypted, nonce, theirPublic, secretKey), ResultOfNaclBoxOpen.class);
    }

    public static ResultOfNaclBox naclSecretBox(Context ctx, String decrypted, String nonce, String key) throws EverSdkException {
        return ctx.call("crypto.nacl_secret_box", new ParamsOfNaclSecretBox(decrypted, nonce, key), ResultOfNaclBox.class);
    }

    public static ResultOfNaclBoxOpen naclSecretBoxOpen(Context ctx, String encrypted, String nonce, String key) throws EverSdkException {
        return ctx.call("crypto.nacl_secret_box_open", new ParamsOfNaclSecretBoxOpen(encrypted, nonce, key), ResultOfNaclBoxOpen.class);
    }

    public static ResultOfMnemonicWords mnemonicWords(Context ctx, Number dictionary) throws EverSdkException {
        return ctx.call("crypto.mnemonic_words", new ParamsOfMnemonicWords(dictionary), ResultOfMnemonicWords.class);
    }

    public static ResultOfMnemonicFromRandom mnemonicFromRandom(Context ctx, Number dictionary, Number wordCount) throws EverSdkException {
        return ctx.call("crypto.mnemonic_from_random", new ParamsOfMnemonicFromRandom(dictionary, wordCount), ResultOfMnemonicFromRandom.class);
    }

    public static ResultOfMnemonicFromEntropy mnemonicFromEntropy(Context ctx, String entropy, Number dictionary, Number wordCount) throws EverSdkException {
        return ctx.call("crypto.mnemonic_from_entropy", new ParamsOfMnemonicFromEntropy(entropy, dictionary, wordCount), ResultOfMnemonicFromEntropy.class);
    }

    public static ResultOfMnemonicVerify mnemonicVerify(Context ctx, String phrase, Number dictionary, Number wordCount) throws EverSdkException {
        return ctx.call("crypto.mnemonic_verify", new ParamsOfMnemonicVerify(phrase, dictionary, wordCount), ResultOfMnemonicVerify.class);
    }

    public static KeyPair mnemonicDeriveSignKeys(Context ctx, String phrase, String path, Number dictionary, Number wordCount) throws EverSdkException {
        return ctx.call("crypto.mnemonic_derive_sign_keys", new ParamsOfMnemonicDeriveSignKeys(phrase, path, dictionary, wordCount), KeyPair.class);
    }

    public static ResultOfHDKeyXPrvFromMnemonic hdkeyXprvFromMnemonic(Context ctx, String phrase, Number dictionary, Number wordCount) throws EverSdkException {
        return ctx.call("crypto.hdkey_xprv_from_mnemonic", new ParamsOfHDKeyXPrvFromMnemonic(phrase, dictionary, wordCount), ResultOfHDKeyXPrvFromMnemonic.class);
    }

    public static ResultOfHDKeyDeriveFromXPrv hdkeyDeriveFromXprv(Context ctx, String xprv, Number childIndex, Boolean hardened) throws EverSdkException {
        return ctx.call("crypto.hdkey_derive_from_xprv", new ParamsOfHDKeyDeriveFromXPrv(xprv, childIndex, hardened), ResultOfHDKeyDeriveFromXPrv.class);
    }

    public static ResultOfHDKeyDeriveFromXPrvPath hdkeyDeriveFromXprvPath(Context ctx, String xprv, String path) throws EverSdkException {
        return ctx.call("crypto.hdkey_derive_from_xprv_path", new ParamsOfHDKeyDeriveFromXPrvPath(xprv, path), ResultOfHDKeyDeriveFromXPrvPath.class);
    }

    public static ResultOfHDKeySecretFromXPrv hdkeySecretFromXprv(Context ctx, String xprv) throws EverSdkException {
        return ctx.call("crypto.hdkey_secret_from_xprv", new ParamsOfHDKeySecretFromXPrv(xprv), ResultOfHDKeySecretFromXPrv.class);
    }

    public static ResultOfHDKeyPublicFromXPrv hdkeyPublicFromXprv(Context ctx, String xprv) throws EverSdkException {
        return ctx.call("crypto.hdkey_public_from_xprv", new ParamsOfHDKeyPublicFromXPrv(xprv), ResultOfHDKeyPublicFromXPrv.class);
    }

    public static ResultOfChaCha20 chacha20(Context ctx, String data, String key, String nonce) throws EverSdkException {
        return ctx.call("crypto.chacha20", new ParamsOfChaCha20(data, key, nonce), ResultOfChaCha20.class);
    }

    public static RegisteredCryptoBox createCryptoBox(Context ctx, String secretEncryptionSalt, CryptoBoxSecret secretKey) throws EverSdkException {
        return ctx.call("crypto.create_crypto_box", new ParamsOfCreateCryptoBox(secretEncryptionSalt, secretKey), RegisteredCryptoBox.class);
    }

    public static void removeCryptoBox(Context ctx, Integer handle) throws EverSdkException {
        ctx.callVoid("crypto.remove_crypto_box", new RegisteredCryptoBox(handle));
    }

    public static ResultOfGetCryptoBoxInfo getCryptoBoxInfo(Context ctx, Integer handle) throws EverSdkException {
        return ctx.call("crypto.get_crypto_box_info", new RegisteredCryptoBox(handle), ResultOfGetCryptoBoxInfo.class);
    }

    public static ResultOfGetCryptoBoxSeedPhrase getCryptoBoxSeedPhrase(Context ctx, Integer handle) throws EverSdkException {
        return ctx.call("crypto.get_crypto_box_seed_phrase", new RegisteredCryptoBox(handle), ResultOfGetCryptoBoxSeedPhrase.class);
    }

    public static RegisteredSigningBox getSigningBoxFromCryptoBox(Context ctx, Number handle, String hdpath, Number secretLifetime) throws EverSdkException {
        return ctx.call("crypto.get_signing_box_from_crypto_box", new ParamsOfGetSigningBoxFromCryptoBox(handle, hdpath, secretLifetime), RegisteredSigningBox.class);
    }

    public static RegisteredEncryptionBox getEncryptionBoxFromCryptoBox(Context ctx, Number handle, String hdpath, BoxEncryptionAlgorithm algorithm, Number secretLifetime) throws EverSdkException {
        return ctx.call("crypto.get_encryption_box_from_crypto_box", new ParamsOfGetEncryptionBoxFromCryptoBox(handle, hdpath, algorithm, secretLifetime), RegisteredEncryptionBox.class);
    }

    public static void clearCryptoBoxSecretCache(Context ctx, Integer handle) throws EverSdkException {
        ctx.callVoid("crypto.clear_crypto_box_secret_cache", new RegisteredCryptoBox(handle));
    }

    public static RegisteredSigningBox registerSigningBox(Context ctx, AppSigningBox appObject) throws EverSdkException {
        return ctx.callAppObject("crypto.register_signing_box", null, appObject, RegisteredSigningBox.class);
    }

    public static RegisteredSigningBox getSigningBox(Context ctx, String publicKey, String secretKey) throws EverSdkException {
        return ctx.call("crypto.get_signing_box", new KeyPair(publicKey, secretKey), RegisteredSigningBox.class);
    }

    public static ResultOfSigningBoxGetPublicKey signingBoxGetPublicKey(Context ctx, Integer handle) throws EverSdkException {
        return ctx.call("crypto.signing_box_get_public_key", new RegisteredSigningBox(handle), ResultOfSigningBoxGetPublicKey.class);
    }

    public static ResultOfSigningBoxSign signingBoxSign(Context ctx, Integer signingBox, String unsigned) throws EverSdkException {
        return ctx.call("crypto.signing_box_sign", new ParamsOfSigningBoxSign(signingBox, unsigned), ResultOfSigningBoxSign.class);
    }

    public static void removeSigningBox(Context ctx, Integer handle) throws EverSdkException {
        ctx.callVoid("crypto.remove_signing_box", new RegisteredSigningBox(handle));
    }

    public static RegisteredEncryptionBox registerEncryptionBox(Context ctx, AppEncryptionBox appObject) throws EverSdkException {
        return ctx.callAppObject("crypto.register_encryption_box", null, appObject, RegisteredEncryptionBox.class);
    }

    public static void removeEncryptionBox(Context ctx, Integer handle) throws EverSdkException {
        ctx.callVoid("crypto.remove_encryption_box", new RegisteredEncryptionBox(handle));
    }

    public static ResultOfEncryptionBoxGetInfo encryptionBoxGetInfo(Context ctx, Integer encryptionBox) throws EverSdkException {
        return ctx.call("crypto.encryption_box_get_info", new ParamsOfEncryptionBoxGetInfo(encryptionBox), ResultOfEncryptionBoxGetInfo.class);
    }

    public static ResultOfEncryptionBoxEncrypt encryptionBoxEncrypt(Context ctx, Integer encryptionBox, String data) throws EverSdkException {
        return ctx.call("crypto.encryption_box_encrypt", new ParamsOfEncryptionBoxEncrypt(encryptionBox, data), ResultOfEncryptionBoxEncrypt.class);
    }

    public static ResultOfEncryptionBoxDecrypt encryptionBoxDecrypt(Context ctx, Integer encryptionBox, String data) throws EverSdkException {
        return ctx.call("crypto.encryption_box_decrypt", new ParamsOfEncryptionBoxDecrypt(encryptionBox, data), ResultOfEncryptionBoxDecrypt.class);
    }

    public static RegisteredEncryptionBox createEncryptionBox(Context ctx, EncryptionAlgorithm algorithm) throws EverSdkException {
        return ctx.call("crypto.create_encryption_box", new ParamsOfCreateEncryptionBox(algorithm), RegisteredEncryptionBox.class);
    }

    public record ParamsOfFactorize(String composite) {
    }

    public record ResultOfFactorize(String[] factors) {
    }

    public record ParamsOfModularPower(String base, String exponent, String modulus) {
    }

    public record ResultOfModularPower(String modularPower) {
    }

    public record ParamsOfTonCrc16(String data) {
    }

    public record ResultOfTonCrc16(Number crc) {
    }

    public record ParamsOfGenerateRandomBytes(Number length) {
    }

    public record ResultOfGenerateRandomBytes(String bytes) {
    }

    public record ParamsOfConvertPublicKeyToTonSafeFormat(String publicKey) {
    }

    public record ResultOfConvertPublicKeyToTonSafeFormat(String tonPublicKey) {
    }

    public record KeyPair(@JsonProperty(value="public") String publicKey, @JsonProperty(value="secret") String secretKey) {
    }

    public record ParamsOfSign(String unsigned, KeyPair keys) {
    }

    public record ResultOfSign(String signed, String signature) {
    }

    public record ParamsOfVerifySignature(String signed, @JsonProperty(value="public") String publicKey) {
    }

    public record ResultOfVerifySignature(String unsigned) {
    }

    public record ParamsOfHash(String data) {
    }

    public record ResultOfHash(String hash) {
    }

    public record ParamsOfScrypt(String password, String salt, Number logN, Number r, Number p, Number dkLen) {
    }

    public record ResultOfScrypt(String key) {
    }

    public record ParamsOfNaclSignKeyPairFromSecret(@JsonProperty(value="secret") String secretKey) {
    }

    public record ParamsOfNaclSign(String unsigned, @JsonProperty(value="secret") String secretKey) {
    }

    public record ResultOfNaclSign(String signed) {
    }

    public record ParamsOfNaclSignOpen(String signed, @JsonProperty(value="public") String publicKey) {
    }

    public record ResultOfNaclSignOpen(String unsigned) {
    }

    public record ResultOfNaclSignDetached(String signature) {
    }

    public record ParamsOfNaclSignDetachedVerify(String unsigned, String signature, @JsonProperty(value="public") String publicKey) {
    }

    public record ResultOfNaclSignDetachedVerify(Boolean succeeded) {
    }

    public record ParamsOfNaclBoxKeyPairFromSecret(@JsonProperty(value="secret") String secretKey) {
    }

    public record ParamsOfNaclBox(String decrypted, String nonce, String theirPublic, @JsonProperty(value="secret") String secretKey) {
    }

    public record ResultOfNaclBox(String encrypted) {
    }

    public record ParamsOfNaclBoxOpen(String encrypted, String nonce, String theirPublic, @JsonProperty(value="secret") String secretKey) {
    }

    public record ResultOfNaclBoxOpen(String decrypted) {
    }

    public record ParamsOfNaclSecretBox(String decrypted, String nonce, String key) {
    }

    public record ParamsOfNaclSecretBoxOpen(String encrypted, String nonce, String key) {
    }

    public record ParamsOfMnemonicWords(Number dictionary) {
    }

    public record ResultOfMnemonicWords(String words) {
    }

    public record ParamsOfMnemonicFromRandom(Number dictionary, Number wordCount) {
    }

    public record ResultOfMnemonicFromRandom(String phrase) {
    }

    public record ParamsOfMnemonicFromEntropy(String entropy, Number dictionary, Number wordCount) {
    }

    public record ResultOfMnemonicFromEntropy(String phrase) {
    }

    public record ParamsOfMnemonicVerify(String phrase, Number dictionary, Number wordCount) {
    }

    public record ResultOfMnemonicVerify(Boolean valid) {
    }

    public record ParamsOfMnemonicDeriveSignKeys(String phrase, String path, Number dictionary, Number wordCount) {
    }

    public record ParamsOfHDKeyXPrvFromMnemonic(String phrase, Number dictionary, Number wordCount) {
    }

    public record ResultOfHDKeyXPrvFromMnemonic(String xprv) {
    }

    public record ParamsOfHDKeyDeriveFromXPrv(String xprv, Number childIndex, Boolean hardened) {
    }

    public record ResultOfHDKeyDeriveFromXPrv(String xprv) {
    }

    public record ParamsOfHDKeyDeriveFromXPrvPath(String xprv, String path) {
    }

    public record ResultOfHDKeyDeriveFromXPrvPath(String xprv) {
    }

    public record ParamsOfHDKeySecretFromXPrv(String xprv) {
    }

    public record ResultOfHDKeySecretFromXPrv(@JsonProperty(value="secret") String secretKey) {
    }

    public record ParamsOfHDKeyPublicFromXPrv(String xprv) {
    }

    public record ResultOfHDKeyPublicFromXPrv(@JsonProperty(value="public") String publicKey) {
    }

    public record ParamsOfChaCha20(String data, String key, String nonce) {
    }

    public record ResultOfChaCha20(String data) {
    }

    public record ParamsOfCreateCryptoBox(String secretEncryptionSalt, @JsonProperty(value="secret") CryptoBoxSecret secretKey) {
    }

    public static interface CryptoBoxSecret {

        public record EncryptedSecret(String encryptedSecret) implements CryptoBoxSecret
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record PredefinedSeedPhrase(String phrase, Number dictionary, Number wordcount) implements CryptoBoxSecret
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record RandomSeedPhrase(Number dictionary, Number wordcount) implements CryptoBoxSecret
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public record RegisteredCryptoBox(Integer handle) {
    }

    public record ResultOfGetCryptoBoxInfo(String encryptedSecret) {
    }

    public record ResultOfGetCryptoBoxSeedPhrase(String phrase, Number dictionary, Number wordcount) {
    }

    public record ParamsOfGetSigningBoxFromCryptoBox(Number handle, String hdpath, Number secretLifetime) {
    }

    public record RegisteredSigningBox(Integer handle) {
    }

    public record ParamsOfGetEncryptionBoxFromCryptoBox(Number handle, String hdpath, BoxEncryptionAlgorithm algorithm, Number secretLifetime) {
    }

    public static interface BoxEncryptionAlgorithm {

        public record NaclSecretBox(String nonce) implements BoxEncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record NaclBox(String theirPublic, String nonce) implements BoxEncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record ChaCha20(String nonce) implements BoxEncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public record RegisteredEncryptionBox(Integer handle) {
    }

    public record ResultOfSigningBoxGetPublicKey(String pubkey) {
    }

    public record ParamsOfSigningBoxSign(Integer signingBox, String unsigned) {
    }

    public record ResultOfSigningBoxSign(String signature) {
    }

    public record ParamsOfEncryptionBoxGetInfo(Integer encryptionBox) {
    }

    public record ResultOfEncryptionBoxGetInfo(EncryptionBoxInfo info) {
    }

    public record ParamsOfEncryptionBoxEncrypt(Integer encryptionBox, String data) {
    }

    public record ResultOfEncryptionBoxEncrypt(String data) {
    }

    public record ParamsOfEncryptionBoxDecrypt(Integer encryptionBox, String data) {
    }

    public record ResultOfEncryptionBoxDecrypt(String data) {
    }

    public record ParamsOfCreateEncryptionBox(EncryptionAlgorithm algorithm) {
    }

    public static interface EncryptionAlgorithm {

        public record NaclSecretBox(String key, String nonce) implements EncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record NaclBox(String theirPublic, @JsonProperty(value="secret") String secretKey, String nonce) implements EncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record ChaCha20(String key, String nonce) implements EncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record AES(Map<String, Object> mode, String key, String iv) implements EncryptionAlgorithm
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public static interface ResultOfAppEncryptionBox {

        public record Decrypt(String data) implements ResultOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Encrypt(String data) implements ResultOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record GetInfo(EncryptionBoxInfo info) implements ResultOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public static interface ParamsOfAppEncryptionBox {
        public static final GetInfo GETINFO = new GetInfo();

        public record GetInfo() implements ParamsOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Decrypt(String data) implements ParamsOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Encrypt(String data) implements ParamsOfAppEncryptionBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public static interface ResultOfAppSigningBox {

        public record Sign(String signature) implements ResultOfAppSigningBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record GetPublicKey(String publicKey) implements ResultOfAppSigningBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public static interface ParamsOfAppSigningBox {
        public static final GetPublicKey GETPUBLICKEY = new GetPublicKey();

        public record GetPublicKey() implements ParamsOfAppSigningBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Sign(String unsigned) implements ParamsOfAppSigningBox
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public record EncryptionBoxInfo(String hdpath, String algorithm, Map<String, Object> options, @JsonProperty(value="public") Map<String, Object> publicKey) {
    }
}

