/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.ProcessMessageEvent;
import tech.deplant.java4ever.binding.SendMessageEvent;
import tech.deplant.java4ever.binding.Tvm;
import tech.deplant.java4ever.binding.WaitForTransactionEvent;
import tech.deplant.java4ever.binding.json.JsonData;

public class Processing {
    public static CompletableFuture<ResultOfSendMessage> sendMessage(@NonNull Context context, @NonNull String message, Abi.ABI abi, @NonNull Boolean sendEvents, Consumer<SendMessageEvent> consumer) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (sendEvents == null) {
            throw new NullPointerException("sendEvents is marked non-null but is null");
        }
        return Context.futureCallback("processing.send_message", context, new ParamsOfSendMessage(message, abi, sendEvents), ResultOfSendMessage.class);
    }

    public static CompletableFuture<ResultOfProcessMessage> waitForTransaction(@NonNull Context context, Abi.ABI abi, @NonNull String message, @NonNull String shardBlockId, @NonNull Boolean sendEvents, String[] sendingEndpoints, Consumer<WaitForTransactionEvent> consumer) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (shardBlockId == null) {
            throw new NullPointerException("shardBlockId is marked non-null but is null");
        }
        if (sendEvents == null) {
            throw new NullPointerException("sendEvents is marked non-null but is null");
        }
        return Context.futureCallback("processing.wait_for_transaction", context, new ParamsOfWaitForTransaction(abi, message, shardBlockId, sendEvents, sendingEndpoints), ResultOfProcessMessage.class);
    }

    public static CompletableFuture<ResultOfProcessMessage> processMessage(@NonNull Context context, @NonNull Abi.ABI abi, String address, Abi.DeploySet deploySet, Abi.CallSet callSet, @NonNull Abi.Signer signer, Number processingTryIndex, @NonNull Boolean sendEvents, Consumer<ProcessMessageEvent> consumer) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (abi == null) {
            throw new NullPointerException("abi is marked non-null but is null");
        }
        if (signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
        if (sendEvents == null) {
            throw new NullPointerException("sendEvents is marked non-null but is null");
        }
        return Context.futureCallback("processing.process_message", context, new ParamsOfProcessMessage(new Abi.ParamsOfEncodeMessage(abi, address, deploySet, callSet, signer, processingTryIndex), sendEvents), ResultOfProcessMessage.class);
    }

    public static final class ParamsOfSendMessage
    extends JsonData {
        @SerializedName(value="message")
        @NonNull
        private final String message;
        @SerializedName(value="abi")
        private final Abi.ABI abi;
        @SerializedName(value="send_events")
        @NonNull
        private final Boolean sendEvents;

        public Optional<Abi.ABI> abi() {
            return Optional.ofNullable(this.abi);
        }

        @Generated
        public ParamsOfSendMessage(@NonNull String message, Abi.ABI abi, @NonNull Boolean sendEvents) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (sendEvents == null) {
                throw new NullPointerException("sendEvents is marked non-null but is null");
            }
            this.message = message;
            this.abi = abi;
            this.sendEvents = sendEvents;
        }

        @NonNull
        @Generated
        public String message() {
            return this.message;
        }

        @NonNull
        @Generated
        public Boolean sendEvents() {
            return this.sendEvents;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfSendMessage)) {
                return false;
            }
            ParamsOfSendMessage other = (ParamsOfSendMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$sendEvents = this.sendEvents();
            Boolean other$sendEvents = other.sendEvents();
            if (this$sendEvents == null ? other$sendEvents != null : !((Object)this$sendEvents).equals(other$sendEvents)) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Optional<Abi.ABI> this$abi = this.abi();
            Optional<Abi.ABI> other$abi = other.abi();
            return !(this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfSendMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $sendEvents = this.sendEvents();
            result = result * 59 + ($sendEvents == null ? 43 : ((Object)$sendEvents).hashCode());
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Optional<Abi.ABI> $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Processing.ParamsOfSendMessage(message=" + this.message() + ", abi=" + this.abi() + ", sendEvents=" + this.sendEvents() + ")";
        }
    }

    public static final class ResultOfSendMessage
    extends JsonData {
        @SerializedName(value="shard_block_id")
        @NonNull
        private final String shardBlockId;
        @SerializedName(value="sending_endpoints")
        @NonNull
        private final String[] sendingEndpoints;

        @Generated
        public ResultOfSendMessage(@NonNull String shardBlockId, @NonNull String[] sendingEndpoints) {
            if (shardBlockId == null) {
                throw new NullPointerException("shardBlockId is marked non-null but is null");
            }
            if (sendingEndpoints == null) {
                throw new NullPointerException("sendingEndpoints is marked non-null but is null");
            }
            this.shardBlockId = shardBlockId;
            this.sendingEndpoints = sendingEndpoints;
        }

        @NonNull
        @Generated
        public String shardBlockId() {
            return this.shardBlockId;
        }

        @NonNull
        @Generated
        public String[] sendingEndpoints() {
            return this.sendingEndpoints;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfSendMessage)) {
                return false;
            }
            ResultOfSendMessage other = (ResultOfSendMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$shardBlockId = this.shardBlockId();
            String other$shardBlockId = other.shardBlockId();
            if (this$shardBlockId == null ? other$shardBlockId != null : !this$shardBlockId.equals(other$shardBlockId)) {
                return false;
            }
            return Arrays.deepEquals(this.sendingEndpoints(), other.sendingEndpoints());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfSendMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $shardBlockId = this.shardBlockId();
            result = result * 59 + ($shardBlockId == null ? 43 : $shardBlockId.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.sendingEndpoints());
            return result;
        }

        @Generated
        public String toString() {
            return "Processing.ResultOfSendMessage(shardBlockId=" + this.shardBlockId() + ", sendingEndpoints=" + Arrays.deepToString(this.sendingEndpoints()) + ")";
        }
    }

    public static final class ParamsOfWaitForTransaction
    extends JsonData {
        @SerializedName(value="abi")
        private final Abi.ABI abi;
        @SerializedName(value="message")
        @NonNull
        private final String message;
        @SerializedName(value="shard_block_id")
        @NonNull
        private final String shardBlockId;
        @SerializedName(value="send_events")
        @NonNull
        private final Boolean sendEvents;
        @SerializedName(value="sending_endpoints")
        private final String[] sendingEndpoints;

        public Optional<Abi.ABI> abi() {
            return Optional.ofNullable(this.abi);
        }

        public Optional<String[]> sendingEndpoints() {
            return Optional.ofNullable(this.sendingEndpoints);
        }

        @Generated
        public ParamsOfWaitForTransaction(Abi.ABI abi, @NonNull String message, @NonNull String shardBlockId, @NonNull Boolean sendEvents, String[] sendingEndpoints) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (shardBlockId == null) {
                throw new NullPointerException("shardBlockId is marked non-null but is null");
            }
            if (sendEvents == null) {
                throw new NullPointerException("sendEvents is marked non-null but is null");
            }
            this.abi = abi;
            this.message = message;
            this.shardBlockId = shardBlockId;
            this.sendEvents = sendEvents;
            this.sendingEndpoints = sendingEndpoints;
        }

        @NonNull
        @Generated
        public String message() {
            return this.message;
        }

        @NonNull
        @Generated
        public String shardBlockId() {
            return this.shardBlockId;
        }

        @NonNull
        @Generated
        public Boolean sendEvents() {
            return this.sendEvents;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfWaitForTransaction)) {
                return false;
            }
            ParamsOfWaitForTransaction other = (ParamsOfWaitForTransaction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$sendEvents = this.sendEvents();
            Boolean other$sendEvents = other.sendEvents();
            if (this$sendEvents == null ? other$sendEvents != null : !((Object)this$sendEvents).equals(other$sendEvents)) {
                return false;
            }
            Optional<Abi.ABI> this$abi = this.abi();
            Optional<Abi.ABI> other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi)) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$shardBlockId = this.shardBlockId();
            String other$shardBlockId = other.shardBlockId();
            if (this$shardBlockId == null ? other$shardBlockId != null : !this$shardBlockId.equals(other$shardBlockId)) {
                return false;
            }
            Optional<String[]> this$sendingEndpoints = this.sendingEndpoints();
            Optional<String[]> other$sendingEndpoints = other.sendingEndpoints();
            return !(this$sendingEndpoints == null ? other$sendingEndpoints != null : !((Object)this$sendingEndpoints).equals(other$sendingEndpoints));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfWaitForTransaction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $sendEvents = this.sendEvents();
            result = result * 59 + ($sendEvents == null ? 43 : ((Object)$sendEvents).hashCode());
            Optional<Abi.ABI> $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $shardBlockId = this.shardBlockId();
            result = result * 59 + ($shardBlockId == null ? 43 : $shardBlockId.hashCode());
            Optional<String[]> $sendingEndpoints = this.sendingEndpoints();
            result = result * 59 + ($sendingEndpoints == null ? 43 : ((Object)$sendingEndpoints).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Processing.ParamsOfWaitForTransaction(abi=" + this.abi() + ", message=" + this.message() + ", shardBlockId=" + this.shardBlockId() + ", sendEvents=" + this.sendEvents() + ", sendingEndpoints=" + this.sendingEndpoints() + ")";
        }
    }

    public static final class ResultOfProcessMessage
    extends JsonData {
        @SerializedName(value="transaction")
        @NonNull
        private final Map<String, Object> transaction;
        @SerializedName(value="out_messages")
        @NonNull
        private final String[] outMessages;
        @SerializedName(value="decoded")
        private final DecodedOutput decoded;
        @SerializedName(value="fees")
        @NonNull
        private final Tvm.TransactionFees fees;

        public Optional<DecodedOutput> decoded() {
            return Optional.ofNullable(this.decoded);
        }

        @Generated
        public ResultOfProcessMessage(@NonNull Map<String, Object> transaction, @NonNull String[] outMessages, DecodedOutput decoded, @NonNull Tvm.TransactionFees fees) {
            if (transaction == null) {
                throw new NullPointerException("transaction is marked non-null but is null");
            }
            if (outMessages == null) {
                throw new NullPointerException("outMessages is marked non-null but is null");
            }
            if (fees == null) {
                throw new NullPointerException("fees is marked non-null but is null");
            }
            this.transaction = transaction;
            this.outMessages = outMessages;
            this.decoded = decoded;
            this.fees = fees;
        }

        @NonNull
        @Generated
        public Map<String, Object> transaction() {
            return this.transaction;
        }

        @NonNull
        @Generated
        public String[] outMessages() {
            return this.outMessages;
        }

        @NonNull
        @Generated
        public Tvm.TransactionFees fees() {
            return this.fees;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfProcessMessage)) {
                return false;
            }
            ResultOfProcessMessage other = (ResultOfProcessMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Object> this$transaction = this.transaction();
            Map<String, Object> other$transaction = other.transaction();
            if (this$transaction == null ? other$transaction != null : !((Object)this$transaction).equals(other$transaction)) {
                return false;
            }
            if (!Arrays.deepEquals(this.outMessages(), other.outMessages())) {
                return false;
            }
            Optional<DecodedOutput> this$decoded = this.decoded();
            Optional<DecodedOutput> other$decoded = other.decoded();
            if (this$decoded == null ? other$decoded != null : !((Object)this$decoded).equals(other$decoded)) {
                return false;
            }
            Tvm.TransactionFees this$fees = this.fees();
            Tvm.TransactionFees other$fees = other.fees();
            return !(this$fees == null ? other$fees != null : !((Object)this$fees).equals(other$fees));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfProcessMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Object> $transaction = this.transaction();
            result = result * 59 + ($transaction == null ? 43 : ((Object)$transaction).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.outMessages());
            Optional<DecodedOutput> $decoded = this.decoded();
            result = result * 59 + ($decoded == null ? 43 : ((Object)$decoded).hashCode());
            Tvm.TransactionFees $fees = this.fees();
            result = result * 59 + ($fees == null ? 43 : ((Object)$fees).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Processing.ResultOfProcessMessage(transaction=" + this.transaction() + ", outMessages=" + Arrays.deepToString(this.outMessages()) + ", decoded=" + this.decoded() + ", fees=" + this.fees() + ")";
        }
    }

    public static final class ParamsOfProcessMessage
    extends JsonData {
        @SerializedName(value="message_encode_params")
        @NonNull
        private final Abi.ParamsOfEncodeMessage messageEncodeParams;
        @SerializedName(value="send_events")
        @NonNull
        private final Boolean sendEvents;

        @Generated
        public ParamsOfProcessMessage(@NonNull Abi.ParamsOfEncodeMessage messageEncodeParams, @NonNull Boolean sendEvents) {
            if (messageEncodeParams == null) {
                throw new NullPointerException("messageEncodeParams is marked non-null but is null");
            }
            if (sendEvents == null) {
                throw new NullPointerException("sendEvents is marked non-null but is null");
            }
            this.messageEncodeParams = messageEncodeParams;
            this.sendEvents = sendEvents;
        }

        @NonNull
        @Generated
        public Abi.ParamsOfEncodeMessage messageEncodeParams() {
            return this.messageEncodeParams;
        }

        @NonNull
        @Generated
        public Boolean sendEvents() {
            return this.sendEvents;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfProcessMessage)) {
                return false;
            }
            ParamsOfProcessMessage other = (ParamsOfProcessMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$sendEvents = this.sendEvents();
            Boolean other$sendEvents = other.sendEvents();
            if (this$sendEvents == null ? other$sendEvents != null : !((Object)this$sendEvents).equals(other$sendEvents)) {
                return false;
            }
            Abi.ParamsOfEncodeMessage this$messageEncodeParams = this.messageEncodeParams();
            Abi.ParamsOfEncodeMessage other$messageEncodeParams = other.messageEncodeParams();
            return !(this$messageEncodeParams == null ? other$messageEncodeParams != null : !((Object)this$messageEncodeParams).equals(other$messageEncodeParams));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfProcessMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $sendEvents = this.sendEvents();
            result = result * 59 + ($sendEvents == null ? 43 : ((Object)$sendEvents).hashCode());
            Abi.ParamsOfEncodeMessage $messageEncodeParams = this.messageEncodeParams();
            result = result * 59 + ($messageEncodeParams == null ? 43 : ((Object)$messageEncodeParams).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Processing.ParamsOfProcessMessage(messageEncodeParams=" + this.messageEncodeParams() + ", sendEvents=" + this.sendEvents() + ")";
        }
    }

    public static final class DecodedOutput
    extends JsonData {
        @SerializedName(value="out_messages")
        private final Abi.DecodedMessageBody[] outMessages;
        @SerializedName(value="output")
        private final Map<String, Object> output;

        public Optional<Abi.DecodedMessageBody[]> outMessages() {
            return Optional.ofNullable(this.outMessages);
        }

        public Optional<Map<String, Object>> output() {
            return Optional.ofNullable(this.output);
        }

        @Generated
        public DecodedOutput(Abi.DecodedMessageBody[] outMessages, Map<String, Object> output) {
            this.outMessages = outMessages;
            this.output = output;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DecodedOutput)) {
                return false;
            }
            DecodedOutput other = (DecodedOutput)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Abi.DecodedMessageBody[]> this$outMessages = this.outMessages();
            Optional<Abi.DecodedMessageBody[]> other$outMessages = other.outMessages();
            if (this$outMessages == null ? other$outMessages != null : !((Object)this$outMessages).equals(other$outMessages)) {
                return false;
            }
            Optional<Map<String, Object>> this$output = this.output();
            Optional<Map<String, Object>> other$output = other.output();
            return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DecodedOutput;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Abi.DecodedMessageBody[]> $outMessages = this.outMessages();
            result = result * 59 + ($outMessages == null ? 43 : ((Object)$outMessages).hashCode());
            Optional<Map<String, Object>> $output = this.output();
            result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Processing.DecodedOutput(outMessages=" + this.outMessages() + ", output=" + this.output() + ")";
        }
    }
}

