/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.json.JsonData;

public class Crypto {
    public static CompletableFuture<ResultOfFactorize> factorize(@NonNull Context context, @NonNull String composite) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (composite == null) {
            throw new NullPointerException("composite is marked non-null but is null");
        }
        return context.future("crypto.factorize", new ParamsOfFactorize(composite), ResultOfFactorize.class);
    }

    public static CompletableFuture<ResultOfModularPower> modularPower(@NonNull Context context, @NonNull String base, @NonNull String exponent, @NonNull String modulus) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent is marked non-null but is null");
        }
        if (modulus == null) {
            throw new NullPointerException("modulus is marked non-null but is null");
        }
        return context.future("crypto.modular_power", new ParamsOfModularPower(base, exponent, modulus), ResultOfModularPower.class);
    }

    public static CompletableFuture<ResultOfTonCrc16> tonCrc16(@NonNull Context context, @NonNull String data) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return context.future("crypto.ton_crc16", new ParamsOfTonCrc16(data), ResultOfTonCrc16.class);
    }

    public static CompletableFuture<ResultOfGenerateRandomBytes> generateRandomBytes(@NonNull Context context, @NonNull Number length) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (length == null) {
            throw new NullPointerException("length is marked non-null but is null");
        }
        return context.future("crypto.generate_random_bytes", new ParamsOfGenerateRandomBytes(length), ResultOfGenerateRandomBytes.class);
    }

    public static CompletableFuture<ResultOfConvertPublicKeyToTonSafeFormat> convertPublicKeyToTonSafeFormat(@NonNull Context context, @NonNull String publicKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return context.future("crypto.convert_public_key_to_ton_safe_format", new ParamsOfConvertPublicKeyToTonSafeFormat(publicKey), ResultOfConvertPublicKeyToTonSafeFormat.class);
    }

    public static CompletableFuture<KeyPair> generateRandomSignKeys(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("crypto.generate_random_sign_keys", null, KeyPair.class);
    }

    public static CompletableFuture<ResultOfSign> sign(@NonNull Context context, @NonNull String unsigned, @NonNull KeyPair keys) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (unsigned == null) {
            throw new NullPointerException("unsigned is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return context.future("crypto.sign", new ParamsOfSign(unsigned, keys), ResultOfSign.class);
    }

    public static CompletableFuture<ResultOfVerifySignature> verifySignature(@NonNull Context context, @NonNull String signed, @NonNull String publicKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (signed == null) {
            throw new NullPointerException("signed is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return context.future("crypto.verify_signature", new ParamsOfVerifySignature(signed, publicKey), ResultOfVerifySignature.class);
    }

    public static CompletableFuture<ResultOfHash> sha256(@NonNull Context context, @NonNull String data) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return context.future("crypto.sha256", new ParamsOfHash(data), ResultOfHash.class);
    }

    public static CompletableFuture<ResultOfHash> sha512(@NonNull Context context, @NonNull String data) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return context.future("crypto.sha512", new ParamsOfHash(data), ResultOfHash.class);
    }

    public static CompletableFuture<ResultOfScrypt> scrypt(@NonNull Context context, @NonNull String password, @NonNull String salt, @NonNull Number logN, @NonNull Number r, @NonNull Number p, @NonNull Number dkLen) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (salt == null) {
            throw new NullPointerException("salt is marked non-null but is null");
        }
        if (logN == null) {
            throw new NullPointerException("logN is marked non-null but is null");
        }
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (dkLen == null) {
            throw new NullPointerException("dkLen is marked non-null but is null");
        }
        return context.future("crypto.scrypt", new ParamsOfScrypt(password, salt, logN, r, p, dkLen), ResultOfScrypt.class);
    }

    public static CompletableFuture<KeyPair> naclSignKeypairFromSecretKey(@NonNull Context context, @NonNull String secretKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        return context.future("crypto.nacl_sign_keypair_from_secret_key", new ParamsOfNaclSignKeyPairFromSecret(secretKey), KeyPair.class);
    }

    public static CompletableFuture<ResultOfNaclSign> naclSign(@NonNull Context context, @NonNull String unsigned, @NonNull String secretKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (unsigned == null) {
            throw new NullPointerException("unsigned is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        return context.future("crypto.nacl_sign", new ParamsOfNaclSign(unsigned, secretKey), ResultOfNaclSign.class);
    }

    public static CompletableFuture<ResultOfNaclSignOpen> naclSignOpen(@NonNull Context context, @NonNull String signed, @NonNull String publicKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (signed == null) {
            throw new NullPointerException("signed is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return context.future("crypto.nacl_sign_open", new ParamsOfNaclSignOpen(signed, publicKey), ResultOfNaclSignOpen.class);
    }

    public static CompletableFuture<ResultOfNaclSignDetached> naclSignDetached(@NonNull Context context, @NonNull String unsigned, @NonNull String secretKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (unsigned == null) {
            throw new NullPointerException("unsigned is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        return context.future("crypto.nacl_sign_detached", new ParamsOfNaclSign(unsigned, secretKey), ResultOfNaclSignDetached.class);
    }

    public static CompletableFuture<ResultOfNaclSignDetachedVerify> naclSignDetachedVerify(@NonNull Context context, @NonNull String unsigned, @NonNull String signature, @NonNull String publicKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (unsigned == null) {
            throw new NullPointerException("unsigned is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return context.future("crypto.nacl_sign_detached_verify", new ParamsOfNaclSignDetachedVerify(unsigned, signature, publicKey), ResultOfNaclSignDetachedVerify.class);
    }

    public static CompletableFuture<KeyPair> naclBoxKeypair(@NonNull Context context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("crypto.nacl_box_keypair", null, KeyPair.class);
    }

    public static CompletableFuture<KeyPair> naclBoxKeypairFromSecretKey(@NonNull Context context, @NonNull String secretKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        return context.future("crypto.nacl_box_keypair_from_secret_key", new ParamsOfNaclBoxKeyPairFromSecret(secretKey), KeyPair.class);
    }

    public static CompletableFuture<ResultOfNaclBox> naclBox(@NonNull Context context, @NonNull String decrypted, @NonNull String nonce, @NonNull String theirPublic, @NonNull String secretKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (decrypted == null) {
            throw new NullPointerException("decrypted is marked non-null but is null");
        }
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        if (theirPublic == null) {
            throw new NullPointerException("theirPublic is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        return context.future("crypto.nacl_box", new ParamsOfNaclBox(decrypted, nonce, theirPublic, secretKey), ResultOfNaclBox.class);
    }

    public static CompletableFuture<ResultOfNaclBoxOpen> naclBoxOpen(@NonNull Context context, @NonNull String encrypted, @NonNull String nonce, @NonNull String theirPublic, @NonNull String secretKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        if (theirPublic == null) {
            throw new NullPointerException("theirPublic is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        return context.future("crypto.nacl_box_open", new ParamsOfNaclBoxOpen(encrypted, nonce, theirPublic, secretKey), ResultOfNaclBoxOpen.class);
    }

    public static CompletableFuture<ResultOfNaclBox> naclSecretBox(@NonNull Context context, @NonNull String decrypted, @NonNull String nonce, @NonNull String key) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (decrypted == null) {
            throw new NullPointerException("decrypted is marked non-null but is null");
        }
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return context.future("crypto.nacl_secret_box", new ParamsOfNaclSecretBox(decrypted, nonce, key), ResultOfNaclBox.class);
    }

    public static CompletableFuture<ResultOfNaclBoxOpen> naclSecretBoxOpen(@NonNull Context context, @NonNull String encrypted, @NonNull String nonce, @NonNull String key) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (encrypted == null) {
            throw new NullPointerException("encrypted is marked non-null but is null");
        }
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return context.future("crypto.nacl_secret_box_open", new ParamsOfNaclSecretBoxOpen(encrypted, nonce, key), ResultOfNaclBoxOpen.class);
    }

    public static CompletableFuture<ResultOfMnemonicWords> mnemonicWords(@NonNull Context context, Number dictionary) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("crypto.mnemonic_words", new ParamsOfMnemonicWords(dictionary), ResultOfMnemonicWords.class);
    }

    public static CompletableFuture<ResultOfMnemonicFromRandom> mnemonicFromRandom(@NonNull Context context, Number dictionary, Number wordCount) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("crypto.mnemonic_from_random", new ParamsOfMnemonicFromRandom(dictionary, wordCount), ResultOfMnemonicFromRandom.class);
    }

    public static CompletableFuture<ResultOfMnemonicFromEntropy> mnemonicFromEntropy(@NonNull Context context, @NonNull String entropy, Number dictionary, Number wordCount) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (entropy == null) {
            throw new NullPointerException("entropy is marked non-null but is null");
        }
        return context.future("crypto.mnemonic_from_entropy", new ParamsOfMnemonicFromEntropy(entropy, dictionary, wordCount), ResultOfMnemonicFromEntropy.class);
    }

    public static CompletableFuture<ResultOfMnemonicVerify> mnemonicVerify(@NonNull Context context, @NonNull String phrase, Number dictionary, Number wordCount) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (phrase == null) {
            throw new NullPointerException("phrase is marked non-null but is null");
        }
        return context.future("crypto.mnemonic_verify", new ParamsOfMnemonicVerify(phrase, dictionary, wordCount), ResultOfMnemonicVerify.class);
    }

    public static CompletableFuture<KeyPair> mnemonicDeriveSignKeys(@NonNull Context context, @NonNull String phrase, String path, Number dictionary, Number wordCount) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (phrase == null) {
            throw new NullPointerException("phrase is marked non-null but is null");
        }
        return context.future("crypto.mnemonic_derive_sign_keys", new ParamsOfMnemonicDeriveSignKeys(phrase, path, dictionary, wordCount), KeyPair.class);
    }

    public static CompletableFuture<ResultOfHDKeyXPrvFromMnemonic> hdkeyXprvFromMnemonic(@NonNull Context context, @NonNull String phrase, Number dictionary, Number wordCount) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (phrase == null) {
            throw new NullPointerException("phrase is marked non-null but is null");
        }
        return context.future("crypto.hdkey_xprv_from_mnemonic", new ParamsOfHDKeyXPrvFromMnemonic(phrase, dictionary, wordCount), ResultOfHDKeyXPrvFromMnemonic.class);
    }

    public static CompletableFuture<ResultOfHDKeyDeriveFromXPrv> hdkeyDeriveFromXprv(@NonNull Context context, @NonNull String xprv, @NonNull Number childIndex, @NonNull Boolean hardened) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (xprv == null) {
            throw new NullPointerException("xprv is marked non-null but is null");
        }
        if (childIndex == null) {
            throw new NullPointerException("childIndex is marked non-null but is null");
        }
        if (hardened == null) {
            throw new NullPointerException("hardened is marked non-null but is null");
        }
        return context.future("crypto.hdkey_derive_from_xprv", new ParamsOfHDKeyDeriveFromXPrv(xprv, childIndex, hardened), ResultOfHDKeyDeriveFromXPrv.class);
    }

    public static CompletableFuture<ResultOfHDKeyDeriveFromXPrvPath> hdkeyDeriveFromXprvPath(@NonNull Context context, @NonNull String xprv, @NonNull String path) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (xprv == null) {
            throw new NullPointerException("xprv is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return context.future("crypto.hdkey_derive_from_xprv_path", new ParamsOfHDKeyDeriveFromXPrvPath(xprv, path), ResultOfHDKeyDeriveFromXPrvPath.class);
    }

    public static CompletableFuture<ResultOfHDKeySecretFromXPrv> hdkeySecretFromXprv(@NonNull Context context, @NonNull String xprv) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (xprv == null) {
            throw new NullPointerException("xprv is marked non-null but is null");
        }
        return context.future("crypto.hdkey_secret_from_xprv", new ParamsOfHDKeySecretFromXPrv(xprv), ResultOfHDKeySecretFromXPrv.class);
    }

    public static CompletableFuture<ResultOfHDKeyPublicFromXPrv> hdkeyPublicFromXprv(@NonNull Context context, @NonNull String xprv) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (xprv == null) {
            throw new NullPointerException("xprv is marked non-null but is null");
        }
        return context.future("crypto.hdkey_public_from_xprv", new ParamsOfHDKeyPublicFromXPrv(xprv), ResultOfHDKeyPublicFromXPrv.class);
    }

    public static CompletableFuture<ResultOfChaCha20> chacha20(@NonNull Context context, @NonNull String data, @NonNull String key, @NonNull String nonce) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        return context.future("crypto.chacha20", new ParamsOfChaCha20(data, key, nonce), ResultOfChaCha20.class);
    }

    public static CompletableFuture<RegisteredSigningBox> getSigningBox(@NonNull Context context, @NonNull String publicKey, @NonNull String secretKey) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        return context.future("crypto.get_signing_box", new KeyPair(publicKey, secretKey), RegisteredSigningBox.class);
    }

    public static CompletableFuture<ResultOfSigningBoxGetPublicKey> signingBoxGetPublicKey(@NonNull Context context, @NonNull Integer handle) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (handle == null) {
            throw new NullPointerException("handle is marked non-null but is null");
        }
        return context.future("crypto.signing_box_get_public_key", new RegisteredSigningBox(handle), ResultOfSigningBoxGetPublicKey.class);
    }

    public static CompletableFuture<ResultOfSigningBoxSign> signingBoxSign(@NonNull Context context, @NonNull Integer signingBox, @NonNull String unsigned) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (signingBox == null) {
            throw new NullPointerException("signingBox is marked non-null but is null");
        }
        if (unsigned == null) {
            throw new NullPointerException("unsigned is marked non-null but is null");
        }
        return context.future("crypto.signing_box_sign", new ParamsOfSigningBoxSign(signingBox, unsigned), ResultOfSigningBoxSign.class);
    }

    public static CompletableFuture<Void> removeSigningBox(@NonNull Context context, @NonNull Integer handle) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (handle == null) {
            throw new NullPointerException("handle is marked non-null but is null");
        }
        return context.future("crypto.remove_signing_box", new RegisteredSigningBox(handle), Void.class);
    }

    public static CompletableFuture<Void> removeEncryptionBox(@NonNull Context context, @NonNull Integer handle) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (handle == null) {
            throw new NullPointerException("handle is marked non-null but is null");
        }
        return context.future("crypto.remove_encryption_box", new RegisteredEncryptionBox(handle), Void.class);
    }

    public static CompletableFuture<ResultOfEncryptionBoxGetInfo> encryptionBoxGetInfo(@NonNull Context context, @NonNull Integer encryptionBox) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (encryptionBox == null) {
            throw new NullPointerException("encryptionBox is marked non-null but is null");
        }
        return context.future("crypto.encryption_box_get_info", new ParamsOfEncryptionBoxGetInfo(encryptionBox), ResultOfEncryptionBoxGetInfo.class);
    }

    public static CompletableFuture<ResultOfEncryptionBoxEncrypt> encryptionBoxEncrypt(@NonNull Context context, @NonNull Integer encryptionBox, @NonNull String data) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (encryptionBox == null) {
            throw new NullPointerException("encryptionBox is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return context.future("crypto.encryption_box_encrypt", new ParamsOfEncryptionBoxEncrypt(encryptionBox, data), ResultOfEncryptionBoxEncrypt.class);
    }

    public static CompletableFuture<ResultOfEncryptionBoxDecrypt> encryptionBoxDecrypt(@NonNull Context context, @NonNull Integer encryptionBox, @NonNull String data) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (encryptionBox == null) {
            throw new NullPointerException("encryptionBox is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return context.future("crypto.encryption_box_decrypt", new ParamsOfEncryptionBoxDecrypt(encryptionBox, data), ResultOfEncryptionBoxDecrypt.class);
    }

    public static CompletableFuture<RegisteredEncryptionBox> createEncryptionBox(@NonNull Context context, @NonNull EncryptionAlgorithm algorithm) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (algorithm == null) {
            throw new NullPointerException("algorithm is marked non-null but is null");
        }
        return context.future("crypto.create_encryption_box", new ParamsOfCreateEncryptionBox(algorithm), RegisteredEncryptionBox.class);
    }

    public static final class ParamsOfFactorize
    extends JsonData {
        @SerializedName(value="composite")
        @NonNull
        private final String composite;

        @Generated
        public ParamsOfFactorize(@NonNull String composite) {
            if (composite == null) {
                throw new NullPointerException("composite is marked non-null but is null");
            }
            this.composite = composite;
        }

        @NonNull
        @Generated
        public String composite() {
            return this.composite;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfFactorize)) {
                return false;
            }
            ParamsOfFactorize other = (ParamsOfFactorize)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$composite = this.composite();
            String other$composite = other.composite();
            return !(this$composite == null ? other$composite != null : !this$composite.equals(other$composite));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfFactorize;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $composite = this.composite();
            result = result * 59 + ($composite == null ? 43 : $composite.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfFactorize(composite=" + this.composite() + ")";
        }
    }

    public static final class ResultOfFactorize
    extends JsonData {
        @SerializedName(value="factors")
        @NonNull
        private final String[] factors;

        @Generated
        public ResultOfFactorize(@NonNull String[] factors) {
            if (factors == null) {
                throw new NullPointerException("factors is marked non-null but is null");
            }
            this.factors = factors;
        }

        @NonNull
        @Generated
        public String[] factors() {
            return this.factors;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfFactorize)) {
                return false;
            }
            ResultOfFactorize other = (ResultOfFactorize)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return Arrays.deepEquals(this.factors(), other.factors());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfFactorize;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Arrays.deepHashCode(this.factors());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfFactorize(factors=" + Arrays.deepToString(this.factors()) + ")";
        }
    }

    public static final class ParamsOfModularPower
    extends JsonData {
        @SerializedName(value="base")
        @NonNull
        private final String base;
        @SerializedName(value="exponent")
        @NonNull
        private final String exponent;
        @SerializedName(value="modulus")
        @NonNull
        private final String modulus;

        @Generated
        public ParamsOfModularPower(@NonNull String base, @NonNull String exponent, @NonNull String modulus) {
            if (base == null) {
                throw new NullPointerException("base is marked non-null but is null");
            }
            if (exponent == null) {
                throw new NullPointerException("exponent is marked non-null but is null");
            }
            if (modulus == null) {
                throw new NullPointerException("modulus is marked non-null but is null");
            }
            this.base = base;
            this.exponent = exponent;
            this.modulus = modulus;
        }

        @NonNull
        @Generated
        public String base() {
            return this.base;
        }

        @NonNull
        @Generated
        public String exponent() {
            return this.exponent;
        }

        @NonNull
        @Generated
        public String modulus() {
            return this.modulus;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfModularPower)) {
                return false;
            }
            ParamsOfModularPower other = (ParamsOfModularPower)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$base = this.base();
            String other$base = other.base();
            if (this$base == null ? other$base != null : !this$base.equals(other$base)) {
                return false;
            }
            String this$exponent = this.exponent();
            String other$exponent = other.exponent();
            if (this$exponent == null ? other$exponent != null : !this$exponent.equals(other$exponent)) {
                return false;
            }
            String this$modulus = this.modulus();
            String other$modulus = other.modulus();
            return !(this$modulus == null ? other$modulus != null : !this$modulus.equals(other$modulus));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfModularPower;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $base = this.base();
            result = result * 59 + ($base == null ? 43 : $base.hashCode());
            String $exponent = this.exponent();
            result = result * 59 + ($exponent == null ? 43 : $exponent.hashCode());
            String $modulus = this.modulus();
            result = result * 59 + ($modulus == null ? 43 : $modulus.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfModularPower(base=" + this.base() + ", exponent=" + this.exponent() + ", modulus=" + this.modulus() + ")";
        }
    }

    public static final class ResultOfModularPower
    extends JsonData {
        @SerializedName(value="modular_power")
        @NonNull
        private final String modularPower;

        @Generated
        public ResultOfModularPower(@NonNull String modularPower) {
            if (modularPower == null) {
                throw new NullPointerException("modularPower is marked non-null but is null");
            }
            this.modularPower = modularPower;
        }

        @NonNull
        @Generated
        public String modularPower() {
            return this.modularPower;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfModularPower)) {
                return false;
            }
            ResultOfModularPower other = (ResultOfModularPower)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$modularPower = this.modularPower();
            String other$modularPower = other.modularPower();
            return !(this$modularPower == null ? other$modularPower != null : !this$modularPower.equals(other$modularPower));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfModularPower;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $modularPower = this.modularPower();
            result = result * 59 + ($modularPower == null ? 43 : $modularPower.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfModularPower(modularPower=" + this.modularPower() + ")";
        }
    }

    public static final class ParamsOfTonCrc16
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ParamsOfTonCrc16(@NonNull String data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfTonCrc16)) {
                return false;
            }
            ParamsOfTonCrc16 other = (ParamsOfTonCrc16)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfTonCrc16;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfTonCrc16(data=" + this.data() + ")";
        }
    }

    public static final class ResultOfTonCrc16
    extends JsonData {
        @SerializedName(value="crc")
        @NonNull
        private final Number crc;

        @Generated
        public ResultOfTonCrc16(@NonNull Number crc) {
            if (crc == null) {
                throw new NullPointerException("crc is marked non-null but is null");
            }
            this.crc = crc;
        }

        @NonNull
        @Generated
        public Number crc() {
            return this.crc;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfTonCrc16)) {
                return false;
            }
            ResultOfTonCrc16 other = (ResultOfTonCrc16)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Number this$crc = this.crc();
            Number other$crc = other.crc();
            return !(this$crc == null ? other$crc != null : !this$crc.equals(other$crc));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfTonCrc16;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Number $crc = this.crc();
            result = result * 59 + ($crc == null ? 43 : $crc.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfTonCrc16(crc=" + this.crc() + ")";
        }
    }

    public static final class ParamsOfGenerateRandomBytes
    extends JsonData {
        @SerializedName(value="length")
        @NonNull
        private final Number length;

        @Generated
        public ParamsOfGenerateRandomBytes(@NonNull Number length) {
            if (length == null) {
                throw new NullPointerException("length is marked non-null but is null");
            }
            this.length = length;
        }

        @NonNull
        @Generated
        public Number length() {
            return this.length;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfGenerateRandomBytes)) {
                return false;
            }
            ParamsOfGenerateRandomBytes other = (ParamsOfGenerateRandomBytes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Number this$length = this.length();
            Number other$length = other.length();
            return !(this$length == null ? other$length != null : !this$length.equals(other$length));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfGenerateRandomBytes;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Number $length = this.length();
            result = result * 59 + ($length == null ? 43 : $length.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfGenerateRandomBytes(length=" + this.length() + ")";
        }
    }

    public static final class ResultOfGenerateRandomBytes
    extends JsonData {
        @SerializedName(value="bytes")
        @NonNull
        private final String bytes;

        @Generated
        public ResultOfGenerateRandomBytes(@NonNull String bytes) {
            if (bytes == null) {
                throw new NullPointerException("bytes is marked non-null but is null");
            }
            this.bytes = bytes;
        }

        @NonNull
        @Generated
        public String bytes() {
            return this.bytes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfGenerateRandomBytes)) {
                return false;
            }
            ResultOfGenerateRandomBytes other = (ResultOfGenerateRandomBytes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$bytes = this.bytes();
            String other$bytes = other.bytes();
            return !(this$bytes == null ? other$bytes != null : !this$bytes.equals(other$bytes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfGenerateRandomBytes;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $bytes = this.bytes();
            result = result * 59 + ($bytes == null ? 43 : $bytes.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfGenerateRandomBytes(bytes=" + this.bytes() + ")";
        }
    }

    public static final class ParamsOfConvertPublicKeyToTonSafeFormat
    extends JsonData {
        @SerializedName(value="public_key")
        @NonNull
        private final String publicKey;

        @Generated
        public ParamsOfConvertPublicKeyToTonSafeFormat(@NonNull String publicKey) {
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            this.publicKey = publicKey;
        }

        @NonNull
        @Generated
        public String publicKey() {
            return this.publicKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfConvertPublicKeyToTonSafeFormat)) {
                return false;
            }
            ParamsOfConvertPublicKeyToTonSafeFormat other = (ParamsOfConvertPublicKeyToTonSafeFormat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$publicKey = this.publicKey();
            String other$publicKey = other.publicKey();
            return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfConvertPublicKeyToTonSafeFormat;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $publicKey = this.publicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfConvertPublicKeyToTonSafeFormat(publicKey=" + this.publicKey() + ")";
        }
    }

    public static final class ResultOfConvertPublicKeyToTonSafeFormat
    extends JsonData {
        @SerializedName(value="ton_public_key")
        @NonNull
        private final String tonPublicKey;

        @Generated
        public ResultOfConvertPublicKeyToTonSafeFormat(@NonNull String tonPublicKey) {
            if (tonPublicKey == null) {
                throw new NullPointerException("tonPublicKey is marked non-null but is null");
            }
            this.tonPublicKey = tonPublicKey;
        }

        @NonNull
        @Generated
        public String tonPublicKey() {
            return this.tonPublicKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfConvertPublicKeyToTonSafeFormat)) {
                return false;
            }
            ResultOfConvertPublicKeyToTonSafeFormat other = (ResultOfConvertPublicKeyToTonSafeFormat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$tonPublicKey = this.tonPublicKey();
            String other$tonPublicKey = other.tonPublicKey();
            return !(this$tonPublicKey == null ? other$tonPublicKey != null : !this$tonPublicKey.equals(other$tonPublicKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfConvertPublicKeyToTonSafeFormat;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $tonPublicKey = this.tonPublicKey();
            result = result * 59 + ($tonPublicKey == null ? 43 : $tonPublicKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfConvertPublicKeyToTonSafeFormat(tonPublicKey=" + this.tonPublicKey() + ")";
        }
    }

    public static final class KeyPair
    extends JsonData {
        @SerializedName(value="public")
        @NonNull
        private final String publicKey;
        @SerializedName(value="secret")
        @NonNull
        private final String secretKey;

        @Generated
        public KeyPair(@NonNull String publicKey, @NonNull String secretKey) {
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            if (secretKey == null) {
                throw new NullPointerException("secretKey is marked non-null but is null");
            }
            this.publicKey = publicKey;
            this.secretKey = secretKey;
        }

        @NonNull
        @Generated
        public String publicKey() {
            return this.publicKey;
        }

        @NonNull
        @Generated
        public String secretKey() {
            return this.secretKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyPair)) {
                return false;
            }
            KeyPair other = (KeyPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$publicKey = this.publicKey();
            String other$publicKey = other.publicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            String this$secretKey = this.secretKey();
            String other$secretKey = other.secretKey();
            return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KeyPair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $publicKey = this.publicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            String $secretKey = this.secretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.KeyPair(publicKey=" + this.publicKey() + ", secretKey=" + this.secretKey() + ")";
        }
    }

    public static final class ParamsOfSign
    extends JsonData {
        @SerializedName(value="unsigned")
        @NonNull
        private final String unsigned;
        @SerializedName(value="keys")
        @NonNull
        private final KeyPair keys;

        @Generated
        public ParamsOfSign(@NonNull String unsigned, @NonNull KeyPair keys) {
            if (unsigned == null) {
                throw new NullPointerException("unsigned is marked non-null but is null");
            }
            if (keys == null) {
                throw new NullPointerException("keys is marked non-null but is null");
            }
            this.unsigned = unsigned;
            this.keys = keys;
        }

        @NonNull
        @Generated
        public String unsigned() {
            return this.unsigned;
        }

        @NonNull
        @Generated
        public KeyPair keys() {
            return this.keys;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfSign)) {
                return false;
            }
            ParamsOfSign other = (ParamsOfSign)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$unsigned = this.unsigned();
            String other$unsigned = other.unsigned();
            if (this$unsigned == null ? other$unsigned != null : !this$unsigned.equals(other$unsigned)) {
                return false;
            }
            KeyPair this$keys = this.keys();
            KeyPair other$keys = other.keys();
            return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfSign;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $unsigned = this.unsigned();
            result = result * 59 + ($unsigned == null ? 43 : $unsigned.hashCode());
            KeyPair $keys = this.keys();
            result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfSign(unsigned=" + this.unsigned() + ", keys=" + this.keys() + ")";
        }
    }

    public static final class ResultOfSign
    extends JsonData {
        @SerializedName(value="signed")
        @NonNull
        private final String signed;
        @SerializedName(value="signature")
        @NonNull
        private final String signature;

        @Generated
        public ResultOfSign(@NonNull String signed, @NonNull String signature) {
            if (signed == null) {
                throw new NullPointerException("signed is marked non-null but is null");
            }
            if (signature == null) {
                throw new NullPointerException("signature is marked non-null but is null");
            }
            this.signed = signed;
            this.signature = signature;
        }

        @NonNull
        @Generated
        public String signed() {
            return this.signed;
        }

        @NonNull
        @Generated
        public String signature() {
            return this.signature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfSign)) {
                return false;
            }
            ResultOfSign other = (ResultOfSign)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$signed = this.signed();
            String other$signed = other.signed();
            if (this$signed == null ? other$signed != null : !this$signed.equals(other$signed)) {
                return false;
            }
            String this$signature = this.signature();
            String other$signature = other.signature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfSign;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $signed = this.signed();
            result = result * 59 + ($signed == null ? 43 : $signed.hashCode());
            String $signature = this.signature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfSign(signed=" + this.signed() + ", signature=" + this.signature() + ")";
        }
    }

    public static final class ParamsOfVerifySignature
    extends JsonData {
        @SerializedName(value="signed")
        @NonNull
        private final String signed;
        @SerializedName(value="public")
        @NonNull
        private final String publicKey;

        @Generated
        public ParamsOfVerifySignature(@NonNull String signed, @NonNull String publicKey) {
            if (signed == null) {
                throw new NullPointerException("signed is marked non-null but is null");
            }
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            this.signed = signed;
            this.publicKey = publicKey;
        }

        @NonNull
        @Generated
        public String signed() {
            return this.signed;
        }

        @NonNull
        @Generated
        public String publicKey() {
            return this.publicKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfVerifySignature)) {
                return false;
            }
            ParamsOfVerifySignature other = (ParamsOfVerifySignature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$signed = this.signed();
            String other$signed = other.signed();
            if (this$signed == null ? other$signed != null : !this$signed.equals(other$signed)) {
                return false;
            }
            String this$publicKey = this.publicKey();
            String other$publicKey = other.publicKey();
            return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfVerifySignature;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $signed = this.signed();
            result = result * 59 + ($signed == null ? 43 : $signed.hashCode());
            String $publicKey = this.publicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfVerifySignature(signed=" + this.signed() + ", publicKey=" + this.publicKey() + ")";
        }
    }

    public static final class ResultOfVerifySignature
    extends JsonData {
        @SerializedName(value="unsigned")
        @NonNull
        private final String unsigned;

        @Generated
        public ResultOfVerifySignature(@NonNull String unsigned) {
            if (unsigned == null) {
                throw new NullPointerException("unsigned is marked non-null but is null");
            }
            this.unsigned = unsigned;
        }

        @NonNull
        @Generated
        public String unsigned() {
            return this.unsigned;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfVerifySignature)) {
                return false;
            }
            ResultOfVerifySignature other = (ResultOfVerifySignature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$unsigned = this.unsigned();
            String other$unsigned = other.unsigned();
            return !(this$unsigned == null ? other$unsigned != null : !this$unsigned.equals(other$unsigned));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfVerifySignature;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $unsigned = this.unsigned();
            result = result * 59 + ($unsigned == null ? 43 : $unsigned.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfVerifySignature(unsigned=" + this.unsigned() + ")";
        }
    }

    public static final class ParamsOfHash
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ParamsOfHash(@NonNull String data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfHash)) {
                return false;
            }
            ParamsOfHash other = (ParamsOfHash)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfHash;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfHash(data=" + this.data() + ")";
        }
    }

    public static final class ResultOfHash
    extends JsonData {
        @SerializedName(value="hash")
        @NonNull
        private final String hash;

        @Generated
        public ResultOfHash(@NonNull String hash) {
            if (hash == null) {
                throw new NullPointerException("hash is marked non-null but is null");
            }
            this.hash = hash;
        }

        @NonNull
        @Generated
        public String hash() {
            return this.hash;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfHash)) {
                return false;
            }
            ResultOfHash other = (ResultOfHash)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$hash = this.hash();
            String other$hash = other.hash();
            return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfHash;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $hash = this.hash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfHash(hash=" + this.hash() + ")";
        }
    }

    public static final class ParamsOfScrypt
    extends JsonData {
        @SerializedName(value="password")
        @NonNull
        private final String password;
        @SerializedName(value="salt")
        @NonNull
        private final String salt;
        @SerializedName(value="log_n")
        @NonNull
        private final Number logN;
        @SerializedName(value="r")
        @NonNull
        private final Number r;
        @SerializedName(value="p")
        @NonNull
        private final Number p;
        @SerializedName(value="dk_len")
        @NonNull
        private final Number dkLen;

        @Generated
        public ParamsOfScrypt(@NonNull String password, @NonNull String salt, @NonNull Number logN, @NonNull Number r, @NonNull Number p, @NonNull Number dkLen) {
            if (password == null) {
                throw new NullPointerException("password is marked non-null but is null");
            }
            if (salt == null) {
                throw new NullPointerException("salt is marked non-null but is null");
            }
            if (logN == null) {
                throw new NullPointerException("logN is marked non-null but is null");
            }
            if (r == null) {
                throw new NullPointerException("r is marked non-null but is null");
            }
            if (p == null) {
                throw new NullPointerException("p is marked non-null but is null");
            }
            if (dkLen == null) {
                throw new NullPointerException("dkLen is marked non-null but is null");
            }
            this.password = password;
            this.salt = salt;
            this.logN = logN;
            this.r = r;
            this.p = p;
            this.dkLen = dkLen;
        }

        @NonNull
        @Generated
        public String password() {
            return this.password;
        }

        @NonNull
        @Generated
        public String salt() {
            return this.salt;
        }

        @NonNull
        @Generated
        public Number logN() {
            return this.logN;
        }

        @NonNull
        @Generated
        public Number r() {
            return this.r;
        }

        @NonNull
        @Generated
        public Number p() {
            return this.p;
        }

        @NonNull
        @Generated
        public Number dkLen() {
            return this.dkLen;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfScrypt)) {
                return false;
            }
            ParamsOfScrypt other = (ParamsOfScrypt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$password = this.password();
            String other$password = other.password();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$salt = this.salt();
            String other$salt = other.salt();
            if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
                return false;
            }
            Number this$logN = this.logN();
            Number other$logN = other.logN();
            if (this$logN == null ? other$logN != null : !this$logN.equals(other$logN)) {
                return false;
            }
            Number this$r = this.r();
            Number other$r = other.r();
            if (this$r == null ? other$r != null : !this$r.equals(other$r)) {
                return false;
            }
            Number this$p = this.p();
            Number other$p = other.p();
            if (this$p == null ? other$p != null : !this$p.equals(other$p)) {
                return false;
            }
            Number this$dkLen = this.dkLen();
            Number other$dkLen = other.dkLen();
            return !(this$dkLen == null ? other$dkLen != null : !this$dkLen.equals(other$dkLen));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfScrypt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $password = this.password();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $salt = this.salt();
            result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
            Number $logN = this.logN();
            result = result * 59 + ($logN == null ? 43 : $logN.hashCode());
            Number $r = this.r();
            result = result * 59 + ($r == null ? 43 : $r.hashCode());
            Number $p = this.p();
            result = result * 59 + ($p == null ? 43 : $p.hashCode());
            Number $dkLen = this.dkLen();
            result = result * 59 + ($dkLen == null ? 43 : $dkLen.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfScrypt(password=" + this.password() + ", salt=" + this.salt() + ", logN=" + this.logN() + ", r=" + this.r() + ", p=" + this.p() + ", dkLen=" + this.dkLen() + ")";
        }
    }

    public static final class ResultOfScrypt
    extends JsonData {
        @SerializedName(value="key")
        @NonNull
        private final String key;

        @Generated
        public ResultOfScrypt(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
        }

        @NonNull
        @Generated
        public String key() {
            return this.key;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfScrypt)) {
                return false;
            }
            ResultOfScrypt other = (ResultOfScrypt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$key = this.key();
            String other$key = other.key();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfScrypt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $key = this.key();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfScrypt(key=" + this.key() + ")";
        }
    }

    public static final class ParamsOfNaclSignKeyPairFromSecret
    extends JsonData {
        @SerializedName(value="secret")
        @NonNull
        private final String secretKey;

        @Generated
        public ParamsOfNaclSignKeyPairFromSecret(@NonNull String secretKey) {
            if (secretKey == null) {
                throw new NullPointerException("secretKey is marked non-null but is null");
            }
            this.secretKey = secretKey;
        }

        @NonNull
        @Generated
        public String secretKey() {
            return this.secretKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfNaclSignKeyPairFromSecret)) {
                return false;
            }
            ParamsOfNaclSignKeyPairFromSecret other = (ParamsOfNaclSignKeyPairFromSecret)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$secretKey = this.secretKey();
            String other$secretKey = other.secretKey();
            return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfNaclSignKeyPairFromSecret;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $secretKey = this.secretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfNaclSignKeyPairFromSecret(secretKey=" + this.secretKey() + ")";
        }
    }

    public static final class ParamsOfNaclSign
    extends JsonData {
        @SerializedName(value="unsigned")
        @NonNull
        private final String unsigned;
        @SerializedName(value="secret")
        @NonNull
        private final String secretKey;

        @Generated
        public ParamsOfNaclSign(@NonNull String unsigned, @NonNull String secretKey) {
            if (unsigned == null) {
                throw new NullPointerException("unsigned is marked non-null but is null");
            }
            if (secretKey == null) {
                throw new NullPointerException("secretKey is marked non-null but is null");
            }
            this.unsigned = unsigned;
            this.secretKey = secretKey;
        }

        @NonNull
        @Generated
        public String unsigned() {
            return this.unsigned;
        }

        @NonNull
        @Generated
        public String secretKey() {
            return this.secretKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfNaclSign)) {
                return false;
            }
            ParamsOfNaclSign other = (ParamsOfNaclSign)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$unsigned = this.unsigned();
            String other$unsigned = other.unsigned();
            if (this$unsigned == null ? other$unsigned != null : !this$unsigned.equals(other$unsigned)) {
                return false;
            }
            String this$secretKey = this.secretKey();
            String other$secretKey = other.secretKey();
            return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfNaclSign;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $unsigned = this.unsigned();
            result = result * 59 + ($unsigned == null ? 43 : $unsigned.hashCode());
            String $secretKey = this.secretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfNaclSign(unsigned=" + this.unsigned() + ", secretKey=" + this.secretKey() + ")";
        }
    }

    public static final class ResultOfNaclSign
    extends JsonData {
        @SerializedName(value="signed")
        @NonNull
        private final String signed;

        @Generated
        public ResultOfNaclSign(@NonNull String signed) {
            if (signed == null) {
                throw new NullPointerException("signed is marked non-null but is null");
            }
            this.signed = signed;
        }

        @NonNull
        @Generated
        public String signed() {
            return this.signed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfNaclSign)) {
                return false;
            }
            ResultOfNaclSign other = (ResultOfNaclSign)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$signed = this.signed();
            String other$signed = other.signed();
            return !(this$signed == null ? other$signed != null : !this$signed.equals(other$signed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfNaclSign;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $signed = this.signed();
            result = result * 59 + ($signed == null ? 43 : $signed.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfNaclSign(signed=" + this.signed() + ")";
        }
    }

    public static final class ParamsOfNaclSignOpen
    extends JsonData {
        @SerializedName(value="signed")
        @NonNull
        private final String signed;
        @SerializedName(value="public")
        @NonNull
        private final String publicKey;

        @Generated
        public ParamsOfNaclSignOpen(@NonNull String signed, @NonNull String publicKey) {
            if (signed == null) {
                throw new NullPointerException("signed is marked non-null but is null");
            }
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            this.signed = signed;
            this.publicKey = publicKey;
        }

        @NonNull
        @Generated
        public String signed() {
            return this.signed;
        }

        @NonNull
        @Generated
        public String publicKey() {
            return this.publicKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfNaclSignOpen)) {
                return false;
            }
            ParamsOfNaclSignOpen other = (ParamsOfNaclSignOpen)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$signed = this.signed();
            String other$signed = other.signed();
            if (this$signed == null ? other$signed != null : !this$signed.equals(other$signed)) {
                return false;
            }
            String this$publicKey = this.publicKey();
            String other$publicKey = other.publicKey();
            return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfNaclSignOpen;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $signed = this.signed();
            result = result * 59 + ($signed == null ? 43 : $signed.hashCode());
            String $publicKey = this.publicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfNaclSignOpen(signed=" + this.signed() + ", publicKey=" + this.publicKey() + ")";
        }
    }

    public static final class ResultOfNaclSignOpen
    extends JsonData {
        @SerializedName(value="unsigned")
        @NonNull
        private final String unsigned;

        @Generated
        public ResultOfNaclSignOpen(@NonNull String unsigned) {
            if (unsigned == null) {
                throw new NullPointerException("unsigned is marked non-null but is null");
            }
            this.unsigned = unsigned;
        }

        @NonNull
        @Generated
        public String unsigned() {
            return this.unsigned;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfNaclSignOpen)) {
                return false;
            }
            ResultOfNaclSignOpen other = (ResultOfNaclSignOpen)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$unsigned = this.unsigned();
            String other$unsigned = other.unsigned();
            return !(this$unsigned == null ? other$unsigned != null : !this$unsigned.equals(other$unsigned));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfNaclSignOpen;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $unsigned = this.unsigned();
            result = result * 59 + ($unsigned == null ? 43 : $unsigned.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfNaclSignOpen(unsigned=" + this.unsigned() + ")";
        }
    }

    public static final class ResultOfNaclSignDetached
    extends JsonData {
        @SerializedName(value="signature")
        @NonNull
        private final String signature;

        @Generated
        public ResultOfNaclSignDetached(@NonNull String signature) {
            if (signature == null) {
                throw new NullPointerException("signature is marked non-null but is null");
            }
            this.signature = signature;
        }

        @NonNull
        @Generated
        public String signature() {
            return this.signature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfNaclSignDetached)) {
                return false;
            }
            ResultOfNaclSignDetached other = (ResultOfNaclSignDetached)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$signature = this.signature();
            String other$signature = other.signature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfNaclSignDetached;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $signature = this.signature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfNaclSignDetached(signature=" + this.signature() + ")";
        }
    }

    public static final class ParamsOfNaclSignDetachedVerify
    extends JsonData {
        @SerializedName(value="unsigned")
        @NonNull
        private final String unsigned;
        @SerializedName(value="signature")
        @NonNull
        private final String signature;
        @SerializedName(value="public")
        @NonNull
        private final String publicKey;

        @Generated
        public ParamsOfNaclSignDetachedVerify(@NonNull String unsigned, @NonNull String signature, @NonNull String publicKey) {
            if (unsigned == null) {
                throw new NullPointerException("unsigned is marked non-null but is null");
            }
            if (signature == null) {
                throw new NullPointerException("signature is marked non-null but is null");
            }
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            this.unsigned = unsigned;
            this.signature = signature;
            this.publicKey = publicKey;
        }

        @NonNull
        @Generated
        public String unsigned() {
            return this.unsigned;
        }

        @NonNull
        @Generated
        public String signature() {
            return this.signature;
        }

        @NonNull
        @Generated
        public String publicKey() {
            return this.publicKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfNaclSignDetachedVerify)) {
                return false;
            }
            ParamsOfNaclSignDetachedVerify other = (ParamsOfNaclSignDetachedVerify)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$unsigned = this.unsigned();
            String other$unsigned = other.unsigned();
            if (this$unsigned == null ? other$unsigned != null : !this$unsigned.equals(other$unsigned)) {
                return false;
            }
            String this$signature = this.signature();
            String other$signature = other.signature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            String this$publicKey = this.publicKey();
            String other$publicKey = other.publicKey();
            return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfNaclSignDetachedVerify;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $unsigned = this.unsigned();
            result = result * 59 + ($unsigned == null ? 43 : $unsigned.hashCode());
            String $signature = this.signature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            String $publicKey = this.publicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfNaclSignDetachedVerify(unsigned=" + this.unsigned() + ", signature=" + this.signature() + ", publicKey=" + this.publicKey() + ")";
        }
    }

    public static final class ResultOfNaclSignDetachedVerify
    extends JsonData {
        @SerializedName(value="succeeded")
        @NonNull
        private final Boolean succeeded;

        @Generated
        public ResultOfNaclSignDetachedVerify(@NonNull Boolean succeeded) {
            if (succeeded == null) {
                throw new NullPointerException("succeeded is marked non-null but is null");
            }
            this.succeeded = succeeded;
        }

        @NonNull
        @Generated
        public Boolean succeeded() {
            return this.succeeded;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfNaclSignDetachedVerify)) {
                return false;
            }
            ResultOfNaclSignDetachedVerify other = (ResultOfNaclSignDetachedVerify)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$succeeded = this.succeeded();
            Boolean other$succeeded = other.succeeded();
            return !(this$succeeded == null ? other$succeeded != null : !((Object)this$succeeded).equals(other$succeeded));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfNaclSignDetachedVerify;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $succeeded = this.succeeded();
            result = result * 59 + ($succeeded == null ? 43 : ((Object)$succeeded).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfNaclSignDetachedVerify(succeeded=" + this.succeeded() + ")";
        }
    }

    public static final class ParamsOfNaclBoxKeyPairFromSecret
    extends JsonData {
        @SerializedName(value="secret")
        @NonNull
        private final String secretKey;

        @Generated
        public ParamsOfNaclBoxKeyPairFromSecret(@NonNull String secretKey) {
            if (secretKey == null) {
                throw new NullPointerException("secretKey is marked non-null but is null");
            }
            this.secretKey = secretKey;
        }

        @NonNull
        @Generated
        public String secretKey() {
            return this.secretKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfNaclBoxKeyPairFromSecret)) {
                return false;
            }
            ParamsOfNaclBoxKeyPairFromSecret other = (ParamsOfNaclBoxKeyPairFromSecret)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$secretKey = this.secretKey();
            String other$secretKey = other.secretKey();
            return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfNaclBoxKeyPairFromSecret;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $secretKey = this.secretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfNaclBoxKeyPairFromSecret(secretKey=" + this.secretKey() + ")";
        }
    }

    public static final class ParamsOfNaclBox
    extends JsonData {
        @SerializedName(value="decrypted")
        @NonNull
        private final String decrypted;
        @SerializedName(value="nonce")
        @NonNull
        private final String nonce;
        @SerializedName(value="their_public")
        @NonNull
        private final String theirPublic;
        @SerializedName(value="secret")
        @NonNull
        private final String secretKey;

        @Generated
        public ParamsOfNaclBox(@NonNull String decrypted, @NonNull String nonce, @NonNull String theirPublic, @NonNull String secretKey) {
            if (decrypted == null) {
                throw new NullPointerException("decrypted is marked non-null but is null");
            }
            if (nonce == null) {
                throw new NullPointerException("nonce is marked non-null but is null");
            }
            if (theirPublic == null) {
                throw new NullPointerException("theirPublic is marked non-null but is null");
            }
            if (secretKey == null) {
                throw new NullPointerException("secretKey is marked non-null but is null");
            }
            this.decrypted = decrypted;
            this.nonce = nonce;
            this.theirPublic = theirPublic;
            this.secretKey = secretKey;
        }

        @NonNull
        @Generated
        public String decrypted() {
            return this.decrypted;
        }

        @NonNull
        @Generated
        public String nonce() {
            return this.nonce;
        }

        @NonNull
        @Generated
        public String theirPublic() {
            return this.theirPublic;
        }

        @NonNull
        @Generated
        public String secretKey() {
            return this.secretKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfNaclBox)) {
                return false;
            }
            ParamsOfNaclBox other = (ParamsOfNaclBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$decrypted = this.decrypted();
            String other$decrypted = other.decrypted();
            if (this$decrypted == null ? other$decrypted != null : !this$decrypted.equals(other$decrypted)) {
                return false;
            }
            String this$nonce = this.nonce();
            String other$nonce = other.nonce();
            if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
                return false;
            }
            String this$theirPublic = this.theirPublic();
            String other$theirPublic = other.theirPublic();
            if (this$theirPublic == null ? other$theirPublic != null : !this$theirPublic.equals(other$theirPublic)) {
                return false;
            }
            String this$secretKey = this.secretKey();
            String other$secretKey = other.secretKey();
            return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfNaclBox;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $decrypted = this.decrypted();
            result = result * 59 + ($decrypted == null ? 43 : $decrypted.hashCode());
            String $nonce = this.nonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            String $theirPublic = this.theirPublic();
            result = result * 59 + ($theirPublic == null ? 43 : $theirPublic.hashCode());
            String $secretKey = this.secretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfNaclBox(decrypted=" + this.decrypted() + ", nonce=" + this.nonce() + ", theirPublic=" + this.theirPublic() + ", secretKey=" + this.secretKey() + ")";
        }
    }

    public static final class ResultOfNaclBox
    extends JsonData {
        @SerializedName(value="encrypted")
        @NonNull
        private final String encrypted;

        @Generated
        public ResultOfNaclBox(@NonNull String encrypted) {
            if (encrypted == null) {
                throw new NullPointerException("encrypted is marked non-null but is null");
            }
            this.encrypted = encrypted;
        }

        @NonNull
        @Generated
        public String encrypted() {
            return this.encrypted;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfNaclBox)) {
                return false;
            }
            ResultOfNaclBox other = (ResultOfNaclBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$encrypted = this.encrypted();
            String other$encrypted = other.encrypted();
            return !(this$encrypted == null ? other$encrypted != null : !this$encrypted.equals(other$encrypted));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfNaclBox;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $encrypted = this.encrypted();
            result = result * 59 + ($encrypted == null ? 43 : $encrypted.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfNaclBox(encrypted=" + this.encrypted() + ")";
        }
    }

    public static final class ParamsOfNaclBoxOpen
    extends JsonData {
        @SerializedName(value="encrypted")
        @NonNull
        private final String encrypted;
        @SerializedName(value="nonce")
        @NonNull
        private final String nonce;
        @SerializedName(value="their_public")
        @NonNull
        private final String theirPublic;
        @SerializedName(value="secret")
        @NonNull
        private final String secretKey;

        @Generated
        public ParamsOfNaclBoxOpen(@NonNull String encrypted, @NonNull String nonce, @NonNull String theirPublic, @NonNull String secretKey) {
            if (encrypted == null) {
                throw new NullPointerException("encrypted is marked non-null but is null");
            }
            if (nonce == null) {
                throw new NullPointerException("nonce is marked non-null but is null");
            }
            if (theirPublic == null) {
                throw new NullPointerException("theirPublic is marked non-null but is null");
            }
            if (secretKey == null) {
                throw new NullPointerException("secretKey is marked non-null but is null");
            }
            this.encrypted = encrypted;
            this.nonce = nonce;
            this.theirPublic = theirPublic;
            this.secretKey = secretKey;
        }

        @NonNull
        @Generated
        public String encrypted() {
            return this.encrypted;
        }

        @NonNull
        @Generated
        public String nonce() {
            return this.nonce;
        }

        @NonNull
        @Generated
        public String theirPublic() {
            return this.theirPublic;
        }

        @NonNull
        @Generated
        public String secretKey() {
            return this.secretKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfNaclBoxOpen)) {
                return false;
            }
            ParamsOfNaclBoxOpen other = (ParamsOfNaclBoxOpen)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$encrypted = this.encrypted();
            String other$encrypted = other.encrypted();
            if (this$encrypted == null ? other$encrypted != null : !this$encrypted.equals(other$encrypted)) {
                return false;
            }
            String this$nonce = this.nonce();
            String other$nonce = other.nonce();
            if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
                return false;
            }
            String this$theirPublic = this.theirPublic();
            String other$theirPublic = other.theirPublic();
            if (this$theirPublic == null ? other$theirPublic != null : !this$theirPublic.equals(other$theirPublic)) {
                return false;
            }
            String this$secretKey = this.secretKey();
            String other$secretKey = other.secretKey();
            return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfNaclBoxOpen;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $encrypted = this.encrypted();
            result = result * 59 + ($encrypted == null ? 43 : $encrypted.hashCode());
            String $nonce = this.nonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            String $theirPublic = this.theirPublic();
            result = result * 59 + ($theirPublic == null ? 43 : $theirPublic.hashCode());
            String $secretKey = this.secretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfNaclBoxOpen(encrypted=" + this.encrypted() + ", nonce=" + this.nonce() + ", theirPublic=" + this.theirPublic() + ", secretKey=" + this.secretKey() + ")";
        }
    }

    public static final class ResultOfNaclBoxOpen
    extends JsonData {
        @SerializedName(value="decrypted")
        @NonNull
        private final String decrypted;

        @Generated
        public ResultOfNaclBoxOpen(@NonNull String decrypted) {
            if (decrypted == null) {
                throw new NullPointerException("decrypted is marked non-null but is null");
            }
            this.decrypted = decrypted;
        }

        @NonNull
        @Generated
        public String decrypted() {
            return this.decrypted;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfNaclBoxOpen)) {
                return false;
            }
            ResultOfNaclBoxOpen other = (ResultOfNaclBoxOpen)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$decrypted = this.decrypted();
            String other$decrypted = other.decrypted();
            return !(this$decrypted == null ? other$decrypted != null : !this$decrypted.equals(other$decrypted));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfNaclBoxOpen;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $decrypted = this.decrypted();
            result = result * 59 + ($decrypted == null ? 43 : $decrypted.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfNaclBoxOpen(decrypted=" + this.decrypted() + ")";
        }
    }

    public static final class ParamsOfNaclSecretBox
    extends JsonData {
        @SerializedName(value="decrypted")
        @NonNull
        private final String decrypted;
        @SerializedName(value="nonce")
        @NonNull
        private final String nonce;
        @SerializedName(value="key")
        @NonNull
        private final String key;

        @Generated
        public ParamsOfNaclSecretBox(@NonNull String decrypted, @NonNull String nonce, @NonNull String key) {
            if (decrypted == null) {
                throw new NullPointerException("decrypted is marked non-null but is null");
            }
            if (nonce == null) {
                throw new NullPointerException("nonce is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.decrypted = decrypted;
            this.nonce = nonce;
            this.key = key;
        }

        @NonNull
        @Generated
        public String decrypted() {
            return this.decrypted;
        }

        @NonNull
        @Generated
        public String nonce() {
            return this.nonce;
        }

        @NonNull
        @Generated
        public String key() {
            return this.key;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfNaclSecretBox)) {
                return false;
            }
            ParamsOfNaclSecretBox other = (ParamsOfNaclSecretBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$decrypted = this.decrypted();
            String other$decrypted = other.decrypted();
            if (this$decrypted == null ? other$decrypted != null : !this$decrypted.equals(other$decrypted)) {
                return false;
            }
            String this$nonce = this.nonce();
            String other$nonce = other.nonce();
            if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
                return false;
            }
            String this$key = this.key();
            String other$key = other.key();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfNaclSecretBox;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $decrypted = this.decrypted();
            result = result * 59 + ($decrypted == null ? 43 : $decrypted.hashCode());
            String $nonce = this.nonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            String $key = this.key();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfNaclSecretBox(decrypted=" + this.decrypted() + ", nonce=" + this.nonce() + ", key=" + this.key() + ")";
        }
    }

    public static final class ParamsOfNaclSecretBoxOpen
    extends JsonData {
        @SerializedName(value="encrypted")
        @NonNull
        private final String encrypted;
        @SerializedName(value="nonce")
        @NonNull
        private final String nonce;
        @SerializedName(value="key")
        @NonNull
        private final String key;

        @Generated
        public ParamsOfNaclSecretBoxOpen(@NonNull String encrypted, @NonNull String nonce, @NonNull String key) {
            if (encrypted == null) {
                throw new NullPointerException("encrypted is marked non-null but is null");
            }
            if (nonce == null) {
                throw new NullPointerException("nonce is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.encrypted = encrypted;
            this.nonce = nonce;
            this.key = key;
        }

        @NonNull
        @Generated
        public String encrypted() {
            return this.encrypted;
        }

        @NonNull
        @Generated
        public String nonce() {
            return this.nonce;
        }

        @NonNull
        @Generated
        public String key() {
            return this.key;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfNaclSecretBoxOpen)) {
                return false;
            }
            ParamsOfNaclSecretBoxOpen other = (ParamsOfNaclSecretBoxOpen)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$encrypted = this.encrypted();
            String other$encrypted = other.encrypted();
            if (this$encrypted == null ? other$encrypted != null : !this$encrypted.equals(other$encrypted)) {
                return false;
            }
            String this$nonce = this.nonce();
            String other$nonce = other.nonce();
            if (this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce)) {
                return false;
            }
            String this$key = this.key();
            String other$key = other.key();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfNaclSecretBoxOpen;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $encrypted = this.encrypted();
            result = result * 59 + ($encrypted == null ? 43 : $encrypted.hashCode());
            String $nonce = this.nonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            String $key = this.key();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfNaclSecretBoxOpen(encrypted=" + this.encrypted() + ", nonce=" + this.nonce() + ", key=" + this.key() + ")";
        }
    }

    public static final class ParamsOfMnemonicWords
    extends JsonData {
        @SerializedName(value="dictionary")
        private final Number dictionary;

        public Optional<Number> dictionary() {
            return Optional.ofNullable(this.dictionary);
        }

        @Generated
        public ParamsOfMnemonicWords(Number dictionary) {
            this.dictionary = dictionary;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfMnemonicWords)) {
                return false;
            }
            ParamsOfMnemonicWords other = (ParamsOfMnemonicWords)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Number> this$dictionary = this.dictionary();
            Optional<Number> other$dictionary = other.dictionary();
            return !(this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfMnemonicWords;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Number> $dictionary = this.dictionary();
            result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfMnemonicWords(dictionary=" + this.dictionary() + ")";
        }
    }

    public static final class ResultOfMnemonicWords
    extends JsonData {
        @SerializedName(value="words")
        @NonNull
        private final String words;

        @Generated
        public ResultOfMnemonicWords(@NonNull String words) {
            if (words == null) {
                throw new NullPointerException("words is marked non-null but is null");
            }
            this.words = words;
        }

        @NonNull
        @Generated
        public String words() {
            return this.words;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfMnemonicWords)) {
                return false;
            }
            ResultOfMnemonicWords other = (ResultOfMnemonicWords)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$words = this.words();
            String other$words = other.words();
            return !(this$words == null ? other$words != null : !this$words.equals(other$words));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfMnemonicWords;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $words = this.words();
            result = result * 59 + ($words == null ? 43 : $words.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfMnemonicWords(words=" + this.words() + ")";
        }
    }

    public static final class ParamsOfMnemonicFromRandom
    extends JsonData {
        @SerializedName(value="dictionary")
        private final Number dictionary;
        @SerializedName(value="word_count")
        private final Number wordCount;

        public Optional<Number> dictionary() {
            return Optional.ofNullable(this.dictionary);
        }

        public Optional<Number> wordCount() {
            return Optional.ofNullable(this.wordCount);
        }

        @Generated
        public ParamsOfMnemonicFromRandom(Number dictionary, Number wordCount) {
            this.dictionary = dictionary;
            this.wordCount = wordCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfMnemonicFromRandom)) {
                return false;
            }
            ParamsOfMnemonicFromRandom other = (ParamsOfMnemonicFromRandom)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Number> this$dictionary = this.dictionary();
            Optional<Number> other$dictionary = other.dictionary();
            if (this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary)) {
                return false;
            }
            Optional<Number> this$wordCount = this.wordCount();
            Optional<Number> other$wordCount = other.wordCount();
            return !(this$wordCount == null ? other$wordCount != null : !((Object)this$wordCount).equals(other$wordCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfMnemonicFromRandom;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Number> $dictionary = this.dictionary();
            result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
            Optional<Number> $wordCount = this.wordCount();
            result = result * 59 + ($wordCount == null ? 43 : ((Object)$wordCount).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfMnemonicFromRandom(dictionary=" + this.dictionary() + ", wordCount=" + this.wordCount() + ")";
        }
    }

    public static final class ResultOfMnemonicFromRandom
    extends JsonData {
        @SerializedName(value="phrase")
        @NonNull
        private final String phrase;

        @Generated
        public ResultOfMnemonicFromRandom(@NonNull String phrase) {
            if (phrase == null) {
                throw new NullPointerException("phrase is marked non-null but is null");
            }
            this.phrase = phrase;
        }

        @NonNull
        @Generated
        public String phrase() {
            return this.phrase;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfMnemonicFromRandom)) {
                return false;
            }
            ResultOfMnemonicFromRandom other = (ResultOfMnemonicFromRandom)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$phrase = this.phrase();
            String other$phrase = other.phrase();
            return !(this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfMnemonicFromRandom;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $phrase = this.phrase();
            result = result * 59 + ($phrase == null ? 43 : $phrase.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfMnemonicFromRandom(phrase=" + this.phrase() + ")";
        }
    }

    public static final class ParamsOfMnemonicFromEntropy
    extends JsonData {
        @SerializedName(value="entropy")
        @NonNull
        private final String entropy;
        @SerializedName(value="dictionary")
        private final Number dictionary;
        @SerializedName(value="word_count")
        private final Number wordCount;

        public Optional<Number> dictionary() {
            return Optional.ofNullable(this.dictionary);
        }

        public Optional<Number> wordCount() {
            return Optional.ofNullable(this.wordCount);
        }

        @Generated
        public ParamsOfMnemonicFromEntropy(@NonNull String entropy, Number dictionary, Number wordCount) {
            if (entropy == null) {
                throw new NullPointerException("entropy is marked non-null but is null");
            }
            this.entropy = entropy;
            this.dictionary = dictionary;
            this.wordCount = wordCount;
        }

        @NonNull
        @Generated
        public String entropy() {
            return this.entropy;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfMnemonicFromEntropy)) {
                return false;
            }
            ParamsOfMnemonicFromEntropy other = (ParamsOfMnemonicFromEntropy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$entropy = this.entropy();
            String other$entropy = other.entropy();
            if (this$entropy == null ? other$entropy != null : !this$entropy.equals(other$entropy)) {
                return false;
            }
            Optional<Number> this$dictionary = this.dictionary();
            Optional<Number> other$dictionary = other.dictionary();
            if (this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary)) {
                return false;
            }
            Optional<Number> this$wordCount = this.wordCount();
            Optional<Number> other$wordCount = other.wordCount();
            return !(this$wordCount == null ? other$wordCount != null : !((Object)this$wordCount).equals(other$wordCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfMnemonicFromEntropy;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $entropy = this.entropy();
            result = result * 59 + ($entropy == null ? 43 : $entropy.hashCode());
            Optional<Number> $dictionary = this.dictionary();
            result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
            Optional<Number> $wordCount = this.wordCount();
            result = result * 59 + ($wordCount == null ? 43 : ((Object)$wordCount).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfMnemonicFromEntropy(entropy=" + this.entropy() + ", dictionary=" + this.dictionary() + ", wordCount=" + this.wordCount() + ")";
        }
    }

    public static final class ResultOfMnemonicFromEntropy
    extends JsonData {
        @SerializedName(value="phrase")
        @NonNull
        private final String phrase;

        @Generated
        public ResultOfMnemonicFromEntropy(@NonNull String phrase) {
            if (phrase == null) {
                throw new NullPointerException("phrase is marked non-null but is null");
            }
            this.phrase = phrase;
        }

        @NonNull
        @Generated
        public String phrase() {
            return this.phrase;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfMnemonicFromEntropy)) {
                return false;
            }
            ResultOfMnemonicFromEntropy other = (ResultOfMnemonicFromEntropy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$phrase = this.phrase();
            String other$phrase = other.phrase();
            return !(this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfMnemonicFromEntropy;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $phrase = this.phrase();
            result = result * 59 + ($phrase == null ? 43 : $phrase.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfMnemonicFromEntropy(phrase=" + this.phrase() + ")";
        }
    }

    public static final class ParamsOfMnemonicVerify
    extends JsonData {
        @SerializedName(value="phrase")
        @NonNull
        private final String phrase;
        @SerializedName(value="dictionary")
        private final Number dictionary;
        @SerializedName(value="word_count")
        private final Number wordCount;

        public Optional<Number> dictionary() {
            return Optional.ofNullable(this.dictionary);
        }

        public Optional<Number> wordCount() {
            return Optional.ofNullable(this.wordCount);
        }

        @Generated
        public ParamsOfMnemonicVerify(@NonNull String phrase, Number dictionary, Number wordCount) {
            if (phrase == null) {
                throw new NullPointerException("phrase is marked non-null but is null");
            }
            this.phrase = phrase;
            this.dictionary = dictionary;
            this.wordCount = wordCount;
        }

        @NonNull
        @Generated
        public String phrase() {
            return this.phrase;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfMnemonicVerify)) {
                return false;
            }
            ParamsOfMnemonicVerify other = (ParamsOfMnemonicVerify)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$phrase = this.phrase();
            String other$phrase = other.phrase();
            if (this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase)) {
                return false;
            }
            Optional<Number> this$dictionary = this.dictionary();
            Optional<Number> other$dictionary = other.dictionary();
            if (this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary)) {
                return false;
            }
            Optional<Number> this$wordCount = this.wordCount();
            Optional<Number> other$wordCount = other.wordCount();
            return !(this$wordCount == null ? other$wordCount != null : !((Object)this$wordCount).equals(other$wordCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfMnemonicVerify;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $phrase = this.phrase();
            result = result * 59 + ($phrase == null ? 43 : $phrase.hashCode());
            Optional<Number> $dictionary = this.dictionary();
            result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
            Optional<Number> $wordCount = this.wordCount();
            result = result * 59 + ($wordCount == null ? 43 : ((Object)$wordCount).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfMnemonicVerify(phrase=" + this.phrase() + ", dictionary=" + this.dictionary() + ", wordCount=" + this.wordCount() + ")";
        }
    }

    public static final class ResultOfMnemonicVerify
    extends JsonData {
        @SerializedName(value="valid")
        @NonNull
        private final Boolean valid;

        @Generated
        public ResultOfMnemonicVerify(@NonNull Boolean valid) {
            if (valid == null) {
                throw new NullPointerException("valid is marked non-null but is null");
            }
            this.valid = valid;
        }

        @NonNull
        @Generated
        public Boolean valid() {
            return this.valid;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfMnemonicVerify)) {
                return false;
            }
            ResultOfMnemonicVerify other = (ResultOfMnemonicVerify)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$valid = this.valid();
            Boolean other$valid = other.valid();
            return !(this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfMnemonicVerify;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $valid = this.valid();
            result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfMnemonicVerify(valid=" + this.valid() + ")";
        }
    }

    public static final class ParamsOfMnemonicDeriveSignKeys
    extends JsonData {
        @SerializedName(value="phrase")
        @NonNull
        private final String phrase;
        @SerializedName(value="path")
        private final String path;
        @SerializedName(value="dictionary")
        private final Number dictionary;
        @SerializedName(value="word_count")
        private final Number wordCount;

        public Optional<String> path() {
            return Optional.ofNullable(this.path);
        }

        public Optional<Number> dictionary() {
            return Optional.ofNullable(this.dictionary);
        }

        public Optional<Number> wordCount() {
            return Optional.ofNullable(this.wordCount);
        }

        @Generated
        public ParamsOfMnemonicDeriveSignKeys(@NonNull String phrase, String path, Number dictionary, Number wordCount) {
            if (phrase == null) {
                throw new NullPointerException("phrase is marked non-null but is null");
            }
            this.phrase = phrase;
            this.path = path;
            this.dictionary = dictionary;
            this.wordCount = wordCount;
        }

        @NonNull
        @Generated
        public String phrase() {
            return this.phrase;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfMnemonicDeriveSignKeys)) {
                return false;
            }
            ParamsOfMnemonicDeriveSignKeys other = (ParamsOfMnemonicDeriveSignKeys)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$phrase = this.phrase();
            String other$phrase = other.phrase();
            if (this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase)) {
                return false;
            }
            Optional<String> this$path = this.path();
            Optional<String> other$path = other.path();
            if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
                return false;
            }
            Optional<Number> this$dictionary = this.dictionary();
            Optional<Number> other$dictionary = other.dictionary();
            if (this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary)) {
                return false;
            }
            Optional<Number> this$wordCount = this.wordCount();
            Optional<Number> other$wordCount = other.wordCount();
            return !(this$wordCount == null ? other$wordCount != null : !((Object)this$wordCount).equals(other$wordCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfMnemonicDeriveSignKeys;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $phrase = this.phrase();
            result = result * 59 + ($phrase == null ? 43 : $phrase.hashCode());
            Optional<String> $path = this.path();
            result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
            Optional<Number> $dictionary = this.dictionary();
            result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
            Optional<Number> $wordCount = this.wordCount();
            result = result * 59 + ($wordCount == null ? 43 : ((Object)$wordCount).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfMnemonicDeriveSignKeys(phrase=" + this.phrase() + ", path=" + this.path() + ", dictionary=" + this.dictionary() + ", wordCount=" + this.wordCount() + ")";
        }
    }

    public static final class ParamsOfHDKeyXPrvFromMnemonic
    extends JsonData {
        @SerializedName(value="phrase")
        @NonNull
        private final String phrase;
        @SerializedName(value="dictionary")
        private final Number dictionary;
        @SerializedName(value="word_count")
        private final Number wordCount;

        public Optional<Number> dictionary() {
            return Optional.ofNullable(this.dictionary);
        }

        public Optional<Number> wordCount() {
            return Optional.ofNullable(this.wordCount);
        }

        @Generated
        public ParamsOfHDKeyXPrvFromMnemonic(@NonNull String phrase, Number dictionary, Number wordCount) {
            if (phrase == null) {
                throw new NullPointerException("phrase is marked non-null but is null");
            }
            this.phrase = phrase;
            this.dictionary = dictionary;
            this.wordCount = wordCount;
        }

        @NonNull
        @Generated
        public String phrase() {
            return this.phrase;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfHDKeyXPrvFromMnemonic)) {
                return false;
            }
            ParamsOfHDKeyXPrvFromMnemonic other = (ParamsOfHDKeyXPrvFromMnemonic)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$phrase = this.phrase();
            String other$phrase = other.phrase();
            if (this$phrase == null ? other$phrase != null : !this$phrase.equals(other$phrase)) {
                return false;
            }
            Optional<Number> this$dictionary = this.dictionary();
            Optional<Number> other$dictionary = other.dictionary();
            if (this$dictionary == null ? other$dictionary != null : !((Object)this$dictionary).equals(other$dictionary)) {
                return false;
            }
            Optional<Number> this$wordCount = this.wordCount();
            Optional<Number> other$wordCount = other.wordCount();
            return !(this$wordCount == null ? other$wordCount != null : !((Object)this$wordCount).equals(other$wordCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfHDKeyXPrvFromMnemonic;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $phrase = this.phrase();
            result = result * 59 + ($phrase == null ? 43 : $phrase.hashCode());
            Optional<Number> $dictionary = this.dictionary();
            result = result * 59 + ($dictionary == null ? 43 : ((Object)$dictionary).hashCode());
            Optional<Number> $wordCount = this.wordCount();
            result = result * 59 + ($wordCount == null ? 43 : ((Object)$wordCount).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfHDKeyXPrvFromMnemonic(phrase=" + this.phrase() + ", dictionary=" + this.dictionary() + ", wordCount=" + this.wordCount() + ")";
        }
    }

    public static final class ResultOfHDKeyXPrvFromMnemonic
    extends JsonData {
        @SerializedName(value="xprv")
        @NonNull
        private final String xprv;

        @Generated
        public ResultOfHDKeyXPrvFromMnemonic(@NonNull String xprv) {
            if (xprv == null) {
                throw new NullPointerException("xprv is marked non-null but is null");
            }
            this.xprv = xprv;
        }

        @NonNull
        @Generated
        public String xprv() {
            return this.xprv;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfHDKeyXPrvFromMnemonic)) {
                return false;
            }
            ResultOfHDKeyXPrvFromMnemonic other = (ResultOfHDKeyXPrvFromMnemonic)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$xprv = this.xprv();
            String other$xprv = other.xprv();
            return !(this$xprv == null ? other$xprv != null : !this$xprv.equals(other$xprv));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfHDKeyXPrvFromMnemonic;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $xprv = this.xprv();
            result = result * 59 + ($xprv == null ? 43 : $xprv.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfHDKeyXPrvFromMnemonic(xprv=" + this.xprv() + ")";
        }
    }

    public static final class ParamsOfHDKeyDeriveFromXPrv
    extends JsonData {
        @SerializedName(value="xprv")
        @NonNull
        private final String xprv;
        @SerializedName(value="child_index")
        @NonNull
        private final Number childIndex;
        @SerializedName(value="hardened")
        @NonNull
        private final Boolean hardened;

        @Generated
        public ParamsOfHDKeyDeriveFromXPrv(@NonNull String xprv, @NonNull Number childIndex, @NonNull Boolean hardened) {
            if (xprv == null) {
                throw new NullPointerException("xprv is marked non-null but is null");
            }
            if (childIndex == null) {
                throw new NullPointerException("childIndex is marked non-null but is null");
            }
            if (hardened == null) {
                throw new NullPointerException("hardened is marked non-null but is null");
            }
            this.xprv = xprv;
            this.childIndex = childIndex;
            this.hardened = hardened;
        }

        @NonNull
        @Generated
        public String xprv() {
            return this.xprv;
        }

        @NonNull
        @Generated
        public Number childIndex() {
            return this.childIndex;
        }

        @NonNull
        @Generated
        public Boolean hardened() {
            return this.hardened;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfHDKeyDeriveFromXPrv)) {
                return false;
            }
            ParamsOfHDKeyDeriveFromXPrv other = (ParamsOfHDKeyDeriveFromXPrv)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$hardened = this.hardened();
            Boolean other$hardened = other.hardened();
            if (this$hardened == null ? other$hardened != null : !((Object)this$hardened).equals(other$hardened)) {
                return false;
            }
            String this$xprv = this.xprv();
            String other$xprv = other.xprv();
            if (this$xprv == null ? other$xprv != null : !this$xprv.equals(other$xprv)) {
                return false;
            }
            Number this$childIndex = this.childIndex();
            Number other$childIndex = other.childIndex();
            return !(this$childIndex == null ? other$childIndex != null : !this$childIndex.equals(other$childIndex));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfHDKeyDeriveFromXPrv;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $hardened = this.hardened();
            result = result * 59 + ($hardened == null ? 43 : ((Object)$hardened).hashCode());
            String $xprv = this.xprv();
            result = result * 59 + ($xprv == null ? 43 : $xprv.hashCode());
            Number $childIndex = this.childIndex();
            result = result * 59 + ($childIndex == null ? 43 : $childIndex.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfHDKeyDeriveFromXPrv(xprv=" + this.xprv() + ", childIndex=" + this.childIndex() + ", hardened=" + this.hardened() + ")";
        }
    }

    public static final class ResultOfHDKeyDeriveFromXPrv
    extends JsonData {
        @SerializedName(value="xprv")
        @NonNull
        private final String xprv;

        @Generated
        public ResultOfHDKeyDeriveFromXPrv(@NonNull String xprv) {
            if (xprv == null) {
                throw new NullPointerException("xprv is marked non-null but is null");
            }
            this.xprv = xprv;
        }

        @NonNull
        @Generated
        public String xprv() {
            return this.xprv;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfHDKeyDeriveFromXPrv)) {
                return false;
            }
            ResultOfHDKeyDeriveFromXPrv other = (ResultOfHDKeyDeriveFromXPrv)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$xprv = this.xprv();
            String other$xprv = other.xprv();
            return !(this$xprv == null ? other$xprv != null : !this$xprv.equals(other$xprv));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfHDKeyDeriveFromXPrv;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $xprv = this.xprv();
            result = result * 59 + ($xprv == null ? 43 : $xprv.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfHDKeyDeriveFromXPrv(xprv=" + this.xprv() + ")";
        }
    }

    public static final class ParamsOfHDKeyDeriveFromXPrvPath
    extends JsonData {
        @SerializedName(value="xprv")
        @NonNull
        private final String xprv;
        @SerializedName(value="path")
        @NonNull
        private final String path;

        @Generated
        public ParamsOfHDKeyDeriveFromXPrvPath(@NonNull String xprv, @NonNull String path) {
            if (xprv == null) {
                throw new NullPointerException("xprv is marked non-null but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.xprv = xprv;
            this.path = path;
        }

        @NonNull
        @Generated
        public String xprv() {
            return this.xprv;
        }

        @NonNull
        @Generated
        public String path() {
            return this.path;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfHDKeyDeriveFromXPrvPath)) {
                return false;
            }
            ParamsOfHDKeyDeriveFromXPrvPath other = (ParamsOfHDKeyDeriveFromXPrvPath)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$xprv = this.xprv();
            String other$xprv = other.xprv();
            if (this$xprv == null ? other$xprv != null : !this$xprv.equals(other$xprv)) {
                return false;
            }
            String this$path = this.path();
            String other$path = other.path();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfHDKeyDeriveFromXPrvPath;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $xprv = this.xprv();
            result = result * 59 + ($xprv == null ? 43 : $xprv.hashCode());
            String $path = this.path();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfHDKeyDeriveFromXPrvPath(xprv=" + this.xprv() + ", path=" + this.path() + ")";
        }
    }

    public static final class ResultOfHDKeyDeriveFromXPrvPath
    extends JsonData {
        @SerializedName(value="xprv")
        @NonNull
        private final String xprv;

        @Generated
        public ResultOfHDKeyDeriveFromXPrvPath(@NonNull String xprv) {
            if (xprv == null) {
                throw new NullPointerException("xprv is marked non-null but is null");
            }
            this.xprv = xprv;
        }

        @NonNull
        @Generated
        public String xprv() {
            return this.xprv;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfHDKeyDeriveFromXPrvPath)) {
                return false;
            }
            ResultOfHDKeyDeriveFromXPrvPath other = (ResultOfHDKeyDeriveFromXPrvPath)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$xprv = this.xprv();
            String other$xprv = other.xprv();
            return !(this$xprv == null ? other$xprv != null : !this$xprv.equals(other$xprv));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfHDKeyDeriveFromXPrvPath;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $xprv = this.xprv();
            result = result * 59 + ($xprv == null ? 43 : $xprv.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfHDKeyDeriveFromXPrvPath(xprv=" + this.xprv() + ")";
        }
    }

    public static final class ParamsOfHDKeySecretFromXPrv
    extends JsonData {
        @SerializedName(value="xprv")
        @NonNull
        private final String xprv;

        @Generated
        public ParamsOfHDKeySecretFromXPrv(@NonNull String xprv) {
            if (xprv == null) {
                throw new NullPointerException("xprv is marked non-null but is null");
            }
            this.xprv = xprv;
        }

        @NonNull
        @Generated
        public String xprv() {
            return this.xprv;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfHDKeySecretFromXPrv)) {
                return false;
            }
            ParamsOfHDKeySecretFromXPrv other = (ParamsOfHDKeySecretFromXPrv)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$xprv = this.xprv();
            String other$xprv = other.xprv();
            return !(this$xprv == null ? other$xprv != null : !this$xprv.equals(other$xprv));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfHDKeySecretFromXPrv;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $xprv = this.xprv();
            result = result * 59 + ($xprv == null ? 43 : $xprv.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfHDKeySecretFromXPrv(xprv=" + this.xprv() + ")";
        }
    }

    public static final class ResultOfHDKeySecretFromXPrv
    extends JsonData {
        @SerializedName(value="secret")
        @NonNull
        private final String secretKey;

        @Generated
        public ResultOfHDKeySecretFromXPrv(@NonNull String secretKey) {
            if (secretKey == null) {
                throw new NullPointerException("secretKey is marked non-null but is null");
            }
            this.secretKey = secretKey;
        }

        @NonNull
        @Generated
        public String secretKey() {
            return this.secretKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfHDKeySecretFromXPrv)) {
                return false;
            }
            ResultOfHDKeySecretFromXPrv other = (ResultOfHDKeySecretFromXPrv)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$secretKey = this.secretKey();
            String other$secretKey = other.secretKey();
            return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfHDKeySecretFromXPrv;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $secretKey = this.secretKey();
            result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfHDKeySecretFromXPrv(secretKey=" + this.secretKey() + ")";
        }
    }

    public static final class ParamsOfHDKeyPublicFromXPrv
    extends JsonData {
        @SerializedName(value="xprv")
        @NonNull
        private final String xprv;

        @Generated
        public ParamsOfHDKeyPublicFromXPrv(@NonNull String xprv) {
            if (xprv == null) {
                throw new NullPointerException("xprv is marked non-null but is null");
            }
            this.xprv = xprv;
        }

        @NonNull
        @Generated
        public String xprv() {
            return this.xprv;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfHDKeyPublicFromXPrv)) {
                return false;
            }
            ParamsOfHDKeyPublicFromXPrv other = (ParamsOfHDKeyPublicFromXPrv)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$xprv = this.xprv();
            String other$xprv = other.xprv();
            return !(this$xprv == null ? other$xprv != null : !this$xprv.equals(other$xprv));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfHDKeyPublicFromXPrv;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $xprv = this.xprv();
            result = result * 59 + ($xprv == null ? 43 : $xprv.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfHDKeyPublicFromXPrv(xprv=" + this.xprv() + ")";
        }
    }

    public static final class ResultOfHDKeyPublicFromXPrv
    extends JsonData {
        @SerializedName(value="public")
        @NonNull
        private final String publicKey;

        @Generated
        public ResultOfHDKeyPublicFromXPrv(@NonNull String publicKey) {
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            this.publicKey = publicKey;
        }

        @NonNull
        @Generated
        public String publicKey() {
            return this.publicKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfHDKeyPublicFromXPrv)) {
                return false;
            }
            ResultOfHDKeyPublicFromXPrv other = (ResultOfHDKeyPublicFromXPrv)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$publicKey = this.publicKey();
            String other$publicKey = other.publicKey();
            return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfHDKeyPublicFromXPrv;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $publicKey = this.publicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfHDKeyPublicFromXPrv(publicKey=" + this.publicKey() + ")";
        }
    }

    public static final class ParamsOfChaCha20
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final String data;
        @SerializedName(value="key")
        @NonNull
        private final String key;
        @SerializedName(value="nonce")
        @NonNull
        private final String nonce;

        @Generated
        public ParamsOfChaCha20(@NonNull String data, @NonNull String key, @NonNull String nonce) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (nonce == null) {
                throw new NullPointerException("nonce is marked non-null but is null");
            }
            this.data = data;
            this.key = key;
            this.nonce = nonce;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @NonNull
        @Generated
        public String key() {
            return this.key;
        }

        @NonNull
        @Generated
        public String nonce() {
            return this.nonce;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfChaCha20)) {
                return false;
            }
            ParamsOfChaCha20 other = (ParamsOfChaCha20)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$key = this.key();
            String other$key = other.key();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$nonce = this.nonce();
            String other$nonce = other.nonce();
            return !(this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfChaCha20;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $key = this.key();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $nonce = this.nonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfChaCha20(data=" + this.data() + ", key=" + this.key() + ", nonce=" + this.nonce() + ")";
        }
    }

    public static final class ResultOfChaCha20
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ResultOfChaCha20(@NonNull String data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfChaCha20)) {
                return false;
            }
            ResultOfChaCha20 other = (ResultOfChaCha20)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfChaCha20;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfChaCha20(data=" + this.data() + ")";
        }
    }

    public static final class RegisteredSigningBox
    extends JsonData {
        @SerializedName(value="handle")
        @NonNull
        private final Integer handle;

        @Generated
        public RegisteredSigningBox(@NonNull Integer handle) {
            if (handle == null) {
                throw new NullPointerException("handle is marked non-null but is null");
            }
            this.handle = handle;
        }

        @NonNull
        @Generated
        public Integer handle() {
            return this.handle;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegisteredSigningBox)) {
                return false;
            }
            RegisteredSigningBox other = (RegisteredSigningBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$handle = this.handle();
            Integer other$handle = other.handle();
            return !(this$handle == null ? other$handle != null : !((Object)this$handle).equals(other$handle));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RegisteredSigningBox;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $handle = this.handle();
            result = result * 59 + ($handle == null ? 43 : ((Object)$handle).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.RegisteredSigningBox(handle=" + this.handle() + ")";
        }
    }

    public static final class ResultOfSigningBoxGetPublicKey
    extends JsonData {
        @SerializedName(value="pubkey")
        @NonNull
        private final String pubkey;

        @Generated
        public ResultOfSigningBoxGetPublicKey(@NonNull String pubkey) {
            if (pubkey == null) {
                throw new NullPointerException("pubkey is marked non-null but is null");
            }
            this.pubkey = pubkey;
        }

        @NonNull
        @Generated
        public String pubkey() {
            return this.pubkey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfSigningBoxGetPublicKey)) {
                return false;
            }
            ResultOfSigningBoxGetPublicKey other = (ResultOfSigningBoxGetPublicKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$pubkey = this.pubkey();
            String other$pubkey = other.pubkey();
            return !(this$pubkey == null ? other$pubkey != null : !this$pubkey.equals(other$pubkey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfSigningBoxGetPublicKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $pubkey = this.pubkey();
            result = result * 59 + ($pubkey == null ? 43 : $pubkey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfSigningBoxGetPublicKey(pubkey=" + this.pubkey() + ")";
        }
    }

    public static final class ParamsOfSigningBoxSign
    extends JsonData {
        @SerializedName(value="signing_box")
        @NonNull
        private final Integer signingBox;
        @SerializedName(value="unsigned")
        @NonNull
        private final String unsigned;

        @Generated
        public ParamsOfSigningBoxSign(@NonNull Integer signingBox, @NonNull String unsigned) {
            if (signingBox == null) {
                throw new NullPointerException("signingBox is marked non-null but is null");
            }
            if (unsigned == null) {
                throw new NullPointerException("unsigned is marked non-null but is null");
            }
            this.signingBox = signingBox;
            this.unsigned = unsigned;
        }

        @NonNull
        @Generated
        public Integer signingBox() {
            return this.signingBox;
        }

        @NonNull
        @Generated
        public String unsigned() {
            return this.unsigned;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfSigningBoxSign)) {
                return false;
            }
            ParamsOfSigningBoxSign other = (ParamsOfSigningBoxSign)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$signingBox = this.signingBox();
            Integer other$signingBox = other.signingBox();
            if (this$signingBox == null ? other$signingBox != null : !((Object)this$signingBox).equals(other$signingBox)) {
                return false;
            }
            String this$unsigned = this.unsigned();
            String other$unsigned = other.unsigned();
            return !(this$unsigned == null ? other$unsigned != null : !this$unsigned.equals(other$unsigned));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfSigningBoxSign;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $signingBox = this.signingBox();
            result = result * 59 + ($signingBox == null ? 43 : ((Object)$signingBox).hashCode());
            String $unsigned = this.unsigned();
            result = result * 59 + ($unsigned == null ? 43 : $unsigned.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfSigningBoxSign(signingBox=" + this.signingBox() + ", unsigned=" + this.unsigned() + ")";
        }
    }

    public static final class ResultOfSigningBoxSign
    extends JsonData {
        @SerializedName(value="signature")
        @NonNull
        private final String signature;

        @Generated
        public ResultOfSigningBoxSign(@NonNull String signature) {
            if (signature == null) {
                throw new NullPointerException("signature is marked non-null but is null");
            }
            this.signature = signature;
        }

        @NonNull
        @Generated
        public String signature() {
            return this.signature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfSigningBoxSign)) {
                return false;
            }
            ResultOfSigningBoxSign other = (ResultOfSigningBoxSign)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$signature = this.signature();
            String other$signature = other.signature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfSigningBoxSign;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $signature = this.signature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfSigningBoxSign(signature=" + this.signature() + ")";
        }
    }

    public static final class RegisteredEncryptionBox
    extends JsonData {
        @SerializedName(value="handle")
        @NonNull
        private final Integer handle;

        @Generated
        public RegisteredEncryptionBox(@NonNull Integer handle) {
            if (handle == null) {
                throw new NullPointerException("handle is marked non-null but is null");
            }
            this.handle = handle;
        }

        @NonNull
        @Generated
        public Integer handle() {
            return this.handle;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegisteredEncryptionBox)) {
                return false;
            }
            RegisteredEncryptionBox other = (RegisteredEncryptionBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$handle = this.handle();
            Integer other$handle = other.handle();
            return !(this$handle == null ? other$handle != null : !((Object)this$handle).equals(other$handle));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RegisteredEncryptionBox;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $handle = this.handle();
            result = result * 59 + ($handle == null ? 43 : ((Object)$handle).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.RegisteredEncryptionBox(handle=" + this.handle() + ")";
        }
    }

    public static final class ParamsOfEncryptionBoxGetInfo
    extends JsonData {
        @SerializedName(value="encryption_box")
        @NonNull
        private final Integer encryptionBox;

        @Generated
        public ParamsOfEncryptionBoxGetInfo(@NonNull Integer encryptionBox) {
            if (encryptionBox == null) {
                throw new NullPointerException("encryptionBox is marked non-null but is null");
            }
            this.encryptionBox = encryptionBox;
        }

        @NonNull
        @Generated
        public Integer encryptionBox() {
            return this.encryptionBox;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfEncryptionBoxGetInfo)) {
                return false;
            }
            ParamsOfEncryptionBoxGetInfo other = (ParamsOfEncryptionBoxGetInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$encryptionBox = this.encryptionBox();
            Integer other$encryptionBox = other.encryptionBox();
            return !(this$encryptionBox == null ? other$encryptionBox != null : !((Object)this$encryptionBox).equals(other$encryptionBox));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfEncryptionBoxGetInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $encryptionBox = this.encryptionBox();
            result = result * 59 + ($encryptionBox == null ? 43 : ((Object)$encryptionBox).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfEncryptionBoxGetInfo(encryptionBox=" + this.encryptionBox() + ")";
        }
    }

    public static final class ResultOfEncryptionBoxGetInfo
    extends JsonData {
        @SerializedName(value="info")
        @NonNull
        private final EncryptionBoxInfo info;

        @Generated
        public ResultOfEncryptionBoxGetInfo(@NonNull EncryptionBoxInfo info) {
            if (info == null) {
                throw new NullPointerException("info is marked non-null but is null");
            }
            this.info = info;
        }

        @NonNull
        @Generated
        public EncryptionBoxInfo info() {
            return this.info;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfEncryptionBoxGetInfo)) {
                return false;
            }
            ResultOfEncryptionBoxGetInfo other = (ResultOfEncryptionBoxGetInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EncryptionBoxInfo this$info = this.info();
            EncryptionBoxInfo other$info = other.info();
            return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfEncryptionBoxGetInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            EncryptionBoxInfo $info = this.info();
            result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfEncryptionBoxGetInfo(info=" + this.info() + ")";
        }
    }

    public static final class ParamsOfEncryptionBoxEncrypt
    extends JsonData {
        @SerializedName(value="encryption_box")
        @NonNull
        private final Integer encryptionBox;
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ParamsOfEncryptionBoxEncrypt(@NonNull Integer encryptionBox, @NonNull String data) {
            if (encryptionBox == null) {
                throw new NullPointerException("encryptionBox is marked non-null but is null");
            }
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.encryptionBox = encryptionBox;
            this.data = data;
        }

        @NonNull
        @Generated
        public Integer encryptionBox() {
            return this.encryptionBox;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfEncryptionBoxEncrypt)) {
                return false;
            }
            ParamsOfEncryptionBoxEncrypt other = (ParamsOfEncryptionBoxEncrypt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$encryptionBox = this.encryptionBox();
            Integer other$encryptionBox = other.encryptionBox();
            if (this$encryptionBox == null ? other$encryptionBox != null : !((Object)this$encryptionBox).equals(other$encryptionBox)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfEncryptionBoxEncrypt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $encryptionBox = this.encryptionBox();
            result = result * 59 + ($encryptionBox == null ? 43 : ((Object)$encryptionBox).hashCode());
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfEncryptionBoxEncrypt(encryptionBox=" + this.encryptionBox() + ", data=" + this.data() + ")";
        }
    }

    public static final class ResultOfEncryptionBoxEncrypt
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ResultOfEncryptionBoxEncrypt(@NonNull String data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfEncryptionBoxEncrypt)) {
                return false;
            }
            ResultOfEncryptionBoxEncrypt other = (ResultOfEncryptionBoxEncrypt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfEncryptionBoxEncrypt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfEncryptionBoxEncrypt(data=" + this.data() + ")";
        }
    }

    public static final class ParamsOfEncryptionBoxDecrypt
    extends JsonData {
        @SerializedName(value="encryption_box")
        @NonNull
        private final Integer encryptionBox;
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ParamsOfEncryptionBoxDecrypt(@NonNull Integer encryptionBox, @NonNull String data) {
            if (encryptionBox == null) {
                throw new NullPointerException("encryptionBox is marked non-null but is null");
            }
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.encryptionBox = encryptionBox;
            this.data = data;
        }

        @NonNull
        @Generated
        public Integer encryptionBox() {
            return this.encryptionBox;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfEncryptionBoxDecrypt)) {
                return false;
            }
            ParamsOfEncryptionBoxDecrypt other = (ParamsOfEncryptionBoxDecrypt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$encryptionBox = this.encryptionBox();
            Integer other$encryptionBox = other.encryptionBox();
            if (this$encryptionBox == null ? other$encryptionBox != null : !((Object)this$encryptionBox).equals(other$encryptionBox)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfEncryptionBoxDecrypt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $encryptionBox = this.encryptionBox();
            result = result * 59 + ($encryptionBox == null ? 43 : ((Object)$encryptionBox).hashCode());
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfEncryptionBoxDecrypt(encryptionBox=" + this.encryptionBox() + ", data=" + this.data() + ")";
        }
    }

    public static final class ResultOfEncryptionBoxDecrypt
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ResultOfEncryptionBoxDecrypt(@NonNull String data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfEncryptionBoxDecrypt)) {
                return false;
            }
            ResultOfEncryptionBoxDecrypt other = (ResultOfEncryptionBoxDecrypt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfEncryptionBoxDecrypt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ResultOfEncryptionBoxDecrypt(data=" + this.data() + ")";
        }
    }

    public static final class ParamsOfCreateEncryptionBox
    extends JsonData {
        @SerializedName(value="algorithm")
        @NonNull
        private final EncryptionAlgorithm algorithm;

        @Generated
        public ParamsOfCreateEncryptionBox(@NonNull EncryptionAlgorithm algorithm) {
            if (algorithm == null) {
                throw new NullPointerException("algorithm is marked non-null but is null");
            }
            this.algorithm = algorithm;
        }

        @NonNull
        @Generated
        public EncryptionAlgorithm algorithm() {
            return this.algorithm;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfCreateEncryptionBox)) {
                return false;
            }
            ParamsOfCreateEncryptionBox other = (ParamsOfCreateEncryptionBox)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EncryptionAlgorithm this$algorithm = this.algorithm();
            EncryptionAlgorithm other$algorithm = other.algorithm();
            return !(this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfCreateEncryptionBox;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            EncryptionAlgorithm $algorithm = this.algorithm();
            result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.ParamsOfCreateEncryptionBox(algorithm=" + this.algorithm() + ")";
        }
    }

    public static abstract class EncryptionAlgorithm {

        public static final class AES
        extends EncryptionAlgorithm {
            @SerializedName(value="mode")
            @NonNull
            private final Map<String, Object> mode;
            @SerializedName(value="key")
            @NonNull
            private final String key;
            @SerializedName(value="iv")
            private final String iv;

            public Optional<String> iv() {
                return Optional.ofNullable(this.iv);
            }

            @Generated
            public AES(@NonNull Map<String, Object> mode, @NonNull String key, String iv) {
                if (mode == null) {
                    throw new NullPointerException("mode is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                this.mode = mode;
                this.key = key;
                this.iv = iv;
            }

            @NonNull
            @Generated
            public Map<String, Object> mode() {
                return this.mode;
            }

            @NonNull
            @Generated
            public String key() {
                return this.key;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AES)) {
                    return false;
                }
                AES other = (AES)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Map<String, Object> this$mode = this.mode();
                Map<String, Object> other$mode = other.mode();
                if (this$mode == null ? other$mode != null : !((Object)this$mode).equals(other$mode)) {
                    return false;
                }
                String this$key = this.key();
                String other$key = other.key();
                if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                    return false;
                }
                Optional<String> this$iv = this.iv();
                Optional<String> other$iv = other.iv();
                return !(this$iv == null ? other$iv != null : !((Object)this$iv).equals(other$iv));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AES;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                Map<String, Object> $mode = this.mode();
                result = result * 59 + ($mode == null ? 43 : ((Object)$mode).hashCode());
                String $key = this.key();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                Optional<String> $iv = this.iv();
                result = result * 59 + ($iv == null ? 43 : ((Object)$iv).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.EncryptionAlgorithm.AES(mode=" + this.mode() + ", key=" + this.key() + ", iv=" + this.iv() + ")";
            }
        }
    }

    public static abstract class ResultOfAppEncryptionBox {

        public static final class Decrypt
        extends ResultOfAppEncryptionBox {
            @SerializedName(value="data")
            @NonNull
            private final String data;

            @Generated
            public Decrypt(@NonNull String data) {
                if (data == null) {
                    throw new NullPointerException("data is marked non-null but is null");
                }
                this.data = data;
            }

            @NonNull
            @Generated
            public String data() {
                return this.data;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Decrypt)) {
                    return false;
                }
                Decrypt other = (Decrypt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$data = this.data();
                String other$data = other.data();
                return !(this$data == null ? other$data != null : !this$data.equals(other$data));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Decrypt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $data = this.data();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ResultOfAppEncryptionBox.Decrypt(data=" + this.data() + ")";
            }
        }

        public static final class Encrypt
        extends ResultOfAppEncryptionBox {
            @SerializedName(value="data")
            @NonNull
            private final String data;

            @Generated
            public Encrypt(@NonNull String data) {
                if (data == null) {
                    throw new NullPointerException("data is marked non-null but is null");
                }
                this.data = data;
            }

            @NonNull
            @Generated
            public String data() {
                return this.data;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Encrypt)) {
                    return false;
                }
                Encrypt other = (Encrypt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$data = this.data();
                String other$data = other.data();
                return !(this$data == null ? other$data != null : !this$data.equals(other$data));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Encrypt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $data = this.data();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ResultOfAppEncryptionBox.Encrypt(data=" + this.data() + ")";
            }
        }

        public static final class GetInfo
        extends ResultOfAppEncryptionBox {
            @SerializedName(value="info")
            @NonNull
            private final EncryptionBoxInfo info;

            @Generated
            public GetInfo(@NonNull EncryptionBoxInfo info) {
                if (info == null) {
                    throw new NullPointerException("info is marked non-null but is null");
                }
                this.info = info;
            }

            @NonNull
            @Generated
            public EncryptionBoxInfo info() {
                return this.info;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GetInfo)) {
                    return false;
                }
                GetInfo other = (GetInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                EncryptionBoxInfo this$info = this.info();
                EncryptionBoxInfo other$info = other.info();
                return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GetInfo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                EncryptionBoxInfo $info = this.info();
                result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ResultOfAppEncryptionBox.GetInfo(info=" + this.info() + ")";
            }
        }
    }

    public static abstract class ParamsOfAppEncryptionBox {
        public static final GetInfo GetInfo = new GetInfo();

        public static final class GetInfo
        extends ParamsOfAppEncryptionBox {
            @Generated
            public GetInfo() {
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GetInfo)) {
                    return false;
                }
                GetInfo other = (GetInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return super.equals(o);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GetInfo;
            }

            @Generated
            public int hashCode() {
                int result = super.hashCode();
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ParamsOfAppEncryptionBox.GetInfo()";
            }
        }

        public static final class Decrypt
        extends ParamsOfAppEncryptionBox {
            @SerializedName(value="data")
            @NonNull
            private final String data;

            @Generated
            public Decrypt(@NonNull String data) {
                if (data == null) {
                    throw new NullPointerException("data is marked non-null but is null");
                }
                this.data = data;
            }

            @NonNull
            @Generated
            public String data() {
                return this.data;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Decrypt)) {
                    return false;
                }
                Decrypt other = (Decrypt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$data = this.data();
                String other$data = other.data();
                return !(this$data == null ? other$data != null : !this$data.equals(other$data));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Decrypt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $data = this.data();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ParamsOfAppEncryptionBox.Decrypt(data=" + this.data() + ")";
            }
        }

        public static final class Encrypt
        extends ParamsOfAppEncryptionBox {
            @SerializedName(value="data")
            @NonNull
            private final String data;

            @Generated
            public Encrypt(@NonNull String data) {
                if (data == null) {
                    throw new NullPointerException("data is marked non-null but is null");
                }
                this.data = data;
            }

            @NonNull
            @Generated
            public String data() {
                return this.data;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Encrypt)) {
                    return false;
                }
                Encrypt other = (Encrypt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$data = this.data();
                String other$data = other.data();
                return !(this$data == null ? other$data != null : !this$data.equals(other$data));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Encrypt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $data = this.data();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ParamsOfAppEncryptionBox.Encrypt(data=" + this.data() + ")";
            }
        }
    }

    public static abstract class ResultOfAppSigningBox {

        public static final class Sign
        extends ResultOfAppSigningBox {
            @SerializedName(value="signature")
            @NonNull
            private final String signature;

            @Generated
            public Sign(@NonNull String signature) {
                if (signature == null) {
                    throw new NullPointerException("signature is marked non-null but is null");
                }
                this.signature = signature;
            }

            @NonNull
            @Generated
            public String signature() {
                return this.signature;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sign)) {
                    return false;
                }
                Sign other = (Sign)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$signature = this.signature();
                String other$signature = other.signature();
                return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sign;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $signature = this.signature();
                result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ResultOfAppSigningBox.Sign(signature=" + this.signature() + ")";
            }
        }

        public static final class GetPublicKey
        extends ResultOfAppSigningBox {
            @SerializedName(value="public_key")
            @NonNull
            private final String publicKey;

            @Generated
            public GetPublicKey(@NonNull String publicKey) {
                if (publicKey == null) {
                    throw new NullPointerException("publicKey is marked non-null but is null");
                }
                this.publicKey = publicKey;
            }

            @NonNull
            @Generated
            public String publicKey() {
                return this.publicKey;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GetPublicKey)) {
                    return false;
                }
                GetPublicKey other = (GetPublicKey)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$publicKey = this.publicKey();
                String other$publicKey = other.publicKey();
                return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GetPublicKey;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $publicKey = this.publicKey();
                result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ResultOfAppSigningBox.GetPublicKey(publicKey=" + this.publicKey() + ")";
            }
        }
    }

    public static abstract class ParamsOfAppSigningBox {
        public static final GetPublicKey GetPublicKey = new GetPublicKey();

        public static final class GetPublicKey
        extends ParamsOfAppSigningBox {
            @Generated
            public GetPublicKey() {
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GetPublicKey)) {
                    return false;
                }
                GetPublicKey other = (GetPublicKey)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return super.equals(o);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GetPublicKey;
            }

            @Generated
            public int hashCode() {
                int result = super.hashCode();
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ParamsOfAppSigningBox.GetPublicKey()";
            }
        }

        public static final class Sign
        extends ParamsOfAppSigningBox {
            @SerializedName(value="unsigned")
            @NonNull
            private final String unsigned;

            @Generated
            public Sign(@NonNull String unsigned) {
                if (unsigned == null) {
                    throw new NullPointerException("unsigned is marked non-null but is null");
                }
                this.unsigned = unsigned;
            }

            @NonNull
            @Generated
            public String unsigned() {
                return this.unsigned;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sign)) {
                    return false;
                }
                Sign other = (Sign)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$unsigned = this.unsigned();
                String other$unsigned = other.unsigned();
                return !(this$unsigned == null ? other$unsigned != null : !this$unsigned.equals(other$unsigned));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sign;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $unsigned = this.unsigned();
                result = result * 59 + ($unsigned == null ? 43 : $unsigned.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Crypto.ParamsOfAppSigningBox.Sign(unsigned=" + this.unsigned() + ")";
            }
        }
    }

    public static final class EncryptionBoxInfo
    extends JsonData {
        @SerializedName(value="hdpath")
        private final String hdpath;
        @SerializedName(value="algorithm")
        private final String algorithm;
        @SerializedName(value="options")
        private final Map<String, Object> options;
        @SerializedName(value="public")
        private final Map<String, Object> publicKey;

        public Optional<String> hdpath() {
            return Optional.ofNullable(this.hdpath);
        }

        public Optional<String> algorithm() {
            return Optional.ofNullable(this.algorithm);
        }

        public Optional<Map<String, Object>> options() {
            return Optional.ofNullable(this.options);
        }

        public Optional<Map<String, Object>> publicKey() {
            return Optional.ofNullable(this.publicKey);
        }

        @Generated
        public EncryptionBoxInfo(String hdpath, String algorithm, Map<String, Object> options, Map<String, Object> publicKey) {
            this.hdpath = hdpath;
            this.algorithm = algorithm;
            this.options = options;
            this.publicKey = publicKey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EncryptionBoxInfo)) {
                return false;
            }
            EncryptionBoxInfo other = (EncryptionBoxInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<String> this$hdpath = this.hdpath();
            Optional<String> other$hdpath = other.hdpath();
            if (this$hdpath == null ? other$hdpath != null : !((Object)this$hdpath).equals(other$hdpath)) {
                return false;
            }
            Optional<String> this$algorithm = this.algorithm();
            Optional<String> other$algorithm = other.algorithm();
            if (this$algorithm == null ? other$algorithm != null : !((Object)this$algorithm).equals(other$algorithm)) {
                return false;
            }
            Optional<Map<String, Object>> this$options = this.options();
            Optional<Map<String, Object>> other$options = other.options();
            if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
                return false;
            }
            Optional<Map<String, Object>> this$publicKey = this.publicKey();
            Optional<Map<String, Object>> other$publicKey = other.publicKey();
            return !(this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EncryptionBoxInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<String> $hdpath = this.hdpath();
            result = result * 59 + ($hdpath == null ? 43 : ((Object)$hdpath).hashCode());
            Optional<String> $algorithm = this.algorithm();
            result = result * 59 + ($algorithm == null ? 43 : ((Object)$algorithm).hashCode());
            Optional<Map<String, Object>> $options = this.options();
            result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
            Optional<Map<String, Object>> $publicKey = this.publicKey();
            result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Crypto.EncryptionBoxInfo(hdpath=" + this.hdpath() + ", algorithm=" + this.algorithm() + ", options=" + this.options() + ", publicKey=" + this.publicKey() + ")";
        }
    }
}

