/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.CommaSeparatedCodes;
import tech.carpentum.sdk.payment.internal.api.EnhancedPaymentsApi;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.CurrencyList;
import tech.carpentum.sdk.payment.model.PaymentMethodCode;
import tech.carpentum.sdk.payment.model.PaymentMethodsList;
import tech.carpentum.sdk.payment.model.PaymentOperatorList;
import tech.carpentum.sdk.payment.model.PaymentOptionsList;
import tech.carpentum.sdk.payment.model.PaymentTypeCode;
import tech.carpentum.sdk.payment.model.SegmentList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0011H\u0007J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedPaymentsApi;", "(Ljava/lang/String;Ltech/carpentum/sdk/payment/internal/api/EnhancedPaymentsApi;)V", "listCurrencies", "Ltech/carpentum/sdk/payment/model/CurrencyList;", "listPaymentMethods", "Ltech/carpentum/sdk/payment/model/PaymentMethodsList;", "listPaymentOperators", "Ltech/carpentum/sdk/payment/model/PaymentOperatorList;", "listPaymentOptions", "Ltech/carpentum/sdk/payment/model/PaymentOptionsList;", "query", "Ljava/util/function/Supplier;", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "listSegments", "Ltech/carpentum/sdk/payment/model/SegmentList;", "Factory", "ListPaymentOptionsBusinessValidationErrorCode", "ListPaymentOptionsQuery", "payment-client-v2"})
public final class PaymentsApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final String apiVersion;
    @NotNull
    private final EnhancedPaymentsApi api;

    private PaymentsApi(String apiVersion, EnhancedPaymentsApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @NotNull
    public final CurrencyList listCurrencies() throws ResponseException {
        return (CurrencyList)ResponseExceptionUtils.INSTANCE.wrap((Function0)new Function0<CurrencyList>(this){
            final /* synthetic */ PaymentsApi this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CurrencyList invoke() {
                return PaymentsApi.access$getApi$p(this.this$0).getCurrencies(PaymentsApi.access$getApiVersion$p(this.this$0));
            }
        });
    }

    @NotNull
    public final SegmentList listSegments() throws ResponseException {
        return (SegmentList)ResponseExceptionUtils.INSTANCE.wrap((Function0)new Function0<SegmentList>(this){
            final /* synthetic */ PaymentsApi this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SegmentList invoke() {
                return PaymentsApi.access$getApi$p(this.this$0).getSegments(PaymentsApi.access$getApiVersion$p(this.this$0));
            }
        });
    }

    @NotNull
    public final PaymentOperatorList listPaymentOperators() throws ResponseException {
        return (PaymentOperatorList)ResponseExceptionUtils.INSTANCE.wrap((Function0)new Function0<PaymentOperatorList>(this){
            final /* synthetic */ PaymentsApi this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PaymentOperatorList invoke() {
                return PaymentsApi.access$getApi$p(this.this$0).getPaymentOperators(PaymentsApi.access$getApiVersion$p(this.this$0));
            }
        });
    }

    @NotNull
    public final PaymentMethodsList listPaymentMethods() throws ResponseException {
        return (PaymentMethodsList)ResponseExceptionUtils.INSTANCE.wrap((Function0)new Function0<PaymentMethodsList>(this){
            final /* synthetic */ PaymentsApi this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PaymentMethodsList invoke() {
                return PaymentsApi.access$getApi$p(this.this$0).getPaymentMethods(PaymentsApi.access$getApiVersion$p(this.this$0));
            }
        });
    }

    @JvmOverloads
    @NotNull
    public final PaymentOptionsList listPaymentOptions(@NotNull ListPaymentOptionsQuery query) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return (PaymentOptionsList)ResponseExceptionUtils.INSTANCE.wrap((Function0)new Function0<PaymentOptionsList>(this, query){
            final /* synthetic */ PaymentsApi this$0;
            final /* synthetic */ ListPaymentOptionsQuery $query;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                super(0);
            }

            @NotNull
            public final PaymentOptionsList invoke() {
                return PaymentsApi.access$getApi$p(this.this$0).getPaymentOptions(PaymentsApi.access$getApiVersion$p(this.this$0), this.$query.getPaymentTypeCode(), CommaSeparatedCodes.INSTANCE.format(this.$query.getPaymentMethodCodes()), CommaSeparatedCodes.INSTANCE.format(this.$query.getCurrencyCodes()), CommaSeparatedCodes.INSTANCE.format(this.$query.getSegmentCodes()), CommaSeparatedCodes.INSTANCE.format(this.$query.getPaymentOperatorCodes()));
            }
        });
    }

    public static /* synthetic */ PaymentOptionsList listPaymentOptions$default(PaymentsApi paymentsApi, ListPaymentOptionsQuery listPaymentOptionsQuery, int n, Object object) throws ResponseException {
        if ((n & 1) != 0) {
            listPaymentOptionsQuery = ListPaymentOptionsQuery.Factory.any();
        }
        return paymentsApi.listPaymentOptions(listPaymentOptionsQuery);
    }

    @NotNull
    public final PaymentOptionsList listPaymentOptions(@NotNull Supplier<ListPaymentOptionsQuery> query) throws ResponseException {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        ListPaymentOptionsQuery listPaymentOptionsQuery = query.get();
        Intrinsics.checkNotNullExpressionValue((Object)listPaymentOptionsQuery, (String)"query.get()");
        return this.listPaymentOptions(listPaymentOptionsQuery);
    }

    @JvmOverloads
    @NotNull
    public final PaymentOptionsList listPaymentOptions() throws ResponseException {
        return PaymentsApi.listPaymentOptions$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListCurrenciesEndpoint() {
        return Factory.defineListCurrenciesEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListPaymentMethodsEndpoint() {
        return Factory.defineListPaymentMethodsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListPaymentOperatorsEndpoint() {
        return Factory.defineListPaymentOperatorsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListPaymentOptionsEndpoint() {
        return Factory.defineListPaymentOptionsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineListSegmentsEndpoint() {
        return Factory.defineListSegmentsEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public static final /* synthetic */ EnhancedPaymentsApi access$getApi$p(PaymentsApi $this) {
        return $this.api;
    }

    public static final /* synthetic */ String access$getApiVersion$p(PaymentsApi $this) {
        return $this.apiVersion;
    }

    public /* synthetic */ PaymentsApi(String apiVersion, EnhancedPaymentsApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsBusinessValidationErrorCode;", "", "(Ljava/lang/String;I)V", "MERCHANT_INACTIVE", "CURRENCY_CODE_INVALID", "SEGMENT_CODE_INVALID", "PAYMENT_TYPE_CODE_INVALID", "PAYMENT_METHOD_CODE_INVALID", "PAYMENT_OPERATOR_CODE_INVALID", "payment-client-v2"})
    public static final class ListPaymentOptionsBusinessValidationErrorCode
    extends Enum<ListPaymentOptionsBusinessValidationErrorCode> {
        public static final /* enum */ ListPaymentOptionsBusinessValidationErrorCode MERCHANT_INACTIVE = new ListPaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ ListPaymentOptionsBusinessValidationErrorCode CURRENCY_CODE_INVALID = new ListPaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ ListPaymentOptionsBusinessValidationErrorCode SEGMENT_CODE_INVALID = new ListPaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ ListPaymentOptionsBusinessValidationErrorCode PAYMENT_TYPE_CODE_INVALID = new ListPaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ ListPaymentOptionsBusinessValidationErrorCode PAYMENT_METHOD_CODE_INVALID = new ListPaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ ListPaymentOptionsBusinessValidationErrorCode PAYMENT_OPERATOR_CODE_INVALID = new ListPaymentOptionsBusinessValidationErrorCode();
        private static final /* synthetic */ ListPaymentOptionsBusinessValidationErrorCode[] $VALUES;

        public static ListPaymentOptionsBusinessValidationErrorCode[] values() {
            return (ListPaymentOptionsBusinessValidationErrorCode[])$VALUES.clone();
        }

        public static ListPaymentOptionsBusinessValidationErrorCode valueOf(String value) {
            return Enum.valueOf(ListPaymentOptionsBusinessValidationErrorCode.class, value);
        }

        static {
            $VALUES = listPaymentOptionsBusinessValidationErrorCodeArray = new ListPaymentOptionsBusinessValidationErrorCode[]{ListPaymentOptionsBusinessValidationErrorCode.MERCHANT_INACTIVE, ListPaymentOptionsBusinessValidationErrorCode.CURRENCY_CODE_INVALID, ListPaymentOptionsBusinessValidationErrorCode.SEGMENT_CODE_INVALID, ListPaymentOptionsBusinessValidationErrorCode.PAYMENT_TYPE_CODE_INVALID, ListPaymentOptionsBusinessValidationErrorCode.PAYMENT_METHOD_CODE_INVALID, ListPaymentOptionsBusinessValidationErrorCode.PAYMENT_OPERATOR_CODE_INVALID};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000f\u0018\u0000 \u00172\u00020\u0001:\u0003\u0015\u0016\u0017B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B[\b\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\rR\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u0018"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "", "builder", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;", "(Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;)V", "paymentTypeCode", "Ltech/carpentum/sdk/payment/model/PaymentTypeCode;", "paymentMethodCodes", "", "", "currencyCodes", "segmentCodes", "paymentOperatorCodes", "(Ltech/carpentum/sdk/payment/model/PaymentTypeCode;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getCurrencyCodes", "()Ljava/util/Set;", "getPaymentMethodCodes", "getPaymentOperatorCodes", "getPaymentTypeCode", "()Ltech/carpentum/sdk/payment/model/PaymentTypeCode;", "getSegmentCodes", "Builder", "BuilderImpl", "Factory", "payment-client-v2"})
    public static final class ListPaymentOptionsQuery {
        @NotNull
        public static final Factory Factory = new Factory(null);
        @Nullable
        private final PaymentTypeCode paymentTypeCode;
        @Nullable
        private final Set<String> paymentMethodCodes;
        @Nullable
        private final Set<String> currencyCodes;
        @Nullable
        private final Set<String> segmentCodes;
        @Nullable
        private final Set<String> paymentOperatorCodes;
        @NotNull
        private static final ListPaymentOptionsQuery empty;

        private ListPaymentOptionsQuery(PaymentTypeCode paymentTypeCode, Set<String> paymentMethodCodes, Set<String> currencyCodes, Set<String> segmentCodes, Set<String> paymentOperatorCodes) {
            this.paymentTypeCode = paymentTypeCode;
            this.paymentMethodCodes = paymentMethodCodes;
            this.currencyCodes = currencyCodes;
            this.segmentCodes = segmentCodes;
            this.paymentOperatorCodes = paymentOperatorCodes;
        }

        /* synthetic */ ListPaymentOptionsQuery(PaymentTypeCode paymentTypeCode, Set set, Set set2, Set set3, Set set4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                paymentTypeCode = null;
            }
            if ((n & 2) != 0) {
                set = null;
            }
            if ((n & 4) != 0) {
                set2 = null;
            }
            if ((n & 8) != 0) {
                set3 = null;
            }
            if ((n & 0x10) != 0) {
                set4 = null;
            }
            this(paymentTypeCode, set, set2, set3, set4);
        }

        @Nullable
        public final PaymentTypeCode getPaymentTypeCode() {
            return this.paymentTypeCode;
        }

        @Nullable
        public final Set<String> getPaymentMethodCodes() {
            return this.paymentMethodCodes;
        }

        @Nullable
        public final Set<String> getCurrencyCodes() {
            return this.currencyCodes;
        }

        @Nullable
        public final Set<String> getSegmentCodes() {
            return this.segmentCodes;
        }

        @Nullable
        public final Set<String> getPaymentOperatorCodes() {
            return this.paymentOperatorCodes;
        }

        private ListPaymentOptionsQuery(BuilderImpl builder) {
            this(builder.getPaymentTypeCode(), builder.getPaymentMethodCodes(), builder.getCurrencyCodes(), builder.getSegmentCodes(), builder.getPaymentOperatorCodes());
        }

        @JvmStatic
        @NotNull
        public static final Builder builder() {
            return Factory.builder();
        }

        @JvmStatic
        @NotNull
        public static Builder paymentTypeCode(@NotNull PaymentTypeCode paymentTypeCode) {
            return Factory.paymentTypeCode(paymentTypeCode);
        }

        @JvmStatic
        @NotNull
        public static Builder paymentMethodCodes(String ... codes) {
            return Factory.paymentMethodCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static Builder paymentMethodCodes(PaymentMethodCode ... codes) {
            return Factory.paymentMethodCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static Builder currencyCodes(String ... codes) {
            return Factory.currencyCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static Builder segmentCodes(String ... codes) {
            return Factory.segmentCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static Builder paymentOperatorCodes(String ... codes) {
            return Factory.paymentOperatorCodes(codes);
        }

        @JvmStatic
        @NotNull
        public static final ListPaymentOptionsQuery any() {
            return Factory.any();
        }

        public /* synthetic */ ListPaymentOptionsQuery(BuilderImpl builder, DefaultConstructorMarker $constructor_marker) {
            this(builder);
        }

        static {
            Object t = Factory.builder().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"builder().get()");
            empty = (ListPaymentOptionsQuery)t;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0001H\u0007J!\u0010\u0007\u001a\u00020\u00012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0017\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0004H\u0016J!\u0010\r\u001a\u00020\u00012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0017\u00a2\u0006\u0002\u0010\u000bJ!\u0010\r\u001a\u00020\u00012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\t\"\u00020\u000eH\u0017\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0010\u001a\u00020\u00012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0017\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J!\u0010\u0013\u001a\u00020\u00012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\nH\u0017\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Factory;", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "()V", "empty", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "any", "builder", "currencyCodes", "codes", "", "", "([Ljava/lang/String;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "get", "paymentMethodCodes", "Ltech/carpentum/sdk/payment/model/PaymentMethodCode;", "([Ltech/carpentum/sdk/payment/model/PaymentMethodCode;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "paymentOperatorCodes", "paymentTypeCode", "Ltech/carpentum/sdk/payment/model/PaymentTypeCode;", "segmentCodes", "payment-client-v2"})
        public static final class Factory
        implements Builder {
            private Factory() {
            }

            @JvmStatic
            @NotNull
            public final Builder builder() {
                return new BuilderImpl();
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder paymentTypeCode(@NotNull PaymentTypeCode paymentTypeCode) {
                Intrinsics.checkNotNullParameter((Object)((Object)paymentTypeCode), (String)"paymentTypeCode");
                return this.builder().paymentTypeCode(paymentTypeCode);
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder paymentMethodCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                return this.builder().paymentMethodCodes(Arrays.copyOf(codes, codes.length));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @JvmStatic
            @NotNull
            public Builder paymentMethodCodes(PaymentMethodCode ... codes) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                PaymentMethodCode[] paymentMethodCodeArray = codes;
                Builder builder = this.builder();
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var8_8 = $this$mapTo$iv$iv;
                int n = ((void)var8_8).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_12 = item$iv$iv = var8_8[i];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.name();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = collection;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray2 = stringArray;
                return builder.paymentMethodCodes(Arrays.copyOf(stringArray2, stringArray2.length));
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder currencyCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                return this.builder().currencyCodes(Arrays.copyOf(codes, codes.length));
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder segmentCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                return this.builder().segmentCodes(Arrays.copyOf(codes, codes.length));
            }

            @Override
            @JvmStatic
            @NotNull
            public Builder paymentOperatorCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                return this.builder().paymentOperatorCodes(Arrays.copyOf(codes, codes.length));
            }

            @Override
            @NotNull
            public ListPaymentOptionsQuery get() {
                Object t = this.builder().get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"builder().get()");
                return (ListPaymentOptionsQuery)t;
            }

            @JvmStatic
            @NotNull
            public final ListPaymentOptionsQuery any() {
                return empty;
            }

            public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001J!\u0010\u0003\u001a\u00020\u00002\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0007J!\u0010\b\u001a\u00020\u00002\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0007J!\u0010\b\u001a\u00020\u00002\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0005\"\u00020\tH&\u00a2\u0006\u0002\u0010\nJ!\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH&J!\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\u000f"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "Ljava/util/function/Supplier;", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "currencyCodes", "codes", "", "", "([Ljava/lang/String;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "paymentMethodCodes", "Ltech/carpentum/sdk/payment/model/PaymentMethodCode;", "([Ltech/carpentum/sdk/payment/model/PaymentMethodCode;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "paymentOperatorCodes", "paymentTypeCode", "Ltech/carpentum/sdk/payment/model/PaymentTypeCode;", "segmentCodes", "payment-client-v2"})
        public static interface Builder
        extends Supplier<ListPaymentOptionsQuery> {
            @NotNull
            public Builder paymentTypeCode(@NotNull PaymentTypeCode var1);

            @NotNull
            public Builder paymentMethodCodes(String ... var1);

            @NotNull
            public Builder paymentMethodCodes(PaymentMethodCode ... var1);

            @NotNull
            public Builder currencyCodes(String ... var1);

            @NotNull
            public Builder segmentCodes(String ... var1);

            @NotNull
            public Builder paymentOperatorCodes(String ... var1);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0006\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0014\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016J!\u0010\t\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0014\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0015J!\u0010\t\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0014\"\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J!\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0014\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\rH\u0016J!\u0010\u0011\u001a\u00020\u00002\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0014\"\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0015R.\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR.\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR.\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0003\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R.\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u001a"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$Builder;", "()V", "<set-?>", "", "", "currencyCodes", "getCurrencyCodes", "()Ljava/util/Set;", "paymentMethodCodes", "getPaymentMethodCodes", "paymentOperatorCodes", "getPaymentOperatorCodes", "Ltech/carpentum/sdk/payment/model/PaymentTypeCode;", "paymentTypeCode", "getPaymentTypeCode", "()Ltech/carpentum/sdk/payment/model/PaymentTypeCode;", "segmentCodes", "getSegmentCodes", "codes", "", "([Ljava/lang/String;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;", "get", "Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery;", "Ltech/carpentum/sdk/payment/model/PaymentMethodCode;", "([Ltech/carpentum/sdk/payment/model/PaymentMethodCode;)Ltech/carpentum/sdk/payment/PaymentsApi$ListPaymentOptionsQuery$BuilderImpl;", "payment-client-v2"})
        private static final class BuilderImpl
        implements Builder {
            @Nullable
            private PaymentTypeCode paymentTypeCode;
            @Nullable
            private Set<String> paymentMethodCodes;
            @Nullable
            private Set<String> currencyCodes;
            @Nullable
            private Set<String> segmentCodes;
            @Nullable
            private Set<String> paymentOperatorCodes;

            @Nullable
            public final PaymentTypeCode getPaymentTypeCode() {
                return this.paymentTypeCode;
            }

            @Nullable
            public final Set<String> getPaymentMethodCodes() {
                return this.paymentMethodCodes;
            }

            @Nullable
            public final Set<String> getCurrencyCodes() {
                return this.currencyCodes;
            }

            @Nullable
            public final Set<String> getSegmentCodes() {
                return this.segmentCodes;
            }

            @Nullable
            public final Set<String> getPaymentOperatorCodes() {
                return this.paymentOperatorCodes;
            }

            @Override
            @NotNull
            public BuilderImpl paymentTypeCode(@NotNull PaymentTypeCode paymentTypeCode) {
                Intrinsics.checkNotNullParameter((Object)((Object)paymentTypeCode), (String)"paymentTypeCode");
                BuilderImpl builderImpl = this;
                boolean bl = false;
                boolean bl2 = false;
                BuilderImpl $this$paymentTypeCode_u24lambda_u2d0 = builderImpl;
                boolean bl3 = false;
                $this$paymentTypeCode_u24lambda_u2d0.paymentTypeCode = paymentTypeCode;
                return builderImpl;
            }

            @Override
            @NotNull
            public BuilderImpl paymentMethodCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                BuilderImpl builderImpl = this;
                boolean bl = false;
                boolean bl2 = false;
                BuilderImpl $this$paymentMethodCodes_u24lambda_u2d1 = builderImpl;
                boolean bl3 = false;
                $this$paymentMethodCodes_u24lambda_u2d1.paymentMethodCodes = CommaSeparatedCodes.INSTANCE.of(Arrays.copyOf(codes, codes.length));
                return builderImpl;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public BuilderImpl paymentMethodCodes(PaymentMethodCode ... codes) {
                void $this$toTypedArray$iv;
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                BuilderImpl builderImpl = this;
                boolean bl = false;
                boolean bl2 = false;
                BuilderImpl $this$paymentMethodCodes_u24lambda_u2d3 = builderImpl;
                boolean bl3 = false;
                PaymentMethodCode[] paymentMethodCodeArray = codes;
                BuilderImpl builderImpl2 = $this$paymentMethodCodes_u24lambda_u2d3;
                boolean $i$f$map = false;
                void var10_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var13_13 = $this$mapTo$iv$iv;
                int n = ((void)var13_13).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var17_17 = item$iv$iv = var13_13[i];
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    String string = it.name();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray2 = stringArray;
                builderImpl2.paymentMethodCodes(Arrays.copyOf(stringArray2, stringArray2.length));
                return builderImpl;
            }

            @Override
            @NotNull
            public BuilderImpl currencyCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                BuilderImpl builderImpl = this;
                boolean bl = false;
                boolean bl2 = false;
                BuilderImpl $this$currencyCodes_u24lambda_u2d4 = builderImpl;
                boolean bl3 = false;
                $this$currencyCodes_u24lambda_u2d4.currencyCodes = CommaSeparatedCodes.INSTANCE.of(Arrays.copyOf(codes, codes.length));
                return builderImpl;
            }

            @Override
            @NotNull
            public BuilderImpl segmentCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                BuilderImpl builderImpl = this;
                boolean bl = false;
                boolean bl2 = false;
                BuilderImpl $this$segmentCodes_u24lambda_u2d5 = builderImpl;
                boolean bl3 = false;
                $this$segmentCodes_u24lambda_u2d5.segmentCodes = CommaSeparatedCodes.INSTANCE.of(Arrays.copyOf(codes, codes.length));
                return builderImpl;
            }

            @Override
            @NotNull
            public BuilderImpl paymentOperatorCodes(String ... codes) {
                Intrinsics.checkNotNullParameter((Object)codes, (String)"codes");
                BuilderImpl builderImpl = this;
                boolean bl = false;
                boolean bl2 = false;
                BuilderImpl $this$paymentOperatorCodes_u24lambda_u2d6 = builderImpl;
                boolean bl3 = false;
                $this$paymentOperatorCodes_u24lambda_u2d6.paymentOperatorCodes = CommaSeparatedCodes.INSTANCE.of(Arrays.copyOf(codes, codes.length));
                return builderImpl;
            }

            @Override
            @NotNull
            public ListPaymentOptionsQuery get() {
                return new ListPaymentOptionsQuery(this, null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\fH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007\u00a8\u0006\u0011"}, d2={"Ltech/carpentum/sdk/payment/PaymentsApi$Factory;", "", "()V", "create", "Ltech/carpentum/sdk/payment/PaymentsApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "defineListCurrenciesEndpoint", "Ltech/carpentum/sdk/payment/EndpointDefinition;", "defineListPaymentMethodsEndpoint", "defineListPaymentOperatorsEndpoint", "defineListPaymentOptionsEndpoint", "defineListSegmentsEndpoint", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListCurrenciesEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/currencies");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListPaymentMethodsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/payment-methods");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListPaymentOperatorsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/payment-operators");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListPaymentOptionsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/payment-options");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineListSegmentsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/segments");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Duration duration = callTimeout;
            return new PaymentsApi(context.getApiVersion(), new EnhancedPaymentsApi(context.getApiBaseUrl(), accessToken, duration == null ? context.getDefaultCallTimeout() : duration), null);
        }

        public static /* synthetic */ PaymentsApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.PaymentsApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

