/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.api;

import com.squareup.moshi.JsonAdapter;
import java.io.InterruptedIOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.carpentum.sdk.payment.ClientBasicErrorException;
import tech.carpentum.sdk.payment.ClientErrorException;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.ServerBasicErrorException;
import tech.carpentum.sdk.payment.ServerErrorException;
import tech.carpentum.sdk.payment.internal.api.BusinessValidationErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Response;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Serializer;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerException;
import tech.carpentum.sdk.payment.model.BasicError;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0011H\u0002J+\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u0016R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltech/carpentum/sdk/payment/internal/api/ResponseExceptionUtils;", "", "()V", "jsonAdapterBasicError", "Lcom/squareup/moshi/JsonAdapter;", "Ltech/carpentum/sdk/payment/model/BasicError;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "clientException", "Ltech/carpentum/sdk/payment/ClientErrorException;", "cause", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ClientException;", "businessValidationErrorExceptionFactory", "Ltech/carpentum/sdk/payment/internal/api/BusinessValidationErrorExceptionFactory;", "serverException", "Ltech/carpentum/sdk/payment/ServerErrorException;", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ServerException;", "wrap", "T", "apiCall", "Lkotlin/Function0;", "(Ltech/carpentum/sdk/payment/internal/api/BusinessValidationErrorExceptionFactory;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "payment-client-v2"})
public final class ResponseExceptionUtils {
    @NotNull
    public static final ResponseExceptionUtils INSTANCE = new ResponseExceptionUtils();
    private static final Logger logger = LoggerFactory.getLogger(ResponseExceptionUtils.class);
    private static final JsonAdapter<BasicError> jsonAdapterBasicError = Serializer.getMoshi().adapter(BasicError.class);

    private ResponseExceptionUtils() {
    }

    private final ClientErrorException clientException(ClientException cause, BusinessValidationErrorExceptionFactory<?> businessValidationErrorExceptionFactory) {
        Object object;
        int statusCode = cause.getStatusCode();
        Response response = cause.getResponse();
        if (response == null) {
            throw new NullPointerException("null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
        }
        String bodyContent = String.valueOf(((ClientError)response).getBody());
        try {
            Object object2;
            if (statusCode == 406) {
                object2 = businessValidationErrorExceptionFactory.create(cause, statusCode, bodyContent);
            } else {
                Throwable throwable = cause;
                Object object3 = jsonAdapterBasicError.fromJson(bodyContent);
                Intrinsics.checkNotNull((Object)object3);
                object2 = new ClientBasicErrorException(throwable, statusCode, (BasicError)object3);
            }
            object = object2;
        }
        catch (Exception ex) {
            logger.debug("Error parsing response: {}", (Object)cause.getResponse(), (Object)ex);
            object = new ClientErrorException(cause, statusCode, bodyContent);
        }
        return object;
    }

    private final ServerErrorException serverException(ServerException cause) {
        ServerErrorException serverErrorException;
        int statusCode = cause.getStatusCode();
        Response response = cause.getResponse();
        if (response == null) {
            throw new NullPointerException("null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
        }
        String bodyContent = String.valueOf(((ServerError)response).getBody());
        try {
            Throwable throwable = cause;
            Object object = jsonAdapterBasicError.fromJson(bodyContent);
            Intrinsics.checkNotNull((Object)object);
            serverErrorException = new ServerBasicErrorException(throwable, statusCode, (BasicError)object);
        }
        catch (Exception ex) {
            logger.debug("Error parsing response: {}", (Object)cause.getResponse(), (Object)ex);
            serverErrorException = new ServerErrorException(cause, statusCode, null, 4, null);
        }
        return serverErrorException;
    }

    public final <T> T wrap(@NotNull BusinessValidationErrorExceptionFactory<?> businessValidationErrorExceptionFactory, @NotNull Function0<? extends T> apiCall) throws ResponseException, InterruptedIOException {
        Object object;
        Intrinsics.checkNotNullParameter(businessValidationErrorExceptionFactory, (String)"businessValidationErrorExceptionFactory");
        Intrinsics.checkNotNullParameter(apiCall, (String)"apiCall");
        try {
            object = apiCall.invoke();
        }
        catch (ClientException ex) {
            throw this.clientException(ex, businessValidationErrorExceptionFactory);
        }
        catch (ServerException ex) {
            throw this.serverException(ex);
        }
        return (T)object;
    }
}

