/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestEWallet;
import tech.carpentum.sdk.payment.model.EWalletMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class EWalletMethodImpl
implements EWalletMethod {
    private final AccountPayinRequestEWallet account;
    private final Optional<String> emailAddress;
    private final Optional<String> phoneNumber;
    private final String paymentOperatorCode;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayinRequestEWallet getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private EWalletMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.hashCode = Objects.hash(this.account, this.emailAddress, this.phoneNumber, this.paymentOperatorCode);
        this.toString = builder.type + "(account=" + this.account + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", paymentOperatorCode=" + this.paymentOperatorCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EWalletMethodImpl)) {
            return false;
        }
        EWalletMethodImpl that = (EWalletMethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.emailAddress.equals(that.emailAddress)) {
            return false;
        }
        if (!this.phoneNumber.equals(that.phoneNumber)) {
            return false;
        }
        return this.paymentOperatorCode.equals(that.paymentOperatorCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements EWalletMethod.Builder {
        private AccountPayinRequestEWallet account = null;
        private String emailAddress = null;
        private String phoneNumber = null;
        private String paymentOperatorCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("EWalletMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestEWallet account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public EWalletMethodImpl build() {
            return new EWalletMethodImpl(this);
        }
    }
}

