/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.NetBankingMethodResponseImpl;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public interface NetBankingMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.NETBANKING;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public Money getMoney();

    @NotNull
    public String getMerchantName();

    @NotNull
    public String getReference();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(NetBankingMethodResponse copyOf) {
        Builder builder = NetBankingMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.money(copyOf.getMoney());
        builder.merchantName(copyOf.getMerchantName());
        builder.reference(copyOf.getReference());
        builder.returnUrl(copyOf.getReturnUrl());
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new NetBankingMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        @NotNull
        public Builder idPayment(IdPayment var1);

        @NotNull
        public Builder money(Money var1);

        @NotNull
        public Builder merchantName(String var1);

        @NotNull
        public Builder reference(String var1);

        @NotNull
        public Builder returnUrl(String var1);

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        @NotNull
        public NetBankingMethodResponse build();
    }
}

