/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PaymentProcessImpl;
import tech.carpentum.sdk.payment.model.FailureReasons;
import tech.carpentum.sdk.payment.model.PaymentStatus;

@JsonClass(generateAdapter=false)
public interface PaymentProcess {
    @NotNull
    public PaymentStatus getStatus();

    @NotNull
    public Optional<FailureReasons> getFailureReasons();

    @NotNull
    public OffsetDateTime getCreatedAt();

    @NotNull
    public Optional<OffsetDateTime> getProcessedAt();

    @NotNull
    public Boolean getIsTest();

    public static Builder builder() {
        return new PaymentProcessImpl.BuilderImpl();
    }

    public static interface Builder {
        public Builder status(PaymentStatus var1);

        public Builder failureReasons(FailureReasons var1);

        public Builder createdAt(OffsetDateTime var1);

        public Builder processedAt(OffsetDateTime var1);

        public Builder isTest(Boolean var1);

        public PaymentProcess build();
    }
}

