/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PaymentOptionImpl;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.IntervalNumberTo;
import tech.carpentum.sdk.payment.model.PayinMethodCode;
import tech.carpentum.sdk.payment.model.PaymentOperatorOption;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public interface PaymentOption {
    public static final String PAYMENT_TYPE_CODE_PAYIN = "PAYIN";
    public static final String PAYMENT_TYPE_CODE_PAYOUT = "PAYOUT";

    @NotNull
    public String getPaymentTypeCode();

    @NotNull
    public PayinMethodCode getPaymentMethodCode();

    @NotNull
    public CurrencyCode getCurrencyCode();

    @NotNull
    public Optional<SegmentCode> getSegmentCode();

    @NotNull
    public IntervalNumberTo getTransactionAmountLimit();

    @NotNull
    public Boolean getIsAvailable();

    @NotNull
    public @NotNull List<@NotNull PaymentOperatorOption> getPaymentOperators();

    public static Builder builder() {
        return new PaymentOptionImpl.BuilderImpl();
    }

    public static interface Builder {
        public Builder paymentTypeCode(String var1);

        public Builder paymentMethodCode(PayinMethodCode var1);

        public Builder currencyCode(CurrencyCode var1);

        public Builder segmentCode(SegmentCode var1);

        public Builder transactionAmountLimit(IntervalNumberTo var1);

        public Builder isAvailable(Boolean var1);

        public Builder paymentOperators(List<@NotNull PaymentOperatorOption> var1);

        public Builder paymentOperatorsAdd(PaymentOperatorOption var1);

        public Builder paymentOperatorsAddAll(List<@NotNull PaymentOperatorOption> var1);

        public PaymentOption build();
    }
}

