/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.OnlineMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountResponseOnlyWithBank;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public interface OnlineMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.ONLINE;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public AccountResponseOnlyWithBank getAccount();

    @NotNull
    public Money getMoney();

    @NotNull
    public Optional<Money> getMoneyRequired();

    @NotNull
    public String getReference();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    public static Builder builder() {
        return new OnlineMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        public Builder idPayin(IdPayin var1);

        public Builder account(AccountResponseOnlyWithBank var1);

        public Builder money(Money var1);

        public Builder moneyRequired(Money var1);

        public Builder reference(String var1);

        public Builder returnUrl(String var1);

        public Builder acceptedAt(OffsetDateTime var1);

        public Builder expireAt(OffsetDateTime var1);

        public OnlineMethodResponse build();
    }
}

