/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.DuitNowPayMethodResponseImpl;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentOperator;

@JsonClass(generateAdapter=false)
public interface DuitNowPayMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.DUITNOW;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public Money getMoney();

    @NotNull
    public Optional<Money> getMoneyRequired();

    @NotNull
    public String getMerchantName();

    @NotNull
    public String getReference();

    @NotNull
    public String getQrName();

    @NotNull
    public String getQrCode();

    @NotNull
    public Optional<PaymentOperator> getPaymentOperator();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    public static Builder builder() {
        return new DuitNowPayMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        public Builder idPayin(IdPayin var1);

        public Builder money(Money var1);

        public Builder moneyRequired(Money var1);

        public Builder merchantName(String var1);

        public Builder reference(String var1);

        public Builder qrName(String var1);

        public Builder qrCode(String var1);

        public Builder paymentOperator(PaymentOperator var1);

        public Builder returnUrl(String var1);

        public Builder acceptedAt(OffsetDateTime var1);

        public Builder expireAt(OffsetDateTime var1);

        public DuitNowPayMethodResponse build();
    }
}

