/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayinRequestIMPS;
import tech.carpentum.sdk.payment.model.IMPSMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class IMPSMethodImpl
implements IMPSMethod {
    private final AccountPayinRequestIMPS account;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public AccountPayinRequestIMPS getAccount() {
        return this.account;
    }

    @Override
    @NotNull
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    @NotNull
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private IMPSMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.account, this.emailAddress);
        this.toString = "IMPSMethod(account=" + this.account + ", emailAddress=" + this.emailAddress + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IMPSMethod)) {
            return false;
        }
        IMPSMethodImpl that = (IMPSMethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        return this.emailAddress.equals(that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements IMPSMethod.Builder {
        private AccountPayinRequestIMPS account = null;
        private String emailAddress = null;

        @Override
        public BuilderImpl account(AccountPayinRequestIMPS account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public IMPSMethodImpl build() {
            return new IMPSMethodImpl(this);
        }
    }
}

