/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AvailablePayinOption;
import tech.carpentum.sdk.payment.model.PayinMethodCode;
import tech.carpentum.sdk.payment.model.PaymentOperator;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class AvailablePayinOptionImpl
implements AvailablePayinOption {
    private final PayinMethodCode paymentMethodCode;
    private final List<@NotNull PaymentOperator> paymentOperators;
    private final Optional<SegmentCode> segmentCode;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public PayinMethodCode getPaymentMethodCode() {
        return this.paymentMethodCode;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull PaymentOperator> getPaymentOperators() {
        return this.paymentOperators;
    }

    @Override
    @NotNull
    public Optional<SegmentCode> getSegmentCode() {
        return this.segmentCode;
    }

    private AvailablePayinOptionImpl(BuilderImpl builder) {
        this.paymentMethodCode = Objects.requireNonNull(builder.paymentMethodCode, "Property 'paymentMethodCode' is required.");
        this.paymentOperators = Collections.unmodifiableList(builder.paymentOperators);
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.hashCode = Objects.hash(this.paymentMethodCode, this.paymentOperators, this.segmentCode);
        this.toString = "AvailablePayinOption(paymentMethodCode=" + this.paymentMethodCode + ", paymentOperators=" + this.paymentOperators + ", segmentCode=" + this.segmentCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailablePayinOption)) {
            return false;
        }
        AvailablePayinOptionImpl that = (AvailablePayinOptionImpl)obj;
        if (!this.paymentMethodCode.equals(that.paymentMethodCode)) {
            return false;
        }
        if (!this.paymentOperators.equals(that.paymentOperators)) {
            return false;
        }
        return this.segmentCode.equals(that.segmentCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AvailablePayinOption.Builder {
        private PayinMethodCode paymentMethodCode = null;
        private List<@NotNull PaymentOperator> paymentOperators = new ArrayList<PaymentOperator>();
        private SegmentCode segmentCode = null;

        @Override
        public BuilderImpl paymentMethodCode(PayinMethodCode paymentMethodCode) {
            this.paymentMethodCode = paymentMethodCode;
            return this;
        }

        @Override
        public BuilderImpl paymentOperators(List<@NotNull PaymentOperator> paymentOperators) {
            this.paymentOperators.clear();
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAdd(PaymentOperator item) {
            if (item != null) {
                this.paymentOperators.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAddAll(List<@NotNull PaymentOperator> paymentOperators) {
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public BuilderImpl segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        @Override
        public AvailablePayinOptionImpl build() {
            return new AvailablePayinOptionImpl(this);
        }
    }
}

