/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.EndpointWithIdDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.EnhancedOutgoingPaymentsApi;
import tech.carpentum.sdk.payment.internal.api.GetPayoutErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.PostAvailablePayoutOptionsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.PostPayoutsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.AvailablePayoutOptionList;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.Payout;
import tech.carpentum.sdk.payment.model.PayoutAccepted;
import tech.carpentum.sdk.payment.model.PayoutDetail;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltech/carpentum/sdk/payment/OutgoingPaymentsApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedOutgoingPaymentsApi;", "(ILtech/carpentum/sdk/payment/internal/api/EnhancedOutgoingPaymentsApi;)V", "availablePaymentOptions", "Ltech/carpentum/sdk/payment/model/AvailablePayoutOptionList;", "paymentRequested", "Ltech/carpentum/sdk/payment/model/PaymentRequested;", "createPayout", "Ltech/carpentum/sdk/payment/model/PayoutAccepted;", "idPayout", "", "payout", "Ltech/carpentum/sdk/payment/model/Payout;", "getPayout", "Ltech/carpentum/sdk/payment/model/PayoutDetail;", "Factory", "payment-client-v2"})
public final class OutgoingPaymentsApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    private final int apiVersion;
    @NotNull
    private final EnhancedOutgoingPaymentsApi api;

    private OutgoingPaymentsApi(int apiVersion, EnhancedOutgoingPaymentsApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @NotNull
    public final AvailablePayoutOptionList availablePaymentOptions(@NotNull PaymentRequested paymentRequested) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)paymentRequested, (String)"paymentRequested");
        return (AvailablePayoutOptionList)ResponseExceptionUtils.INSTANCE.wrap(PostAvailablePayoutOptionsErrorExceptionFactory.Companion.getInstance(), (Function0)new Function0<AvailablePayoutOptionList>(this, paymentRequested){
            final /* synthetic */ OutgoingPaymentsApi this$0;
            final /* synthetic */ PaymentRequested $paymentRequested;
            {
                this.this$0 = $receiver;
                this.$paymentRequested = $paymentRequested;
                super(0);
            }

            @NotNull
            public final AvailablePayoutOptionList invoke() {
                return OutgoingPaymentsApi.access$getApi$p(this.this$0).payoutAvailablePaymentOptions(OutgoingPaymentsApi.access$getApiVersion$p(this.this$0), this.$paymentRequested);
            }
        });
    }

    @NotNull
    public final PayoutAccepted createPayout(@NotNull String idPayout, @NotNull Payout payout) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)idPayout, (String)"idPayout");
        Intrinsics.checkNotNullParameter((Object)payout, (String)"payout");
        return (PayoutAccepted)ResponseExceptionUtils.INSTANCE.wrap(PostPayoutsErrorExceptionFactory.Companion.getInstance(), (Function0)new Function0<PayoutAccepted>(this, idPayout, payout){
            final /* synthetic */ OutgoingPaymentsApi this$0;
            final /* synthetic */ String $idPayout;
            final /* synthetic */ Payout $payout;
            {
                this.this$0 = $receiver;
                this.$idPayout = $idPayout;
                this.$payout = $payout;
                super(0);
            }

            @NotNull
            public final PayoutAccepted invoke() {
                EnhancedOutgoingPaymentsApi enhancedOutgoingPaymentsApi = OutgoingPaymentsApi.access$getApi$p(this.this$0);
                int n = OutgoingPaymentsApi.access$getApiVersion$p(this.this$0);
                return enhancedOutgoingPaymentsApi.createPayout(n, this.$idPayout, this.$payout);
            }
        });
    }

    @NotNull
    public final PayoutDetail getPayout(@NotNull String idPayout) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)idPayout, (String)"idPayout");
        return (PayoutDetail)ResponseExceptionUtils.INSTANCE.wrap(GetPayoutErrorExceptionFactory.Companion.getInstance(), (Function0)new Function0<PayoutDetail>(this, idPayout){
            final /* synthetic */ OutgoingPaymentsApi this$0;
            final /* synthetic */ String $idPayout;
            {
                this.this$0 = $receiver;
                this.$idPayout = $idPayout;
                super(0);
            }

            @NotNull
            public final PayoutDetail invoke() {
                EnhancedOutgoingPaymentsApi enhancedOutgoingPaymentsApi = OutgoingPaymentsApi.access$getApi$p(this.this$0);
                int n = OutgoingPaymentsApi.access$getApiVersion$p(this.this$0);
                return enhancedOutgoingPaymentsApi.getPayout(n, this.$idPayout);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineCreatePayoutEndpoint() {
        return Factory.defineCreatePayoutEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineGetPayoutEndpoint() {
        return Factory.defineGetPayoutEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OutgoingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final OutgoingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public static final /* synthetic */ EnhancedOutgoingPaymentsApi access$getApi$p(OutgoingPaymentsApi $this) {
        return $this.api;
    }

    public static final /* synthetic */ int access$getApiVersion$p(OutgoingPaymentsApi $this) {
        return $this.apiVersion;
    }

    public /* synthetic */ OutgoingPaymentsApi(int apiVersion, EnhancedOutgoingPaymentsApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007\u00a8\u0006\u000e"}, d2={"Ltech/carpentum/sdk/payment/OutgoingPaymentsApi$Factory;", "", "()V", "create", "Ltech/carpentum/sdk/payment/OutgoingPaymentsApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "defineCreatePayoutEndpoint", "Ltech/carpentum/sdk/payment/EndpointWithIdDefinition;", "defineGetPayoutEndpoint", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineCreatePayoutEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.POST, "/payouts/{id}");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineGetPayoutEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.GET, "/payouts/{id}");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OutgoingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            int n = context.getApiVersion();
            String string = context.getApiBaseUrl();
            Duration duration = callTimeout;
            if (duration == null) {
                duration = context.getDefaultCallTimeout();
            }
            return new OutgoingPaymentsApi(n, new EnhancedOutgoingPaymentsApi(string, accessToken, duration), null);
        }

        public static /* synthetic */ OutgoingPaymentsApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final OutgoingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.OutgoingPaymentsApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

