/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.NetBankingMethodResponse;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public class NetBankingMethodResponseImpl
implements NetBankingMethodResponse {
    private final IdPayin idPayin;
    private final Money money;
    private final String merchantName;
    private final String reference;
    private final String returnUrl;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    @NotNull
    public Money getMoney() {
        return this.money;
    }

    @Override
    @NotNull
    public String getMerchantName() {
        return this.merchantName;
    }

    @Override
    @NotNull
    public String getReference() {
        return this.reference;
    }

    @Override
    @NotNull
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    @NotNull
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    @NotNull
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    @NotNull
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private NetBankingMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.merchantName = Objects.requireNonNull(builder.merchantName, "Property 'merchantName' is required.");
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.money, this.merchantName, this.reference, this.returnUrl, this.acceptedAt, this.expireAt);
        this.toString = "NetBankingMethodResponse(idPayin=" + this.idPayin + ", money=" + this.money + ", merchantName=" + this.merchantName + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetBankingMethodResponse)) {
            return false;
        }
        NetBankingMethodResponseImpl that = (NetBankingMethodResponseImpl)obj;
        if (!this.idPayin.equals(that.idPayin)) {
            return false;
        }
        if (!this.money.equals(that.money)) {
            return false;
        }
        if (!this.merchantName.equals(that.merchantName)) {
            return false;
        }
        if (!this.reference.equals(that.reference)) {
            return false;
        }
        if (!this.returnUrl.equals(that.returnUrl)) {
            return false;
        }
        if (!this.acceptedAt.equals(that.acceptedAt)) {
            return false;
        }
        return this.expireAt.equals(that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements NetBankingMethodResponse.Builder {
        private IdPayin idPayin = null;
        private Money money = null;
        private String merchantName = null;
        private String reference = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public NetBankingMethodResponseImpl build() {
            return new NetBankingMethodResponseImpl(this);
        }
    }
}

