/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.MoneyFee;
import tech.carpentum.sdk.payment.model.PaymentProcess;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.PayoutMethodResponse;

@JsonClass(generateAdapter=false)
public class PayoutDetail {
    @NotNull
    public final PaymentRequested paymentRequested;
    @NotNull
    public final PaymentProcess process;
    @NotNull
    public final MoneyFee fee;
    @NotNull
    public final PayoutMethodResponse paymentMethodResponse;
    private final int hashCode;
    private final String toString;

    private PayoutDetail(Builder builder) {
        this.paymentRequested = Objects.requireNonNull(builder.paymentRequested, "Property 'paymentRequested' is required.");
        this.process = Objects.requireNonNull(builder.process, "Property 'process' is required.");
        this.fee = Objects.requireNonNull(builder.fee, "Property 'fee' is required.");
        this.paymentMethodResponse = Objects.requireNonNull(builder.paymentMethodResponse, "Property 'paymentMethodResponse' is required.");
        this.hashCode = Objects.hash(this.paymentRequested, this.process, this.fee, this.paymentMethodResponse);
        this.toString = "PayoutDetail(paymentRequested=" + this.paymentRequested + ", process=" + this.process + ", fee=" + this.fee + ", paymentMethodResponse=" + this.paymentMethodResponse + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayoutDetail)) {
            return false;
        }
        PayoutDetail that = (PayoutDetail)obj;
        if (!this.paymentRequested.equals(that.paymentRequested)) {
            return false;
        }
        if (!this.process.equals(that.process)) {
            return false;
        }
        if (!this.fee.equals(that.fee)) {
            return false;
        }
        return this.paymentMethodResponse.equals(that.paymentMethodResponse);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PaymentRequested paymentRequested = null;
        private PaymentProcess process = null;
        private MoneyFee fee = null;
        private PayoutMethodResponse paymentMethodResponse = null;

        private Builder() {
        }

        public Builder paymentRequested(PaymentRequested paymentRequested) {
            this.paymentRequested = paymentRequested;
            return this;
        }

        public Builder process(PaymentProcess process) {
            this.process = process;
            return this;
        }

        public Builder fee(MoneyFee fee) {
            this.fee = fee;
            return this;
        }

        public Builder paymentMethodResponse(PayoutMethodResponse paymentMethodResponse) {
            this.paymentMethodResponse = paymentMethodResponse;
            return this;
        }

        public PayoutDetail build() {
            return new PayoutDetail(this);
        }
    }
}

