/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public class Payout {
    @NotNull
    public final PaymentRequested paymentRequested;
    @NotNull
    public final PayoutMethod paymentMethod;
    @NotNull
    public final Optional<String> callbackUrl;
    @NotNull
    public final Optional<String> customerIp;
    private final int hashCode;
    private final String toString;

    private Payout(Builder builder) {
        this.paymentRequested = Objects.requireNonNull(builder.paymentRequested, "Property 'paymentRequested' is required.");
        this.paymentMethod = Objects.requireNonNull(builder.paymentMethod, "Property 'paymentMethod' is required.");
        this.callbackUrl = Optional.ofNullable(builder.callbackUrl);
        this.customerIp = Optional.ofNullable(builder.customerIp);
        this.hashCode = Objects.hash(this.paymentRequested, this.paymentMethod, this.callbackUrl, this.customerIp);
        this.toString = "Payout(paymentRequested=" + this.paymentRequested + ", paymentMethod=" + this.paymentMethod + ", callbackUrl=" + this.callbackUrl + ", customerIp=" + this.customerIp + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Payout)) {
            return false;
        }
        Payout that = (Payout)obj;
        if (!this.paymentRequested.equals(that.paymentRequested)) {
            return false;
        }
        if (!this.paymentMethod.equals(that.paymentMethod)) {
            return false;
        }
        if (!this.callbackUrl.equals(that.callbackUrl)) {
            return false;
        }
        return this.customerIp.equals(that.customerIp);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PaymentRequested paymentRequested = null;
        private PayoutMethod paymentMethod = null;
        private String callbackUrl = null;
        private String customerIp = null;

        private Builder() {
        }

        public Builder paymentRequested(PaymentRequested paymentRequested) {
            this.paymentRequested = paymentRequested;
            return this;
        }

        public Builder paymentMethod(PayoutMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder customerIp(String customerIp) {
            this.customerIp = customerIp;
            return this;
        }

        public Payout build() {
            return new Payout(this);
        }
    }
}

