/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class PaymentRequested {
    @NotNull
    public final Money money;
    @NotNull
    public final Optional<SegmentCode> segmentCode;
    private final int hashCode;
    private final String toString;

    private PaymentRequested(Builder builder) {
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.hashCode = Objects.hash(this.money, this.segmentCode);
        this.toString = "PaymentRequested(money=" + this.money + ", segmentCode=" + this.segmentCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentRequested)) {
            return false;
        }
        PaymentRequested that = (PaymentRequested)obj;
        if (!this.money.equals(that.money)) {
            return false;
        }
        return this.segmentCode.equals(that.segmentCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Money money = null;
        private SegmentCode segmentCode = null;

        private Builder() {
        }

        public Builder money(Money money) {
            this.money = money;
            return this;
        }

        public Builder segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        public PaymentRequested build() {
            return new PaymentRequested(this);
        }
    }
}

