/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.IntervalNumberTo;
import tech.carpentum.sdk.payment.model.PayinMethodCode;
import tech.carpentum.sdk.payment.model.PaymentOperatorOption;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class PaymentOption {
    public static final String PAYMENT_TYPE_CODE_PAYIN = "PAYIN";
    public static final String PAYMENT_TYPE_CODE_PAYOUT = "PAYOUT";
    @NotNull
    public final String paymentTypeCode;
    @NotNull
    public final PayinMethodCode paymentMethodCode;
    @NotNull
    public final CurrencyCode currencyCode;
    @NotNull
    public final Optional<SegmentCode> segmentCode;
    @NotNull
    public final IntervalNumberTo transactionAmountLimit;
    @NotNull
    public final Boolean isAvailable;
    @NotNull
    public final @NotNull List<@NotNull PaymentOperatorOption> paymentOperators;
    private final int hashCode;
    private final String toString;

    private PaymentOption(Builder builder) {
        this.paymentTypeCode = Objects.requireNonNull(builder.paymentTypeCode, "Property 'paymentTypeCode' is required.");
        this.paymentMethodCode = Objects.requireNonNull(builder.paymentMethodCode, "Property 'paymentMethodCode' is required.");
        this.currencyCode = Objects.requireNonNull(builder.currencyCode, "Property 'currencyCode' is required.");
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.transactionAmountLimit = Objects.requireNonNull(builder.transactionAmountLimit, "Property 'transactionAmountLimit' is required.");
        this.isAvailable = Objects.requireNonNull(builder.isAvailable, "Property 'isAvailable' is required.");
        this.paymentOperators = Collections.unmodifiableList(builder.paymentOperators);
        this.hashCode = Objects.hash(this.paymentTypeCode, this.paymentMethodCode, this.currencyCode, this.segmentCode, this.transactionAmountLimit, this.isAvailable, this.paymentOperators);
        this.toString = "PaymentOption(paymentTypeCode=" + this.paymentTypeCode + ", paymentMethodCode=" + this.paymentMethodCode + ", currencyCode=" + this.currencyCode + ", segmentCode=" + this.segmentCode + ", transactionAmountLimit=" + this.transactionAmountLimit + ", isAvailable=" + this.isAvailable + ", paymentOperators=" + this.paymentOperators + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentOption)) {
            return false;
        }
        PaymentOption that = (PaymentOption)obj;
        if (!this.paymentTypeCode.equals(that.paymentTypeCode)) {
            return false;
        }
        if (!this.paymentMethodCode.equals(that.paymentMethodCode)) {
            return false;
        }
        if (!this.currencyCode.equals(that.currencyCode)) {
            return false;
        }
        if (!this.segmentCode.equals(that.segmentCode)) {
            return false;
        }
        if (!this.transactionAmountLimit.equals(that.transactionAmountLimit)) {
            return false;
        }
        if (!this.isAvailable.equals(that.isAvailable)) {
            return false;
        }
        return this.paymentOperators.equals(that.paymentOperators);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String paymentTypeCode = null;
        private PayinMethodCode paymentMethodCode = null;
        private CurrencyCode currencyCode = null;
        private SegmentCode segmentCode = null;
        private IntervalNumberTo transactionAmountLimit = null;
        private Boolean isAvailable = null;
        private List<@NotNull PaymentOperatorOption> paymentOperators = new ArrayList<PaymentOperatorOption>();

        private Builder() {
        }

        public Builder paymentTypeCode(String paymentTypeCode) {
            this.paymentTypeCode = paymentTypeCode;
            return this;
        }

        public Builder paymentMethodCode(PayinMethodCode paymentMethodCode) {
            this.paymentMethodCode = paymentMethodCode;
            return this;
        }

        public Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        public Builder transactionAmountLimit(IntervalNumberTo transactionAmountLimit) {
            this.transactionAmountLimit = transactionAmountLimit;
            return this;
        }

        public Builder isAvailable(Boolean isAvailable) {
            this.isAvailable = isAvailable;
            return this;
        }

        public Builder paymentOperators(List<@NotNull PaymentOperatorOption> paymentOperators) {
            this.paymentOperators.clear();
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        public Builder paymentOperatorsAdd(PaymentOperatorOption item) {
            if (item != null) {
                this.paymentOperators.add(item);
            }
            return this;
        }

        public Builder paymentOperatorsAddAll(List<@NotNull PaymentOperatorOption> paymentOperators) {
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        public PaymentOption build() {
            return new PaymentOption(this);
        }
    }
}

