/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonClass(generateAdapter=false)
public class PaymentMethod {
    @NotNull
    public final String code;
    private final int hashCode;
    private final String toString;

    private PaymentMethod(Builder builder) {
        this.code = Objects.requireNonNull(builder.code, "Property 'code' is required.");
        this.hashCode = Objects.hash(this.code);
        this.toString = "PaymentMethod(code=" + this.code + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentMethod)) {
            return false;
        }
        PaymentMethod that = (PaymentMethod)obj;
        return this.code.equals(that.code);
    }

    public String toString() {
        return this.toString;
    }

    public static PaymentMethod ofCode(String code) {
        return PaymentMethod.builder().code(code).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String code = null;

        private Builder() {
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public PaymentMethod build() {
            return new PaymentMethod(this);
        }
    }
}

