/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.FailureReasonCode;

@JsonClass(generateAdapter=false)
public class FailureReasons {
    @NotNull
    public final OffsetDateTime failedAt;
    @NotNull
    public final FailureReasonCode failureReasonCode;
    @NotNull
    public final Optional<String> message;
    private final int hashCode;
    private final String toString;

    private FailureReasons(Builder builder) {
        this.failedAt = Objects.requireNonNull(builder.failedAt, "Property 'failedAt' is required.");
        this.failureReasonCode = Objects.requireNonNull(builder.failureReasonCode, "Property 'failureReasonCode' is required.");
        this.message = Optional.ofNullable(builder.message);
        this.hashCode = Objects.hash(this.failedAt, this.failureReasonCode, this.message);
        this.toString = "FailureReasons(failedAt=" + this.failedAt + ", failureReasonCode=" + this.failureReasonCode + ", message=" + this.message + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureReasons)) {
            return false;
        }
        FailureReasons that = (FailureReasons)obj;
        if (!this.failedAt.equals(that.failedAt)) {
            return false;
        }
        if (!this.failureReasonCode.equals(that.failureReasonCode)) {
            return false;
        }
        return this.message.equals(that.message);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OffsetDateTime failedAt = null;
        private FailureReasonCode failureReasonCode = null;
        private String message = null;

        private Builder() {
        }

        public Builder failedAt(OffsetDateTime failedAt) {
            this.failedAt = failedAt;
            return this;
        }

        public Builder failureReasonCode(FailureReasonCode failureReasonCode) {
            this.failureReasonCode = failureReasonCode;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public FailureReasons build() {
            return new FailureReasons(this);
        }
    }
}

