/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class CryptoOfflineMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.CRYPTO_OFFLINE;
    @NotNull
    public final String paymentOperatorCode;
    private final int hashCode;
    private final String toString;

    private CryptoOfflineMethod(Builder builder) {
        super(PAYMENT_METHOD_CODE);
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.hashCode = Objects.hash(new Object[]{this.paymentOperatorCode, this.paymentMethodCode});
        this.toString = "CryptoOfflineMethod(paymentOperatorCode=" + this.paymentOperatorCode + ", paymentMethodCode=" + (Object)((Object)this.paymentMethodCode) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CryptoOfflineMethod)) {
            return false;
        }
        CryptoOfflineMethod that = (CryptoOfflineMethod)obj;
        if (!this.paymentOperatorCode.equals(that.paymentOperatorCode)) {
            return false;
        }
        return this.paymentMethodCode.equals((Object)that.paymentMethodCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String paymentOperatorCode = null;

        private Builder() {
        }

        public Builder paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        public CryptoOfflineMethod build() {
            return new CryptoOfflineMethod(this);
        }
    }
}

