/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.PayinMethodCode;
import tech.carpentum.sdk.payment.model.PaymentOperator;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class AvailablePaymentOption {
    @NotNull
    public final PayinMethodCode paymentMethodCode;
    @NotNull
    public final @NotNull List<@NotNull PaymentOperator> paymentOperators;
    @NotNull
    public final Optional<SegmentCode> segmentCode;
    private final int hashCode;
    private final String toString;

    private AvailablePaymentOption(Builder builder) {
        this.paymentMethodCode = Objects.requireNonNull(builder.paymentMethodCode, "Property 'paymentMethodCode' is required.");
        this.paymentOperators = Collections.unmodifiableList(builder.paymentOperators);
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.hashCode = Objects.hash(this.paymentMethodCode, this.paymentOperators, this.segmentCode);
        this.toString = "AvailablePaymentOption(paymentMethodCode=" + this.paymentMethodCode + ", paymentOperators=" + this.paymentOperators + ", segmentCode=" + this.segmentCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailablePaymentOption)) {
            return false;
        }
        AvailablePaymentOption that = (AvailablePaymentOption)obj;
        if (!this.paymentMethodCode.equals(that.paymentMethodCode)) {
            return false;
        }
        if (!this.paymentOperators.equals(that.paymentOperators)) {
            return false;
        }
        return this.segmentCode.equals(that.segmentCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PayinMethodCode paymentMethodCode = null;
        private List<@NotNull PaymentOperator> paymentOperators = new ArrayList<PaymentOperator>();
        private SegmentCode segmentCode = null;

        private Builder() {
        }

        public Builder paymentMethodCode(PayinMethodCode paymentMethodCode) {
            this.paymentMethodCode = paymentMethodCode;
            return this;
        }

        public Builder paymentOperators(List<@NotNull PaymentOperator> paymentOperators) {
            this.paymentOperators.clear();
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        public Builder paymentOperatorsAdd(PaymentOperator item) {
            if (item != null) {
                this.paymentOperators.add(item);
            }
            return this;
        }

        public Builder paymentOperatorsAddAll(List<@NotNull PaymentOperator> paymentOperators) {
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        public Builder segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        public AvailablePaymentOption build() {
            return new AvailablePaymentOption(this);
        }
    }
}

