/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonClass(generateAdapter=false)
public class AuthTokenResponse {
    @NotNull
    public final String token;
    private final int hashCode;
    private final String toString;

    private AuthTokenResponse(Builder builder) {
        this.token = Objects.requireNonNull(builder.token, "Property 'token' is required.");
        this.hashCode = Objects.hash(this.token);
        this.toString = "AuthTokenResponse(token=" + this.token + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthTokenResponse)) {
            return false;
        }
        AuthTokenResponse that = (AuthTokenResponse)obj;
        return this.token.equals(that.token);
    }

    public String toString() {
        return this.toString;
    }

    public static AuthTokenResponse ofToken(String token) {
        return AuthTokenResponse.builder().token(token).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String token = null;

        private Builder() {
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public AuthTokenResponse build() {
            return new AuthTokenResponse(this);
        }
    }
}

