/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonClass(generateAdapter=false)
public class AccountPayinRequestOnline {
    @NotNull
    public final Optional<String> accountName;
    @NotNull
    public final Optional<String> accountNumber;
    private final int hashCode;
    private final String toString;

    private AccountPayinRequestOnline(Builder builder) {
        this.accountName = Optional.ofNullable(builder.accountName);
        this.accountNumber = Optional.ofNullable(builder.accountNumber);
        this.hashCode = Objects.hash(this.accountName, this.accountNumber);
        this.toString = "AccountPayinRequestOnline(accountName=" + this.accountName + ", accountNumber=" + this.accountNumber + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountPayinRequestOnline)) {
            return false;
        }
        AccountPayinRequestOnline that = (AccountPayinRequestOnline)obj;
        if (!this.accountName.equals(that.accountName)) {
            return false;
        }
        return this.accountNumber.equals(that.accountNumber);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String accountName = null;
        private String accountNumber = null;

        private Builder() {
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public AccountPayinRequestOnline build() {
            return new AccountPayinRequestOnline(this);
        }
    }
}

