/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.json;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.json.UpiQRMethodJson;
import tech.carpentum.sdk.payment.model.UpiQRMethod;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/json/UpiQRMethodJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/UpiQRMethod;", "json", "Ltech/carpentum/sdk/payment/internal/generated/json/UpiQRMethodJson;", "toJson", "model", "payment-client-v2"})
public final class UpiQRMethodJsonAdapter {
    @FromJson
    @NotNull
    public final UpiQRMethod fromJson(@NotNull UpiQRMethodJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        UpiQRMethod.Builder builder = UpiQRMethod.builder();
        builder.emailAddress(json.getEmailAddress());
        builder.paymentOperatorCode(json.getPaymentOperatorCode());
        UpiQRMethod upiQRMethod = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)upiQRMethod, (String)"builder.build()");
        return upiQRMethod;
    }

    @ToJson
    @NotNull
    public final UpiQRMethodJson toJson(@NotNull UpiQRMethod model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        UpiQRMethodJson json = new UpiQRMethodJson();
        json.setEmailAddress(model.emailAddress.orElse(null));
        json.setPaymentOperatorCode(model.paymentOperatorCode.orElse(null));
        json.setPaymentMethodCode(model.paymentMethodCode.name());
        return json;
    }
}

