/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PseMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountCustomerResponsePse;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public interface PseMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.PSE;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public AccountCustomerResponsePse getAccountCustomer();

    @NotNull
    public String getEmailAddress();

    @NotNull
    public String getPhoneNumber();

    @NotNull
    public MoneyPaymentResponse getMoney();

    @NotNull
    public Optional<MoneyVat> getVat();

    @NotNull
    public String getReference();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(PseMethodResponse copyOf) {
        Builder builder = PseMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.accountCustomer(copyOf.getAccountCustomer());
        builder.emailAddress(copyOf.getEmailAddress());
        builder.phoneNumber(copyOf.getPhoneNumber());
        builder.money(copyOf.getMoney());
        builder.vat(copyOf.getVat().orElse(null));
        builder.reference(copyOf.getReference());
        builder.returnUrl(copyOf.getReturnUrl());
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PseMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        public boolean isIdPayinDefined();

        @NotNull
        public Builder idPayment(IdPayment var1);

        public boolean isIdPaymentDefined();

        @NotNull
        public Builder accountCustomer(AccountCustomerResponsePse var1);

        public boolean isAccountCustomerDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public Builder money(MoneyPaymentResponse var1);

        public boolean isMoneyDefined();

        @NotNull
        public Builder vat(MoneyVat var1);

        public boolean isVatDefined();

        @NotNull
        public Builder reference(String var1);

        public boolean isReferenceDefined();

        @NotNull
        public Builder returnUrl(String var1);

        public boolean isReturnUrlDefined();

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        public boolean isAcceptedAtDefined();

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        public boolean isExpireAtDefined();

        @NotNull
        public PseMethodResponse build();
    }
}

