/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PseMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestPse;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface PseMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.PSE;

    @NotNull
    public AccountPayinRequestPse getAccount();

    @NotNull
    public String getEmailAddress();

    @NotNull
    public String getPhoneNumber();

    @NotNull
    public static Builder builder(PseMethod copyOf) {
        Builder builder = PseMethod.builder();
        builder.account(copyOf.getAccount());
        builder.emailAddress(copyOf.getEmailAddress());
        builder.phoneNumber(copyOf.getPhoneNumber());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PseMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestPse var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public PseMethod build();
    }
}

