/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.EWalletMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestEWallet;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface EWalletMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.EWALLET;

    @NotNull
    public Optional<AccountPayinRequestEWallet> getAccount();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public String getPaymentOperatorCode();

    @NotNull
    public static Builder builder(EWalletMethod copyOf) {
        Builder builder = EWalletMethod.builder();
        builder.account(copyOf.getAccount().orElse(null));
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new EWalletMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestEWallet var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public EWalletMethod build();
    }
}

