/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseOffline;
import tech.carpentum.sdk.payment.model.AccountResponseOffline;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyRequired;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.OfflineMethodResponse;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentProcessor;
import tech.carpentum.sdk.payment.model.SelectedPaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public class OfflineMethodResponseImpl
implements OfflineMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final AccountResponseOffline account;
    private final AccountCustomerResponseOffline accountCustomer;
    private final MoneyPaymentResponse money;
    private final Optional<MoneyRequired> moneyRequired;
    private final Optional<MoneyVat> vat;
    private final String reference;
    private final Optional<PaymentProcessor> processor;
    private final Optional<String> qrName;
    private final Optional<String> qrCode;
    private final String returnUrl;
    private final Optional<SelectedPaymentOperatorIncoming> paymentOperator;
    private final Optional<String> phoneNumber;
    private final Optional<String> emailAddress;
    private final Optional<String> productId;
    private final Optional<String> taxId;
    private final Optional<String> taxIdCustomer;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public AccountResponseOffline getAccount() {
        return this.account;
    }

    @Override
    public AccountCustomerResponseOffline getAccountCustomer() {
        return this.accountCustomer;
    }

    @Override
    public MoneyPaymentResponse getMoney() {
        return this.money;
    }

    @Override
    public Optional<MoneyRequired> getMoneyRequired() {
        return this.moneyRequired;
    }

    @Override
    public Optional<MoneyVat> getVat() {
        return this.vat;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public Optional<PaymentProcessor> getProcessor() {
        return this.processor;
    }

    @Override
    public Optional<String> getQrName() {
        return this.qrName;
    }

    @Override
    public Optional<String> getQrCode() {
        return this.qrCode;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public Optional<SelectedPaymentOperatorIncoming> getPaymentOperator() {
        return this.paymentOperator;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getProductId() {
        return this.productId;
    }

    @Override
    public Optional<String> getTaxId() {
        return this.taxId;
    }

    @Override
    public Optional<String> getTaxIdCustomer() {
        return this.taxIdCustomer;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private OfflineMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.accountCustomer = Objects.requireNonNull(builder.accountCustomer, "Property 'accountCustomer' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.moneyRequired = Optional.ofNullable(builder.moneyRequired);
        this.vat = Optional.ofNullable(builder.vat);
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.processor = Optional.ofNullable(builder.processor);
        this.qrName = Optional.ofNullable(builder.qrName);
        this.qrCode = Optional.ofNullable(builder.qrCode);
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.paymentOperator = Optional.ofNullable(builder.paymentOperator);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.productId = Optional.ofNullable(builder.productId);
        this.taxId = Optional.ofNullable(builder.taxId);
        this.taxIdCustomer = Optional.ofNullable(builder.taxIdCustomer);
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.account, this.accountCustomer, this.money, this.moneyRequired, this.vat, this.reference, this.processor, this.qrName, this.qrCode, this.returnUrl, this.paymentOperator, this.phoneNumber, this.emailAddress, this.productId, this.taxId, this.taxIdCustomer, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", account=" + this.account + ", accountCustomer=" + this.accountCustomer + ", money=" + this.money + ", moneyRequired=" + this.moneyRequired + ", vat=" + this.vat + ", reference=" + this.reference + ", processor=" + this.processor + ", qrName=" + this.qrName + ", qrCode=" + this.qrCode + ", returnUrl=" + this.returnUrl + ", paymentOperator=" + this.paymentOperator + ", phoneNumber=" + this.phoneNumber + ", emailAddress=" + this.emailAddress + ", productId=" + this.productId + ", taxId=" + this.taxId + ", taxIdCustomer=" + this.taxIdCustomer + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfflineMethodResponseImpl)) {
            return false;
        }
        OfflineMethodResponseImpl that = (OfflineMethodResponseImpl)obj;
        if (!Objects.equals(this.idPayin, that.idPayin)) {
            return false;
        }
        if (!Objects.equals(this.idPayment, that.idPayment)) {
            return false;
        }
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.accountCustomer, that.accountCustomer)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.moneyRequired, that.moneyRequired)) {
            return false;
        }
        if (!Objects.equals(this.vat, that.vat)) {
            return false;
        }
        if (!Objects.equals(this.reference, that.reference)) {
            return false;
        }
        if (!Objects.equals(this.processor, that.processor)) {
            return false;
        }
        if (!Objects.equals(this.qrName, that.qrName)) {
            return false;
        }
        if (!Objects.equals(this.qrCode, that.qrCode)) {
            return false;
        }
        if (!Objects.equals(this.returnUrl, that.returnUrl)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperator, that.paymentOperator)) {
            return false;
        }
        if (!Objects.equals(this.phoneNumber, that.phoneNumber)) {
            return false;
        }
        if (!Objects.equals(this.emailAddress, that.emailAddress)) {
            return false;
        }
        if (!Objects.equals(this.productId, that.productId)) {
            return false;
        }
        if (!Objects.equals(this.taxId, that.taxId)) {
            return false;
        }
        if (!Objects.equals(this.taxIdCustomer, that.taxIdCustomer)) {
            return false;
        }
        if (!Objects.equals(this.acceptedAt, that.acceptedAt)) {
            return false;
        }
        return Objects.equals(this.expireAt, that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements OfflineMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private AccountResponseOffline account = null;
        private AccountCustomerResponseOffline accountCustomer = null;
        private MoneyPaymentResponse money = null;
        private MoneyRequired moneyRequired = null;
        private MoneyVat vat = null;
        private String reference = null;
        private PaymentProcessor processor = null;
        private String qrName = null;
        private String qrCode = null;
        private String returnUrl = null;
        private SelectedPaymentOperatorIncoming paymentOperator = null;
        private String phoneNumber = null;
        private String emailAddress = null;
        private String productId = null;
        private String taxId = null;
        private String taxIdCustomer = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("OfflineMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public boolean isIdPayinDefined() {
            return this.idPayin != null;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public boolean isIdPaymentDefined() {
            return this.idPayment != null;
        }

        @Override
        public BuilderImpl account(AccountResponseOffline account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl accountCustomer(AccountCustomerResponseOffline accountCustomer) {
            this.accountCustomer = accountCustomer;
            return this;
        }

        @Override
        public boolean isAccountCustomerDefined() {
            return this.accountCustomer != null;
        }

        @Override
        public BuilderImpl money(MoneyPaymentResponse money) {
            this.money = money;
            return this;
        }

        @Override
        public boolean isMoneyDefined() {
            return this.money != null;
        }

        @Override
        public BuilderImpl moneyRequired(MoneyRequired moneyRequired) {
            this.moneyRequired = moneyRequired;
            return this;
        }

        @Override
        public boolean isMoneyRequiredDefined() {
            return this.moneyRequired != null;
        }

        @Override
        public BuilderImpl vat(MoneyVat vat) {
            this.vat = vat;
            return this;
        }

        @Override
        public boolean isVatDefined() {
            return this.vat != null;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public boolean isReferenceDefined() {
            return this.reference != null;
        }

        @Override
        public BuilderImpl processor(PaymentProcessor processor) {
            this.processor = processor;
            return this;
        }

        @Override
        public boolean isProcessorDefined() {
            return this.processor != null;
        }

        @Override
        public BuilderImpl qrName(String qrName) {
            this.qrName = qrName;
            return this;
        }

        @Override
        public boolean isQrNameDefined() {
            return this.qrName != null;
        }

        @Override
        public BuilderImpl qrCode(String qrCode) {
            this.qrCode = qrCode;
            return this;
        }

        @Override
        public boolean isQrCodeDefined() {
            return this.qrCode != null;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public boolean isReturnUrlDefined() {
            return this.returnUrl != null;
        }

        @Override
        public BuilderImpl paymentOperator(SelectedPaymentOperatorIncoming paymentOperator) {
            this.paymentOperator = paymentOperator;
            return this;
        }

        @Override
        public boolean isPaymentOperatorDefined() {
            return this.paymentOperator != null;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public boolean isPhoneNumberDefined() {
            return this.phoneNumber != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public BuilderImpl productId(String productId) {
            this.productId = productId;
            return this;
        }

        @Override
        public boolean isProductIdDefined() {
            return this.productId != null;
        }

        @Override
        public BuilderImpl taxId(String taxId) {
            this.taxId = taxId;
            return this;
        }

        @Override
        public boolean isTaxIdDefined() {
            return this.taxId != null;
        }

        @Override
        public BuilderImpl taxIdCustomer(String taxIdCustomer) {
            this.taxIdCustomer = taxIdCustomer;
            return this;
        }

        @Override
        public boolean isTaxIdCustomerDefined() {
            return this.taxIdCustomer != null;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public boolean isAcceptedAtDefined() {
            return this.acceptedAt != null;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public boolean isExpireAtDefined() {
            return this.expireAt != null;
        }

        @Override
        public OfflineMethodResponseImpl build() {
            return new OfflineMethodResponseImpl(this);
        }
    }
}

