/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.VaPayMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestVaPay;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface VaPayMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.VAPAY;

    @NotNull
    public Optional<AccountPayinRequestVaPay> getAccount();

    @NotNull
    public Optional<String> getPaymentOperatorCode();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public static Builder builder(VaPayMethod copyOf) {
        Builder builder = VaPayMethod.builder();
        builder.account(copyOf.getAccount().orElse(null));
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode().orElse(null));
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new VaPayMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestVaPay var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public VaPayMethod build();
    }
}

