/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AccountResponseOfflineImpl;
import tech.carpentum.sdk.payment.model.AccountResponseWithBank;

@JsonClass(generateAdapter=false)
public interface AccountResponseOffline
extends AccountResponseWithBank {
    @Override
    @NotNull
    public String getAccountName();

    @Override
    @NotNull
    public String getAccountNumber();

    @NotNull
    public Optional<String> getAccountType();

    @Override
    @NotNull
    public Optional<String> getBankCode();

    @Override
    @NotNull
    public Optional<String> getBankName();

    @Override
    @NotNull
    public Optional<String> getBankBranch();

    @Override
    @NotNull
    public Optional<String> getBankCity();

    @Override
    @NotNull
    public Optional<String> getBankProvince();

    @NotNull
    public static Builder builder(AccountResponseOffline copyOf) {
        Builder builder = AccountResponseOffline.builder();
        builder.accountName(copyOf.getAccountName());
        builder.accountNumber(copyOf.getAccountNumber());
        builder.accountType(copyOf.getAccountType().orElse(null));
        builder.bankCode(copyOf.getBankCode().orElse(null));
        builder.bankName(copyOf.getBankName().orElse(null));
        builder.bankBranch(copyOf.getBankBranch().orElse(null));
        builder.bankCity(copyOf.getBankCity().orElse(null));
        builder.bankProvince(copyOf.getBankProvince().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new AccountResponseOfflineImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder accountName(String var1);

        public boolean isAccountNameDefined();

        @NotNull
        public Builder accountNumber(String var1);

        public boolean isAccountNumberDefined();

        @NotNull
        public Builder accountType(String var1);

        public boolean isAccountTypeDefined();

        @NotNull
        public Builder bankCode(String var1);

        public boolean isBankCodeDefined();

        @NotNull
        public Builder bankName(String var1);

        public boolean isBankNameDefined();

        @NotNull
        public Builder bankBranch(String var1);

        public boolean isBankBranchDefined();

        @NotNull
        public Builder bankCity(String var1);

        public boolean isBankCityDefined();

        @NotNull
        public Builder bankProvince(String var1);

        public boolean isBankProvinceDefined();

        @NotNull
        public AccountResponseOffline build();
    }
}

