/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.VaPayMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseVaPay;
import tech.carpentum.sdk.payment.model.AccountResponseWithBank;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentInstruction;
import tech.carpentum.sdk.payment.model.SelectedPaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public interface VaPayMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.VAPAY;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public AccountResponseWithBank getAccount();

    @NotNull
    public AccountCustomerResponseVaPay getAccountCustomer();

    @NotNull
    public MoneyPaymentResponse getMoney();

    @NotNull
    public Optional<MoneyVat> getVat();

    @NotNull
    public String getReference();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public Optional<SelectedPaymentOperatorIncoming> getPaymentOperator();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public @NotNull List<@NotNull PaymentInstruction> getPaymentInstructionList();

    @NotNull
    public static Builder builder(VaPayMethodResponse copyOf) {
        Builder builder = VaPayMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.account(copyOf.getAccount());
        builder.accountCustomer(copyOf.getAccountCustomer());
        builder.money(copyOf.getMoney());
        builder.vat(copyOf.getVat().orElse(null));
        builder.reference(copyOf.getReference());
        builder.returnUrl(copyOf.getReturnUrl());
        builder.paymentOperator(copyOf.getPaymentOperator().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        builder.paymentInstructionList(copyOf.getPaymentInstructionList());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new VaPayMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        public boolean isIdPayinDefined();

        @NotNull
        public Builder idPayment(IdPayment var1);

        public boolean isIdPaymentDefined();

        @NotNull
        public Builder account(AccountResponseWithBank var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder accountCustomer(AccountCustomerResponseVaPay var1);

        public boolean isAccountCustomerDefined();

        @NotNull
        public Builder money(MoneyPaymentResponse var1);

        public boolean isMoneyDefined();

        @NotNull
        public Builder vat(MoneyVat var1);

        public boolean isVatDefined();

        @NotNull
        public Builder reference(String var1);

        public boolean isReferenceDefined();

        @NotNull
        public Builder returnUrl(String var1);

        public boolean isReturnUrlDefined();

        @NotNull
        public Builder paymentOperator(SelectedPaymentOperatorIncoming var1);

        public boolean isPaymentOperatorDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        public boolean isAcceptedAtDefined();

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        public boolean isExpireAtDefined();

        @NotNull
        public Builder paymentInstructionList(List<@NotNull PaymentInstruction> var1);

        @NotNull
        public Builder paymentInstructionListAdd(PaymentInstruction var1);

        @NotNull
        public Builder paymentInstructionListAddAll(List<@NotNull PaymentInstruction> var1);

        @NotNull
        public VaPayMethodResponse build();
    }
}

