/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PhoneNumberTransferMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestPhoneNumberTransfer;
import tech.carpentum.sdk.payment.model.IdentifyingReference;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public interface PhoneNumberTransferMethod
extends PayoutMethod {
    public static final PayoutMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayoutMethod.PaymentMethodCode.PHONE_NUMBER_TRANSFER;

    @NotNull
    public String getPhoneNumber();

    @NotNull
    public Optional<AccountPayoutRequestPhoneNumberTransfer> getAccount();

    @NotNull
    public IdentifyingReference getIdentifyingReference();

    @NotNull
    public static Builder builder(PhoneNumberTransferMethod copyOf) {
        Builder builder = PhoneNumberTransferMethod.builder();
        builder.phoneNumber(copyOf.getPhoneNumber());
        builder.account(copyOf.getAccount().orElse(null));
        builder.identifyingReference(copyOf.getIdentifyingReference());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PhoneNumberTransferMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public Builder account(AccountPayoutRequestPhoneNumberTransfer var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder identifyingReference(IdentifyingReference var1);

        public boolean isIdentifyingReferenceDefined();

        @NotNull
        public PhoneNumberTransferMethod build();
    }
}

