/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AuthTokenAction;
import tech.carpentum.sdk.payment.model.AuthTokenByActionRequest;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.SettlementMethod;

@JsonClass(generateAdapter=false)
public class AuthTokenByActionRequestImpl
implements AuthTokenByActionRequest {
    private final String merchantCode;
    private final Optional<String> secret;
    private final Optional<Integer> validitySecs;
    private final AuthTokenAction action;
    private final String idPayment;
    private final Optional<Money> money;
    private final Optional<Money> moneyProvided;
    private final Optional<CurrencyCode> currencyCodeRequired;
    private final Optional<Money> moneyRequired;
    private final Optional<CurrencyCode> currencyCodeProvided;
    private final Optional<SettlementMethod> settlementMethod;
    private final int hashCode;
    private final String toString;

    @Override
    public String getMerchantCode() {
        return this.merchantCode;
    }

    @Override
    public Optional<String> getSecret() {
        return this.secret;
    }

    @Override
    public Optional<Integer> getValiditySecs() {
        return this.validitySecs;
    }

    @Override
    public AuthTokenAction getAction() {
        return this.action;
    }

    @Override
    public String getIdPayment() {
        return this.idPayment;
    }

    @Override
    public Optional<Money> getMoney() {
        return this.money;
    }

    @Override
    public Optional<Money> getMoneyProvided() {
        return this.moneyProvided;
    }

    @Override
    public Optional<CurrencyCode> getCurrencyCodeRequired() {
        return this.currencyCodeRequired;
    }

    @Override
    public Optional<Money> getMoneyRequired() {
        return this.moneyRequired;
    }

    @Override
    public Optional<CurrencyCode> getCurrencyCodeProvided() {
        return this.currencyCodeProvided;
    }

    @Override
    public Optional<SettlementMethod> getSettlementMethod() {
        return this.settlementMethod;
    }

    private AuthTokenByActionRequestImpl(BuilderImpl builder) {
        this.merchantCode = Objects.requireNonNull(builder.merchantCode, "Property 'merchantCode' is required.");
        this.secret = Optional.ofNullable(builder.secret);
        this.validitySecs = Optional.ofNullable(builder.validitySecs);
        this.action = Objects.requireNonNull(builder.action, "Property 'action' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.money = Optional.ofNullable(builder.money);
        this.moneyProvided = Optional.ofNullable(builder.moneyProvided);
        this.currencyCodeRequired = Optional.ofNullable(builder.currencyCodeRequired);
        this.moneyRequired = Optional.ofNullable(builder.moneyRequired);
        this.currencyCodeProvided = Optional.ofNullable(builder.currencyCodeProvided);
        this.settlementMethod = Optional.ofNullable(builder.settlementMethod);
        this.hashCode = Objects.hash(this.merchantCode, this.secret, this.validitySecs, this.action, this.idPayment, this.money, this.moneyProvided, this.currencyCodeRequired, this.moneyRequired, this.currencyCodeProvided, this.settlementMethod);
        this.toString = builder.type + "(merchantCode=" + this.merchantCode + ", secret=" + this.secret + ", validitySecs=" + this.validitySecs + ", action=" + this.action + ", idPayment=" + this.idPayment + ", money=" + this.money + ", moneyProvided=" + this.moneyProvided + ", currencyCodeRequired=" + this.currencyCodeRequired + ", moneyRequired=" + this.moneyRequired + ", currencyCodeProvided=" + this.currencyCodeProvided + ", settlementMethod=" + this.settlementMethod + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthTokenByActionRequestImpl)) {
            return false;
        }
        AuthTokenByActionRequestImpl that = (AuthTokenByActionRequestImpl)obj;
        if (!Objects.equals(this.merchantCode, that.merchantCode)) {
            return false;
        }
        if (!Objects.equals(this.secret, that.secret)) {
            return false;
        }
        if (!Objects.equals(this.validitySecs, that.validitySecs)) {
            return false;
        }
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.idPayment, that.idPayment)) {
            return false;
        }
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.moneyProvided, that.moneyProvided)) {
            return false;
        }
        if (!Objects.equals(this.currencyCodeRequired, that.currencyCodeRequired)) {
            return false;
        }
        if (!Objects.equals(this.moneyRequired, that.moneyRequired)) {
            return false;
        }
        if (!Objects.equals(this.currencyCodeProvided, that.currencyCodeProvided)) {
            return false;
        }
        return Objects.equals(this.settlementMethod, that.settlementMethod);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AuthTokenByActionRequest.Builder {
        private String merchantCode = null;
        private String secret = null;
        private Integer validitySecs = null;
        private AuthTokenAction action = null;
        private String idPayment = null;
        private Money money = null;
        private Money moneyProvided = null;
        private CurrencyCode currencyCodeRequired = null;
        private Money moneyRequired = null;
        private CurrencyCode currencyCodeProvided = null;
        private SettlementMethod settlementMethod = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AuthTokenByActionRequest");
        }

        @Override
        public BuilderImpl merchantCode(String merchantCode) {
            this.merchantCode = merchantCode;
            return this;
        }

        @Override
        public boolean isMerchantCodeDefined() {
            return this.merchantCode != null;
        }

        @Override
        public BuilderImpl secret(String secret) {
            this.secret = secret;
            return this;
        }

        @Override
        public boolean isSecretDefined() {
            return this.secret != null;
        }

        @Override
        public BuilderImpl validitySecs(Integer validitySecs) {
            this.validitySecs = validitySecs;
            return this;
        }

        @Override
        public boolean isValiditySecsDefined() {
            return this.validitySecs != null;
        }

        @Override
        public BuilderImpl action(AuthTokenAction action) {
            this.action = action;
            return this;
        }

        @Override
        public boolean isActionDefined() {
            return this.action != null;
        }

        @Override
        public BuilderImpl idPayment(String idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public boolean isIdPaymentDefined() {
            return this.idPayment != null;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public boolean isMoneyDefined() {
            return this.money != null;
        }

        @Override
        public BuilderImpl moneyProvided(Money moneyProvided) {
            this.moneyProvided = moneyProvided;
            return this;
        }

        @Override
        public boolean isMoneyProvidedDefined() {
            return this.moneyProvided != null;
        }

        @Override
        public BuilderImpl currencyCodeRequired(CurrencyCode currencyCodeRequired) {
            this.currencyCodeRequired = currencyCodeRequired;
            return this;
        }

        @Override
        public boolean isCurrencyCodeRequiredDefined() {
            return this.currencyCodeRequired != null;
        }

        @Override
        public BuilderImpl moneyRequired(Money moneyRequired) {
            this.moneyRequired = moneyRequired;
            return this;
        }

        @Override
        public boolean isMoneyRequiredDefined() {
            return this.moneyRequired != null;
        }

        @Override
        public BuilderImpl currencyCodeProvided(CurrencyCode currencyCodeProvided) {
            this.currencyCodeProvided = currencyCodeProvided;
            return this;
        }

        @Override
        public boolean isCurrencyCodeProvidedDefined() {
            return this.currencyCodeProvided != null;
        }

        @Override
        public BuilderImpl settlementMethod(SettlementMethod settlementMethod) {
            this.settlementMethod = settlementMethod;
            return this;
        }

        @Override
        public boolean isSettlementMethodDefined() {
            return this.settlementMethod != null;
        }

        @Override
        public AuthTokenByActionRequestImpl build() {
            return new AuthTokenByActionRequestImpl(this);
        }
    }
}

