/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AuthTokenRequestImpl;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.SettlementMethod;

@JsonClass(generateAdapter=false)
public interface AuthTokenRequest {
    @NotNull
    public String getMerchantCode();

    @NotNull
    public Optional<String> getSecret();

    @NotNull
    public Optional<Integer> getValiditySecs();

    @NotNull
    public @NotNull List<@NotNull String> getOperations();

    @NotNull
    public Optional<Money> getMoney();

    @NotNull
    public Optional<Money> getMoneyProvided();

    @NotNull
    public Optional<CurrencyCode> getCurrencyCodeRequired();

    @NotNull
    public Optional<Money> getMoneyRequired();

    @NotNull
    public Optional<CurrencyCode> getCurrencyCodeProvided();

    @NotNull
    public Optional<SettlementMethod> getSettlementMethod();

    @NotNull
    public static Builder builder(AuthTokenRequest copyOf) {
        Builder builder = AuthTokenRequest.builder();
        builder.merchantCode(copyOf.getMerchantCode());
        builder.secret(copyOf.getSecret().orElse(null));
        builder.validitySecs(copyOf.getValiditySecs().orElse(null));
        builder.operations(copyOf.getOperations());
        builder.money(copyOf.getMoney().orElse(null));
        builder.moneyProvided(copyOf.getMoneyProvided().orElse(null));
        builder.currencyCodeRequired(copyOf.getCurrencyCodeRequired().orElse(null));
        builder.moneyRequired(copyOf.getMoneyRequired().orElse(null));
        builder.currencyCodeProvided(copyOf.getCurrencyCodeProvided().orElse(null));
        builder.settlementMethod(copyOf.getSettlementMethod().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new AuthTokenRequestImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder merchantCode(String var1);

        public boolean isMerchantCodeDefined();

        @NotNull
        public Builder secret(String var1);

        public boolean isSecretDefined();

        @NotNull
        public Builder validitySecs(Integer var1);

        public boolean isValiditySecsDefined();

        @NotNull
        public Builder operations(List<@NotNull String> var1);

        @NotNull
        public Builder operationsAdd(String var1);

        @NotNull
        public Builder operationsAddAll(List<@NotNull String> var1);

        @NotNull
        public Builder money(Money var1);

        public boolean isMoneyDefined();

        @NotNull
        public Builder moneyProvided(Money var1);

        public boolean isMoneyProvidedDefined();

        @NotNull
        public Builder currencyCodeRequired(CurrencyCode var1);

        public boolean isCurrencyCodeRequiredDefined();

        @NotNull
        public Builder moneyRequired(Money var1);

        public boolean isMoneyRequiredDefined();

        @NotNull
        public Builder currencyCodeProvided(CurrencyCode var1);

        public boolean isCurrencyCodeProvidedDefined();

        @NotNull
        public Builder settlementMethod(SettlementMethod var1);

        public boolean isSettlementMethodDefined();

        @NotNull
        public AuthTokenRequest build();
    }
}

