/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AuthTokenRequestImpl;
import tech.carpentum.sdk.payment.internal.generated.model.AuthTokenRequestJson;
import tech.carpentum.sdk.payment.model.AuthTokenRequest;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/model/AuthTokenRequestJsonAdapter;", "", "<init>", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/AuthTokenRequest;", "json", "Ltech/carpentum/sdk/payment/internal/generated/model/AuthTokenRequestJson;", "toJson", "model", "fromJsonImpl", "Ltech/carpentum/sdk/payment/internal/generated/model/AuthTokenRequestImpl;", "toJsonImpl", "impl", "payment-client-v2"})
@SourceDebugExtension(value={"SMAP\nAuthTokenRequestJsonAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthTokenRequestJsonAdapter.kt\ntech/carpentum/sdk/payment/internal/generated/model/AuthTokenRequestJsonAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class AuthTokenRequestJsonAdapter {
    @FromJson
    @NotNull
    public final AuthTokenRequest fromJson(@NotNull AuthTokenRequestJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        AuthTokenRequest.Builder builder = AuthTokenRequest.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        AuthTokenRequest.Builder builder2 = builder;
        builder2.merchantCode(json.getMerchantCode());
        builder2.secret(json.getSecret());
        builder2.validitySecs(json.getValiditySecs());
        List<String> list = json.getOperations();
        builder2.operations(list != null ? CollectionsKt.toList((Iterable)list) : null);
        builder2.money(json.getMoney());
        builder2.moneyProvided(json.getMoneyProvided());
        builder2.currencyCodeRequired(json.getCurrencyCodeRequired());
        builder2.moneyRequired(json.getMoneyRequired());
        builder2.currencyCodeProvided(json.getCurrencyCodeProvided());
        builder2.settlementMethod(json.getSettlementMethod());
        AuthTokenRequest authTokenRequest = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)authTokenRequest, (String)"build(...)");
        return authTokenRequest;
    }

    @ToJson
    @NotNull
    public final AuthTokenRequestJson toJson(@NotNull AuthTokenRequest model) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        AuthTokenRequestJson json = new AuthTokenRequestJson();
        json.setMerchantCode(model.getMerchantCode());
        json.setSecret(model.getSecret().orElse(null));
        json.setValiditySecs(model.getValiditySecs().orElse(null));
        AuthTokenRequestJson authTokenRequestJson = json;
        Collection collection2 = model.getOperations();
        if (collection2.isEmpty()) {
            AuthTokenRequestJson authTokenRequestJson2 = authTokenRequestJson;
            boolean bl = false;
            collection = null;
            authTokenRequestJson = authTokenRequestJson2;
        } else {
            collection = collection2;
        }
        authTokenRequestJson.setOperations((List)collection);
        json.setMoney(model.getMoney().orElse(null));
        json.setMoneyProvided(model.getMoneyProvided().orElse(null));
        json.setCurrencyCodeRequired(model.getCurrencyCodeRequired().orElse(null));
        json.setMoneyRequired(model.getMoneyRequired().orElse(null));
        json.setCurrencyCodeProvided(model.getCurrencyCodeProvided().orElse(null));
        json.setSettlementMethod(model.getSettlementMethod().orElse(null));
        return json;
    }

    @FromJson
    @NotNull
    public final AuthTokenRequestImpl fromJsonImpl(@NotNull AuthTokenRequest model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (AuthTokenRequestImpl)model;
    }

    @ToJson
    @NotNull
    public final AuthTokenRequest toJsonImpl(@NotNull AuthTokenRequestImpl impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        return impl;
    }
}

