/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.CryptoTransferMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestCryptoTransfer;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public interface CryptoTransferMethod
extends PayoutMethod {
    public static final PayoutMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayoutMethod.PaymentMethodCode.CRYPTO_TRANSFER;

    @NotNull
    public AccountPayoutRequestCryptoTransfer getAccount();

    @NotNull
    public String getPaymentOperatorCode();

    @NotNull
    public Optional<String> getRemark();

    @NotNull
    public static Builder builder(CryptoTransferMethod copyOf) {
        Builder builder = CryptoTransferMethod.builder();
        builder.account(copyOf.getAccount());
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode());
        builder.remark(copyOf.getRemark().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new CryptoTransferMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayoutRequestCryptoTransfer var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public Builder remark(String var1);

        public boolean isRemarkDefined();

        @NotNull
        public CryptoTransferMethod build();
    }
}

