/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestPayShap;
import tech.carpentum.sdk.payment.model.PayShapMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class PayShapMethodImpl
implements PayShapMethod {
    private final Optional<AccountPayinRequestPayShap> account;
    private final Optional<String> phoneNumber;
    private final String paymentOperatorCode;
    private final Optional<String> externalProviderCode;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<AccountPayinRequestPayShap> getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public Optional<String> getExternalProviderCode() {
        return this.externalProviderCode;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private PayShapMethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.externalProviderCode = Optional.ofNullable(builder.externalProviderCode);
        this.hashCode = Objects.hash(this.account, this.phoneNumber, this.paymentOperatorCode, this.externalProviderCode);
        this.toString = builder.type + "(account=" + this.account + ", phoneNumber=" + this.phoneNumber + ", paymentOperatorCode=" + this.paymentOperatorCode + ", externalProviderCode=" + this.externalProviderCode + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayShapMethodImpl)) {
            return false;
        }
        PayShapMethodImpl that = (PayShapMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.phoneNumber, that.phoneNumber)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode)) {
            return false;
        }
        return Objects.equals(this.externalProviderCode, that.externalProviderCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PayShapMethod.Builder {
        private AccountPayinRequestPayShap account = null;
        private String phoneNumber = null;
        private String paymentOperatorCode = null;
        private String externalProviderCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PayShapMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestPayShap account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public boolean isPhoneNumberDefined() {
            return this.phoneNumber != null;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public boolean isPaymentOperatorCodeDefined() {
            return this.paymentOperatorCode != null;
        }

        @Override
        public BuilderImpl externalProviderCode(String externalProviderCode) {
            this.externalProviderCode = externalProviderCode;
            return this;
        }

        @Override
        public boolean isExternalProviderCodeDefined() {
            return this.externalProviderCode != null;
        }

        @Override
        public PayShapMethodImpl build() {
            return new PayShapMethodImpl(this);
        }
    }
}

