/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.VaPayVerifMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestVaPayVerif;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface VaPayVerifMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.VAPAY_VERIF;

    @NotNull
    public AccountPayinRequestVaPayVerif getAccount();

    @NotNull
    public String getPaymentOperatorCode();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public static Builder builder(VaPayVerifMethod copyOf) {
        Builder builder = VaPayVerifMethod.builder();
        builder.account(copyOf.getAccount());
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode());
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new VaPayVerifMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestVaPayVerif var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public VaPayVerifMethod build();
    }
}

