/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PaymentOperatorIncomingImpl;
import tech.carpentum.sdk.payment.model.ExternalProviders;

@JsonClass(generateAdapter=false)
public interface PaymentOperatorIncoming {
    @NotNull
    public String getCode();

    @NotNull
    public String getName();

    @NotNull
    public Optional<ExternalProviders> getExternalProviders();

    @NotNull
    public static Builder builder(PaymentOperatorIncoming copyOf) {
        Builder builder = PaymentOperatorIncoming.builder();
        builder.code(copyOf.getCode());
        builder.name(copyOf.getName());
        builder.externalProviders(copyOf.getExternalProviders().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PaymentOperatorIncomingImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder code(String var1);

        public boolean isCodeDefined();

        @NotNull
        public Builder name(String var1);

        public boolean isNameDefined();

        @NotNull
        public Builder externalProviders(ExternalProviders var1);

        public boolean isExternalProvidersDefined();

        @NotNull
        public PaymentOperatorIncoming build();
    }
}

