/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.io.InterruptedIOException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.EnhancedRateListsApi;
import tech.carpentum.sdk.payment.internal.api.GetFxRatesErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.AvailableForexCurrencyPairList;
import tech.carpentum.sdk.payment.model.ForexRateList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ.\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ltech/carpentum/sdk/payment/RateListsApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedRateListsApi;", "<init>", "(ILtech/carpentum/sdk/payment/internal/api/EnhancedRateListsApi;)V", "getFxRatePairs", "Ltech/carpentum/sdk/payment/model/AvailableForexCurrencyPairList;", "tenantCode", "", "merchantCode", "getFxRates", "Ltech/carpentum/sdk/payment/model/ForexRateList;", "baseCurrencyCode", "quoteCurrencyCode", "Factory", "payment-client-v2"})
public final class RateListsApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    private final int apiVersion;
    @NotNull
    private final EnhancedRateListsApi api;

    private RateListsApi(int apiVersion, EnhancedRateListsApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @NotNull
    public final AvailableForexCurrencyPairList getFxRatePairs(@NotNull String tenantCode, @NotNull String merchantCode) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)tenantCode, (String)"tenantCode");
        Intrinsics.checkNotNullParameter((Object)merchantCode, (String)"merchantCode");
        return this.api.getFxRatePairs(this.apiVersion, tenantCode, merchantCode);
    }

    @NotNull
    public final ForexRateList getFxRates(@NotNull String tenantCode, @NotNull String merchantCode, @Nullable String baseCurrencyCode, @Nullable String quoteCurrencyCode) throws ResponseException, InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)tenantCode, (String)"tenantCode");
        Intrinsics.checkNotNullParameter((Object)merchantCode, (String)"merchantCode");
        return (ForexRateList)ResponseExceptionUtils.INSTANCE.wrap(GetFxRatesErrorExceptionFactory.Companion.getInstance(), () -> RateListsApi.getFxRates$lambda$0(this, tenantCode, merchantCode, baseCurrencyCode, quoteCurrencyCode));
    }

    public static /* synthetic */ ForexRateList getFxRates$default(RateListsApi rateListsApi, String string, String string2, String string3, String string4, int n, Object object) throws ResponseException, InterruptedIOException {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        return rateListsApi.getFxRates(string, string2, string3, string4);
    }

    private static final ForexRateList getFxRates$lambda$0(RateListsApi this$0, String $tenantCode, String $merchantCode, String $baseCurrencyCode, String $quoteCurrencyCode) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tenantCode, (String)"$tenantCode");
        Intrinsics.checkNotNullParameter((Object)$merchantCode, (String)"$merchantCode");
        return this$0.api.getFxRates(this$0.apiVersion, $tenantCode, $merchantCode, $baseCurrencyCode, $quoteCurrencyCode);
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineGetFxRatePairsEndpoint() {
        return Factory.defineGetFxRatePairsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineGetFxRatesEndpoint() {
        return Factory.defineGetFxRatesEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RateListsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RateListsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public /* synthetic */ RateListsApi(int apiVersion, EnhancedRateListsApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Ltech/carpentum/sdk/payment/RateListsApi$Factory;", "", "<init>", "()V", "defineGetFxRatePairsEndpoint", "Ltech/carpentum/sdk/payment/EndpointDefinition;", "defineGetFxRatesEndpoint", "create", "Ltech/carpentum/sdk/payment/RateListsApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineGetFxRatePairsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/fx-rate-pairs");
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineGetFxRatesEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.GET, "/fx-rates");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RateListsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            int n = context.getApiVersion();
            String string = context.getApiBaseUrl();
            String string2 = context.getBrand();
            Duration duration = callTimeout;
            if (duration == null) {
                duration = context.getDefaultCallTimeout();
            }
            return new RateListsApi(n, new EnhancedRateListsApi(string, accessToken, string2, duration), null);
        }

        public static /* synthetic */ RateListsApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RateListsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.RateListsApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

