/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.CapitecPayMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestCapitecPay;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface CapitecPayMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.CAPITEC_PAY;

    @NotNull
    public Optional<AccountPayinRequestCapitecPay> getAccount();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public Optional<String> getSaid();

    @NotNull
    public static Builder builder(CapitecPayMethod copyOf) {
        Builder builder = CapitecPayMethod.builder();
        builder.account(copyOf.getAccount().orElse(null));
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        builder.said(copyOf.getSaid().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new CapitecPayMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestCapitecPay var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public Builder said(String var1);

        public boolean isSaidDefined();

        @NotNull
        public CapitecPayMethod build();
    }
}

